/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.stream.Stream;

public record KeyType(String name) {
    private static final Map<String, KeyType> TYPES = new Object2ObjectArrayMap();
    public static final Codec<KeyType> CODEC = Codec.stringResolver(KeyType::name, TYPES::get);
    public static final KeyType DRAWER = KeyType.register(new KeyType("drawer"));
    public static final KeyType CONCEALMENT = KeyType.register(new KeyType("concealment"));
    public static final KeyType PERSONAL = KeyType.register(new KeyType("personal"));
    public static final KeyType QUANTIFY = KeyType.register(new KeyType("quantify"));

    public static KeyType register(KeyType type) {
        TYPES.put(type.name, type);
        return type;
    }

    public static Stream<KeyType> values() {
        return TYPES.values().stream();
    }
}

