/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.client.model.ItemModelStore;
import com.jaquadro.minecraft.storagedrawers.client.model.ModelContextSupplier;
import com.jaquadro.minecraft.storagedrawers.client.model.ParentModel;
import com.jaquadro.minecraft.storagedrawers.client.model.context.ModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class PlatformDecoratedModel<C extends ModelContext>
extends ParentModel
implements IDynamicBakedModel {
    private final ModelDecorator<C> decorator;
    private final ModelContextSupplier<C> contextSupplier;

    public PlatformDecoratedModel(BakedModel parent, ModelDecorator<C> decorator, ModelContextSupplier<C> contextSupplier) {
        super(parent);
        this.decorator = decorator;
        this.contextSupplier = contextSupplier;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType type) {
        if (state == null) {
            return this.parent.getQuads(state, side, rand, extraData, type);
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Supplier<ModelContext> supplier = () -> this.contextSupplier.makeContext(state, side, rand, extraData, type);
        if (this.decorator.shouldRenderBase(supplier)) {
            quads.addAll(this.parent.getQuads(state, side, rand, extraData, type));
        }
        BiConsumer<BakedModel, RenderType> emitModel = (model, renderType) -> {
            if (model != null && renderType == type) {
                quads.addAll(model.getQuads(state, side, rand, extraData, type));
            }
        };
        try {
            this.decorator.emitQuads(supplier, emitModel);
        }
        catch (Exception e) {
            return quads;
        }
        return quads;
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        return this.parent.getParticleIcon(data);
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of(this.decorator.getRenderTypes(state));
    }

    public RenderType getRenderType(ItemStack itemStack) {
        return this.decorator.getRenderTypes(itemStack).get(0);
    }

    public static class ItemRender<C extends ModelContext>
    extends ParentModel {
        PlatformDecoratedModel<C> parent;
        private ItemStack stack;

        public ItemRender(PlatformDecoratedModel<C> parent, ItemStack stack) {
            super(parent);
            this.parent = parent;
            this.stack = stack;
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            ModelDecorator<ModelContext> decorator = this.parent.decorator;
            Supplier<ModelContext> supplier = () -> this.parent.contextSupplier.makeContext(this.stack);
            if (decorator.shouldRenderBase(supplier, this.stack)) {
                quads.addAll(this.parent.getQuads(state, side, rand));
            }
            BiConsumer<BakedModel, RenderType> emitModel = (model, renderType) -> {
                if (model != null) {
                    quads.addAll(model.getQuads(state, side, rand));
                }
            };
            try {
                decorator.emitItemQuads(supplier, emitModel, this.stack);
            }
            catch (Exception e) {
                return quads;
            }
            return quads;
        }

        public TextureAtlasSprite getParticleIcon(ModelData data) {
            return this.parent.getParticleIcon(data);
        }

        public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
            return this.parent.getRenderTypes(state, rand, data);
        }

        public RenderType getRenderType(ItemStack itemStack) {
            return this.parent.getRenderType(itemStack);
        }
    }

    public static class PlatformDecoratedItemModel
    implements ItemModel {
        ModelResourceLocation location;
        PlatformDecoratedModel<?> parent;
        BakedModel model;
        ItemStack stack;

        public PlatformDecoratedItemModel(ModelResourceLocation location) {
            this.location = location;
        }

        public void update(ItemStackRenderState itemStackRenderState, ItemStack itemStack, ItemModelResolver itemModelResolver, ItemDisplayContext itemDisplayContext, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i) {
            BakedModel stored;
            if (this.parent == null && (stored = ItemModelStore.models.get(this.location)) instanceof PlatformDecoratedModel) {
                PlatformDecoratedModel p;
                this.parent = p = (PlatformDecoratedModel)stored;
            }
            if (!(this.stack != null && ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)itemStack) || this.parent == null)) {
                this.stack = itemStack;
                this.model = new ItemRender(this.parent, itemStack);
            }
            if (this.model != null) {
                ItemStackRenderState.LayerRenderState renderState = itemStackRenderState.newLayer();
                renderState.setupBlockModel(this.model, this.model.getRenderType(this.stack));
            }
        }

        public record Unbaked(ResourceLocation model, String variant) implements ItemModel.Unbaked
        {
            public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(Unbaked::model), (App)Codec.STRING.fieldOf("variant").forGetter(Unbaked::variant)).apply((Applicative)builder, Unbaked::new));

            public MapCodec<? extends ItemModel.Unbaked> type() {
                return MAP_CODEC;
            }

            public ItemModel bake(ItemModel.BakingContext bakingContext) {
                ModelResourceLocation loc = new ModelResourceLocation(this.model, this.variant);
                return new PlatformDecoratedItemModel(loc);
            }

            public void resolveDependencies(ResolvableModel.Resolver resolver) {
                resolver.resolve(this.model);
            }
        }
    }
}

