/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.data.condition.ModLoadedResourceCondition;
import com.supermartijn642.core.data.condition.NotResourceCondition;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer;
import com.supermartijn642.core.generator.AdvancementGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;

public abstract class RecipeGenerator
extends ResourceGenerator {
    private static final Map<ResourceKey<CreativeModeTab>, RecipeCategory> TAB_TO_CATEGORY = new HashMap<ResourceKey<CreativeModeTab>, RecipeCategory>();
    private final Map<ResourceLocation, RecipeBuilder<?>> recipes = new HashMap();
    private final Advancements advancements;

    public RecipeGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
        this.advancements = new Advancements(modid, cache);
    }

    @Override
    public void save() {
        this.advancements.generate();
        for (RecipeBuilder<?> recipeBuilder : this.recipes.values()) {
            JsonObject json = new JsonObject();
            HashMap<String, JsonObject> subRecipes = new HashMap<String, JsonObject>();
            subRecipes.put("", json);
            json.addProperty("type", Registries.RECIPE_SERIALIZERS.getIdentifier(recipeBuilder.serializer).toString());
            if (recipeBuilder instanceof ShapedRecipeBuilder) {
                HashSet<Character> characters = new HashSet<Character>();
                for (String string : ((ShapedRecipeBuilder)recipeBuilder).pattern) {
                    for (char c : string.toCharArray()) {
                        if (c == ' ' || !characters.add(Character.valueOf(c)) || ((ShapedRecipeBuilder)recipeBuilder).inputs.containsKey(Character.valueOf(c))) continue;
                        throw new RuntimeException("Recipe '" + String.valueOf(recipeBuilder.identifier) + "' is missing an input for character '" + c + "'!");
                    }
                }
                for (Character c : ((ShapedRecipeBuilder)recipeBuilder).inputs.keySet()) {
                    if (characters.contains(c)) continue;
                    throw new RuntimeException("Recipe '" + String.valueOf(recipeBuilder.identifier) + "' has unused input with key '" + c + "'!");
                }
                json.addProperty("group", recipeBuilder.group);
                json.add("pattern", (JsonElement)RecipeGenerator.createArray(((ShapedRecipeBuilder)recipeBuilder).pattern));
                JsonObject keysJson = new JsonObject();
                for (Map.Entry<Character, RecipeInput> input : ((ShapedRecipeBuilder)recipeBuilder).inputs.entrySet()) {
                    keysJson.add(input.getKey().toString(), RecipeGenerator.serializeInput(input.getValue()));
                }
                json.add("key", (JsonElement)keysJson);
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("id", Registries.ITEMS.getIdentifier(recipeBuilder.output.asItem()).toString());
                if (recipeBuilder.outputCount != 1) {
                    jsonObject.addProperty("count", (Number)recipeBuilder.outputCount);
                }
                if (recipeBuilder.outputComponents != null && !recipeBuilder.outputComponents.isEmpty()) {
                    jsonObject.add("components", (JsonElement)DataComponentPatch.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipeBuilder.outputComponents).getOrThrow());
                }
                json.add("result", (JsonElement)jsonObject);
            } else if (recipeBuilder instanceof ShapelessRecipeBuilder) {
                json.addProperty("group", recipeBuilder.group);
                JsonArray ingredientsJson = new JsonArray();
                for (RecipeInput recipeInput : ((ShapelessRecipeBuilder)recipeBuilder).inputs) {
                    ingredientsJson.add(RecipeGenerator.serializeInput(recipeInput));
                }
                json.add("ingredients", (JsonElement)ingredientsJson);
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("id", Registries.ITEMS.getIdentifier(recipeBuilder.output.asItem()).toString());
                if (recipeBuilder.outputCount != 1) {
                    resultJson.addProperty("count", (Number)recipeBuilder.outputCount);
                }
                if (recipeBuilder.outputComponents != null && !recipeBuilder.outputComponents.isEmpty()) {
                    resultJson.add("components", (JsonElement)DataComponentPatch.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipeBuilder.outputComponents).getOrThrow());
                }
                json.add("result", (JsonElement)resultJson);
            } else if (recipeBuilder instanceof SmeltingRecipeBuilder) {
                JsonObject recipeJson;
                if (((SmeltingRecipeBuilder)recipeBuilder).includeBlasting) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:blasting");
                    RecipeGenerator.serializeCookingRecipe(recipeJson, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_blasting", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeSmoking) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:smoking");
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_smoking", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeCampfire) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:campfire_cooking");
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_campfire", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeSmelting) {
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 1, 200);
                } else {
                    subRecipes.remove("");
                }
            } else if (recipeBuilder instanceof SmithingRecipeBuilder) {
                json.addProperty("group", recipeBuilder.group);
                json.add("base", RecipeGenerator.serializeInput(((SmithingRecipeBuilder)recipeBuilder).base));
                json.add("addition", RecipeGenerator.serializeInput(((SmithingRecipeBuilder)recipeBuilder).addition));
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("id", Registries.ITEMS.getIdentifier(recipeBuilder.output.asItem()).toString());
                if (recipeBuilder.outputCount != 1) {
                    resultJson.addProperty("count", (Number)recipeBuilder.outputCount);
                }
                if (recipeBuilder.outputComponents != null && !recipeBuilder.outputComponents.isEmpty()) {
                    resultJson.add("components", (JsonElement)DataComponentPatch.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipeBuilder.outputComponents).getOrThrow());
                }
                json.add("result", (JsonElement)resultJson);
            } else if (recipeBuilder instanceof StoneCuttingRecipeBuilder) {
                json.addProperty("group", recipeBuilder.group);
                json.add("ingredient", RecipeGenerator.serializeInput(((StoneCuttingRecipeBuilder)recipeBuilder).input));
                json.addProperty("result", Registries.ITEMS.getIdentifier(recipeBuilder.output.asItem()).toString());
                json.addProperty("count", (Number)recipeBuilder.outputCount);
            }
            for (Map.Entry subRecipe : subRecipes.entrySet()) {
                json = (JsonObject)subRecipe.getValue();
                if (!recipeBuilder.conditions.isEmpty()) {
                    json = ConditionalRecipeSerializer.wrapRecipeWithForgeConditions(json, recipeBuilder.conditions);
                }
                ResourceLocation resourceLocation = recipeBuilder.identifier;
                this.cache.saveJsonResource(ResourceType.DATA, json, resourceLocation.getNamespace(), "recipe", resourceLocation.getPath() + (String)subRecipe.getKey());
            }
        }
        this.advancements.save();
    }

    private static void serializeCookingRecipe(JsonObject json, SmeltingRecipeBuilder recipeBuilder, int durationDivider, int defaultDuration) {
        int duration;
        json.addProperty("group", recipeBuilder.group);
        json.add("ingredient", RecipeGenerator.serializeInput(recipeBuilder.input));
        if ((recipeBuilder.outputComponents == null || recipeBuilder.outputComponents.isEmpty()) && recipeBuilder.outputCount == 1) {
            json.addProperty("result", Registries.ITEMS.getIdentifier(recipeBuilder.output.asItem()).toString());
        } else {
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("id", Registries.ITEMS.getIdentifier(recipeBuilder.output.asItem()).toString());
            if (recipeBuilder.outputCount != 1) {
                resultJson.addProperty("count", (Number)recipeBuilder.outputCount);
            }
            if (recipeBuilder.outputComponents != null && !recipeBuilder.outputComponents.isEmpty()) {
                resultJson.add("components", (JsonElement)DataComponentPatch.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipeBuilder.outputComponents).getOrThrow());
            }
            json.add("result", (JsonElement)resultJson);
        }
        if (recipeBuilder.experience != 0) {
            json.addProperty("experience", (Number)recipeBuilder.experience);
        }
        if ((duration = recipeBuilder.duration / durationDivider) != defaultDuration) {
            json.addProperty("cookingtime", (Number)duration);
        }
    }

    private static JsonArray createArray(Iterable<String> elements) {
        JsonArray array = new JsonArray();
        for (String element : elements) {
            array.add(element);
        }
        return array;
    }

    private static JsonElement serializeInput(RecipeInput input) {
        if (input.entries.size() == 1) {
            return RecipeGenerator.serializeInputEntry(input.entries.getFirst());
        }
        JsonArray entries = new JsonArray();
        for (RecipeInput.Entry entry : input.entries) {
            entries.add(RecipeGenerator.serializeInputEntry(entry));
        }
        return entries;
    }

    private static JsonElement serializeInputEntry(RecipeInput.Entry entry) {
        if (entry.item != null) {
            return new JsonPrimitive(Registries.ITEMS.getIdentifier(entry.item.asItem()).toString());
        }
        return new JsonPrimitive("#" + entry.tag.toString());
    }

    protected <T extends RecipeBuilder<T>> T recipe(ResourceLocation recipeLocation, T builder) {
        if (this.recipes.containsKey(recipeLocation)) {
            throw new RuntimeException("Duplicate recipe '" + String.valueOf(recipeLocation) + "' of types '" + this.recipes.get(recipeLocation).getClass().getName() + "' and '" + builder.getClass().getName() + "'!");
        }
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, builder.identifier.getNamespace(), "recipe", builder.identifier.getPath(), ".json");
        this.recipes.put(recipeLocation, builder);
        return builder;
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, ItemLike output, DataComponentPatch components, int amount) {
        return this.recipe(recipeLocation, new ShapedRecipeBuilder(recipeLocation, output, components, amount));
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, ItemLike output, DataComponentPatch components, int amount) {
        return this.shaped(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, components, amount);
    }

    protected ShapedRecipeBuilder shaped(String identifier, ItemLike output, DataComponentPatch components, int amount) {
        return this.shaped(this.modid, identifier, output, components, amount);
    }

    protected ShapedRecipeBuilder shaped(ItemLike output, DataComponentPatch components, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.asItem());
        return this.recipe(identifier, new ShapedRecipeBuilder(identifier, output, components, amount));
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, ItemLike output, int amount) {
        return this.shaped(recipeLocation, output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, ItemLike output, int amount) {
        return this.shaped(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(String identifier, ItemLike output, int amount) {
        return this.shaped(this.modid, identifier, output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(ItemLike output, int amount) {
        return this.shaped(output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, ItemLike output) {
        return this.shaped(recipeLocation, output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, ItemLike output) {
        return this.shaped(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(String identifier, ItemLike output) {
        return this.shaped(this.modid, identifier, output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(ItemLike output) {
        return this.shaped(output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, ItemStack output) {
        return this.shaped(recipeLocation, (ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, ItemStack output) {
        return this.shaped(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), (ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected ShapedRecipeBuilder shaped(String identifier, ItemStack output) {
        return this.shaped(this.modid, identifier, (ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected ShapedRecipeBuilder shaped(ItemStack output) {
        return this.shaped((ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, ItemLike output, DataComponentPatch components, int amount) {
        return this.recipe(recipeLocation, new ShapelessRecipeBuilder(recipeLocation, output, components, amount));
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, ItemLike output, DataComponentPatch components, int amount) {
        return this.shapeless(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, components, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, ItemLike output, DataComponentPatch components, int amount) {
        return this.shapeless(this.modid, identifier, output, components, amount);
    }

    protected ShapelessRecipeBuilder shapeless(ItemLike output, DataComponentPatch components, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.asItem());
        return this.shapeless(identifier, output, components, amount);
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, ItemLike output, int amount) {
        return this.shapeless(recipeLocation, output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, ItemLike output, int amount) {
        return this.shapeless(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, ItemLike output, int amount) {
        return this.shapeless(this.modid, identifier, output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(ItemLike output, int amount) {
        return this.shapeless(output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, ItemLike output) {
        return this.shapeless(recipeLocation, output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, ItemLike output) {
        return this.shapeless(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, ItemLike output) {
        return this.shapeless(this.modid, identifier, output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(ItemLike output) {
        return this.shapeless(output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, ItemStack output) {
        return this.shapeless(recipeLocation, (ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, ItemStack output) {
        return this.shapeless(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), (ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, ItemStack output) {
        return this.shapeless(this.modid, identifier, (ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected ShapelessRecipeBuilder shapeless(ItemStack output) {
        return this.shapeless((ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, ItemLike output, DataComponentPatch components, int amount) {
        return this.recipe(recipeLocation, new SmeltingRecipeBuilder(recipeLocation, output, components, amount)).includeSmelting();
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, ItemLike output, DataComponentPatch components, int amount) {
        return this.smelting(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, components, amount);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, ItemLike output, DataComponentPatch components, int amount) {
        return this.smelting(this.modid, identifier, output, components, amount);
    }

    protected SmeltingRecipeBuilder smelting(ItemLike output, DataComponentPatch components, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.asItem());
        return this.smelting(identifier, output, components, amount);
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, ItemLike output, int amount) {
        return this.smelting(recipeLocation, output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, ItemLike output, int amount) {
        return this.smelting(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, ItemLike output, int amount) {
        return this.smelting(this.modid, identifier, output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(ItemLike output, int amount) {
        return this.smelting(output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, ItemLike output) {
        return this.smelting(recipeLocation, output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, ItemLike output) {
        return this.smelting(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, ItemLike output) {
        return this.smelting(this.modid, identifier, output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(ItemLike output) {
        return this.smelting(output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, ItemStack output) {
        return this.smelting(recipeLocation, (ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, ItemStack output) {
        return this.smelting(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), (ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected SmeltingRecipeBuilder smelting(String identifier, ItemStack output) {
        return this.smelting(this.modid, identifier, (ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected SmeltingRecipeBuilder smelting(ItemStack output) {
        return this.smelting((ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected SmithingRecipeBuilder smithing(ResourceLocation recipeLocation, ItemLike output, DataComponentPatch components, int amount) {
        return this.recipe(recipeLocation, new SmithingRecipeBuilder(recipeLocation, output, components, amount));
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, ItemLike output, DataComponentPatch components, int amount) {
        return this.smithing(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, components, amount);
    }

    protected SmithingRecipeBuilder smithing(String identifier, ItemLike output, DataComponentPatch components, int amount) {
        return this.smithing(this.modid, identifier, output, components, amount);
    }

    protected SmithingRecipeBuilder smithing(ItemLike output, DataComponentPatch components, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.asItem());
        return this.smithing(identifier, output, components, amount);
    }

    protected SmithingRecipeBuilder smithing(ResourceLocation recipeLocation, ItemLike output, int amount) {
        return this.smithing(recipeLocation, output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, ItemLike output, int amount) {
        return this.smithing(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(String identifier, ItemLike output, int amount) {
        return this.smithing(this.modid, identifier, output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(ItemLike output, int amount) {
        return this.smithing(output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(ResourceLocation recipeLocation, ItemLike output) {
        return this.smithing(recipeLocation, output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, ItemLike output) {
        return this.smithing(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(String identifier, ItemLike output) {
        return this.smithing(this.modid, identifier, output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(ItemLike output) {
        return this.smithing(output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(ResourceLocation recipeLocation, ItemStack output) {
        return this.smithing(recipeLocation, (ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, ItemStack output) {
        return this.smithing(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), (ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected SmithingRecipeBuilder smithing(String identifier, ItemStack output) {
        return this.smithing(this.modid, identifier, (ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected SmithingRecipeBuilder smithing(ItemStack output) {
        return this.smithing((ItemLike)output.getItem(), output.getComponentsPatch(), output.getCount());
    }

    protected StoneCuttingRecipeBuilder stoneCutting(ResourceLocation recipeLocation, ItemLike output, int amount) {
        return this.recipe(recipeLocation, new StoneCuttingRecipeBuilder(recipeLocation, output, amount));
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String namespace, String identifier, ItemLike output, int amount) {
        return this.stoneCutting(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String identifier, ItemLike output, int amount) {
        return this.stoneCutting(this.modid, identifier, output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(ItemLike output, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.asItem());
        return this.stoneCutting(identifier, output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(ResourceLocation recipeLocation, ItemLike output) {
        return this.stoneCutting(recipeLocation, output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String namespace, String identifier, ItemLike output) {
        return this.stoneCutting(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String identifier, ItemLike output) {
        return this.stoneCutting(this.modid, identifier, output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(ItemLike output) {
        return this.stoneCutting(output, 1);
    }

    @Override
    public String getName() {
        return this.modName + " Recipe Generator";
    }

    static {
        TAB_TO_CATEGORY.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, RecipeCategory.BUILDING_BLOCKS);
        TAB_TO_CATEGORY.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT, RecipeCategory.COMBAT);
        TAB_TO_CATEGORY.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, RecipeCategory.BUILDING_BLOCKS);
        TAB_TO_CATEGORY.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, RecipeCategory.FOOD);
        TAB_TO_CATEGORY.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, RecipeCategory.BUILDING_BLOCKS);
        TAB_TO_CATEGORY.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, RecipeCategory.MISC);
        TAB_TO_CATEGORY.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, RecipeCategory.DECORATIONS);
        TAB_TO_CATEGORY.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, RecipeCategory.REDSTONE);
        TAB_TO_CATEGORY.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.OP_BLOCKS, RecipeCategory.MISC);
        TAB_TO_CATEGORY.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.SPAWN_EGGS, RecipeCategory.MISC);
        TAB_TO_CATEGORY.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, RecipeCategory.TOOLS);
        TAB_TO_CATEGORY.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.SEARCH, RecipeCategory.MISC);
    }

    private final class Advancements
    extends AdvancementGenerator {
        public Advancements(String modid, ResourceCache cache) {
            super(modid, cache);
        }

        @Override
        public void generate() {
            for (RecipeBuilder<?> recipe : RecipeGenerator.this.recipes.values()) {
                if (!recipe.hasAdvancement) continue;
                Item outputItem = recipe.output.asItem();
                String category = RecipeCategory.MISC.getFolderName();
                for (CreativeModeTab tab : CreativeModeTabs.allTabs()) {
                    ResourceKey key;
                    if (!tab.contains(outputItem.getDefaultInstance()) || (key = (ResourceKey)BuiltInRegistries.CREATIVE_MODE_TAB.getResourceKey((Object)tab).orElse(null)) == null) continue;
                    category = TAB_TO_CATEGORY.containsKey(key) ? TAB_TO_CATEGORY.get(key).getFolderName() : key.location().getPath();
                }
                String namespace = recipe.identifier.getNamespace();
                String identifier = "recipes/" + category + "/" + recipe.identifier.getPath();
                if (recipe instanceof SmeltingRecipeBuilder) {
                    if (((SmeltingRecipeBuilder)recipe).includeSmelting) {
                        this.createAdvancement(namespace, identifier + "_smelting", recipe);
                    }
                    if (((SmeltingRecipeBuilder)recipe).includeBlasting) {
                        this.createAdvancement(namespace, identifier + "_blasting", recipe);
                    }
                    if (((SmeltingRecipeBuilder)recipe).includeSmoking) {
                        this.createAdvancement(namespace, identifier + "_smoking", recipe);
                    }
                    if (!((SmeltingRecipeBuilder)recipe).includeCampfire) continue;
                    this.createAdvancement(namespace, identifier + "_campfire", recipe);
                    continue;
                }
                this.createAdvancement(namespace, identifier, recipe);
            }
        }

        private void createAdvancement(String namespace, String identifier, RecipeBuilder<?> recipe) {
            AdvancementGenerator.AdvancementBuilder builder = this.advancement(namespace, identifier).parent(net.minecraft.data.recipes.RecipeBuilder.ROOT_RECIPE_ADVANCEMENT).criterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceKey)ResourceKey.create((ResourceKey)net.minecraft.core.registries.Registries.RECIPE, (ResourceLocation)recipe.identifier))).icon(recipe.output, recipe.outputComponents).dontShowToast().dontAnnounceToChat().rewardRecipe(recipe.identifier);
            String[] triggers = new String[recipe.unlockedBy.size() + 1];
            triggers[0] = "has_the_recipe";
            if (recipe.unlockedBy.size() == 1) {
                Pair<CriterionTrigger<?>, CriterionTriggerInstance> criterion = recipe.unlockedBy.get(0);
                builder.criterion("recipe_condition", new Criterion(criterion.left(), criterion.right()));
                triggers[1] = "recipe_condition";
            } else {
                for (int i = 0; i < recipe.unlockedBy.size(); ++i) {
                    Pair<CriterionTrigger<?>, CriterionTriggerInstance> criterion = recipe.unlockedBy.get(i);
                    builder.criterion("recipe_condition" + (i + 1), new Criterion(criterion.left(), criterion.right()));
                    triggers[i + 1] = "recipe_condition" + (i + 1);
                }
            }
            builder.requirementGroup(triggers);
            recipe.conditions.forEach(builder::condition);
        }
    }

    public static abstract class RecipeBuilder<T extends RecipeBuilder<T>> {
        protected final ResourceLocation identifier;
        private final List<ICondition> conditions = new ArrayList<ICondition>();
        private final ItemLike output;
        private final DataComponentPatch outputComponents;
        private final int outputCount;
        private RecipeSerializer<?> serializer;
        private String group;
        private boolean hasAdvancement = true;
        private final List<Pair<CriterionTrigger<?>, CriterionTriggerInstance>> unlockedBy = new ArrayList();

        protected RecipeBuilder(ResourceLocation identifier, RecipeSerializer<?> serializer, ItemLike output, DataComponentPatch outputComponents, int outputCount) {
            this.identifier = identifier;
            this.output = output;
            this.outputComponents = outputComponents;
            this.outputCount = outputCount;
            this.serializer = serializer;
        }

        public T group(String group) {
            this.group = group == null || group.trim().isEmpty() ? null : group;
            return this.self();
        }

        public T condition(ICondition condition) {
            this.conditions.add(condition);
            return this.self();
        }

        public T condition(ResourceCondition condition) {
            return this.condition(ResourceCondition.createForgeCondition(condition));
        }

        public T notCondition(ICondition condition) {
            return this.condition(new NotResourceCondition(condition));
        }

        public T notCondition(ResourceCondition condition) {
            return this.condition(new NotResourceCondition(condition));
        }

        public T modLoadedCondition(String modid) {
            return this.condition(new ModLoadedResourceCondition(modid));
        }

        public T advancement(boolean generate) {
            this.hasAdvancement = generate;
            return this.self();
        }

        public T noAdvancement() {
            return this.advancement(false);
        }

        public <S extends CriterionTriggerInstance> T unlockedBy(CriterionTrigger<S> trigger, S instance) {
            this.unlockedBy.add(Pair.of(trigger, instance));
            return this.self();
        }

        public <S extends CriterionTriggerInstance> T unlockedBy(Criterion<S> criterion) {
            return this.unlockedBy(criterion.trigger(), criterion.triggerInstance());
        }

        public T unlockedBy(ItemLike ... items) {
            return this.unlockedBy(InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
        }

        public T unlockedBy(TagKey<Item> tagKey) {
            return this.unlockedBy(InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of((HolderGetter)ResourceGenerator.registryAccess.lookupOrThrow(net.minecraft.core.registries.Registries.ITEM), tagKey).build()}));
        }

        public T customSerializer(RecipeSerializer<?> serializer) {
            this.serializer = serializer;
            return this.self();
        }

        private T self() {
            return (T)this;
        }
    }

    protected static class ShapedRecipeBuilder
    extends RecipeBuilder<ShapedRecipeBuilder> {
        private final List<String> pattern = new ArrayList<String>();
        private final Map<Character, RecipeInput> inputs = new HashMap<Character, RecipeInput>();

        private ShapedRecipeBuilder(ResourceLocation identifier, ItemLike output, DataComponentPatch outputComponents, int outputCount) {
            super(identifier, RecipeSerializer.SHAPED_RECIPE, output, outputComponents, outputCount);
        }

        public ShapedRecipeBuilder pattern(String row) {
            if (row.isEmpty()) {
                throw new IllegalArgumentException("Pattern row for recipe '" + String.valueOf(this.identifier) + "' cannot be empty!");
            }
            if (row.length() > 3) {
                throw new IllegalArgumentException("Pattern row for recipe '" + String.valueOf(this.identifier) + "' can have at most 3 characters, not '" + row.length() + "'!");
            }
            for (String otherRow : this.pattern) {
                if (row.length() == otherRow.length()) continue;
                throw new IllegalArgumentException("Pattern rows for recipe '" + String.valueOf(this.identifier) + "' must have the same length!");
            }
            this.pattern.add(row);
            return this;
        }

        public ShapedRecipeBuilder pattern(String ... rows) {
            for (String row : rows) {
                this.pattern(row);
            }
            return this;
        }

        private ShapedRecipeBuilder input(char key, RecipeInput input) {
            if (this.inputs.containsKey(Character.valueOf(key))) {
                throw new RuntimeException("Duplicate key '" + key + "' for recipe '" + String.valueOf(this.identifier) + "'!");
            }
            this.inputs.put(Character.valueOf(key), input);
            return this;
        }

        public ShapedRecipeBuilder input(char key, ItemLike ... items) {
            return this.input(key, RecipeInput.of(items));
        }

        public ShapedRecipeBuilder input(char key, ItemStack ... itemStacks) {
            return this.input(key, RecipeInput.of(itemStacks));
        }

        public ShapedRecipeBuilder input(char key, TagKey<Item> tag) {
            return this.input(key, RecipeInput.of(tag));
        }
    }

    private record RecipeInput(List<Entry> entries) {
        static RecipeInput of(ItemLike ... items) {
            return new RecipeInput(Arrays.stream(items).map(i -> new Entry((ItemLike)i, null)).toList());
        }

        static RecipeInput of(ItemStack ... stacks) {
            return RecipeInput.of((ItemLike[])Arrays.stream(stacks).map(ItemStack::getItem).toArray(ItemLike[]::new));
        }

        static RecipeInput of(ResourceLocation tag) {
            return new RecipeInput(List.of(new Entry(null, tag)));
        }

        static RecipeInput of(TagKey<Item> tag) {
            return RecipeInput.of(tag.location());
        }

        private record Entry(ItemLike item, ResourceLocation tag) {
        }
    }

    protected static class ShapelessRecipeBuilder
    extends RecipeBuilder<ShapelessRecipeBuilder> {
        private final List<RecipeInput> inputs = new ArrayList<RecipeInput>();

        private ShapelessRecipeBuilder(ResourceLocation identifier, ItemLike output, DataComponentPatch outputComponents, int outputCount) {
            super(identifier, RecipeSerializer.SHAPELESS_RECIPE, output, outputComponents, outputCount);
        }

        private ShapelessRecipeBuilder input(RecipeInput input, int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("Cannot add an ingredient '" + count + "' times to recipe '" + String.valueOf(this.identifier) + "'!");
            }
            if (this.inputs.size() + count > 9) {
                throw new RuntimeException("Recipe '" + String.valueOf(this.identifier) + "' can have at most 9 inputs!");
            }
            for (int i = 0; i < count; ++i) {
                this.inputs.add(input);
            }
            return this;
        }

        public ShapelessRecipeBuilder input(ItemLike item, int count) {
            return this.input(RecipeInput.of(item), count);
        }

        public ShapelessRecipeBuilder input(ItemLike item) {
            return this.input(item, 1);
        }

        public ShapelessRecipeBuilder input(ItemStack itemStack, int count) {
            return this.input(RecipeInput.of(itemStack), count);
        }

        public ShapelessRecipeBuilder input(ItemStack itemStack) {
            return this.input(itemStack, 1);
        }

        public ShapelessRecipeBuilder input(TagKey<Item> tag, int count) {
            return this.input(RecipeInput.of(tag), count);
        }

        public ShapelessRecipeBuilder input(TagKey<Item> tag) {
            return this.input(RecipeInput.of(tag), 1);
        }

        public ShapelessRecipeBuilder inputs(ItemLike ... items) {
            for (ItemLike item : items) {
                this.input(item);
            }
            return this;
        }

        public ShapelessRecipeBuilder inputs(ItemStack ... itemStacks) {
            for (ItemStack itemStack : itemStacks) {
                this.input(itemStack);
            }
            return this;
        }
    }

    protected static class SmeltingRecipeBuilder
    extends RecipeBuilder<SmeltingRecipeBuilder> {
        private boolean includeSmelting;
        private boolean includeBlasting;
        private boolean includeCampfire;
        private boolean includeSmoking;
        private RecipeInput input;
        private int experience;
        private int duration = 200;

        private SmeltingRecipeBuilder(ResourceLocation identifier, ItemLike output, DataComponentPatch outputComponents, int count) {
            super(identifier, RecipeSerializer.SMELTING_RECIPE, output, outputComponents, count);
        }

        public SmeltingRecipeBuilder includeSmelting(boolean includeSmelting) {
            this.includeSmelting = includeSmelting;
            return this;
        }

        public SmeltingRecipeBuilder includeSmelting() {
            return this.includeSmelting(true);
        }

        public SmeltingRecipeBuilder includeBlasting(boolean includeBlasting) {
            this.includeBlasting = includeBlasting;
            return this;
        }

        public SmeltingRecipeBuilder includeBlasting() {
            return this.includeBlasting(true);
        }

        public SmeltingRecipeBuilder includeCampfire(boolean includeCampfire) {
            this.includeCampfire = includeCampfire;
            return this;
        }

        public SmeltingRecipeBuilder includeCampfire() {
            return this.includeCampfire(true);
        }

        public SmeltingRecipeBuilder includeSmoking(boolean includeSmoking) {
            this.includeSmoking = includeSmoking;
            return this;
        }

        public SmeltingRecipeBuilder includeSmoking() {
            return this.includeSmoking(true);
        }

        private SmeltingRecipeBuilder input(RecipeInput input) {
            this.input = input;
            return this;
        }

        public SmeltingRecipeBuilder input(ItemLike ... items) {
            return this.input(RecipeInput.of(items));
        }

        public SmeltingRecipeBuilder input(ItemStack ... itemStacks) {
            return this.input(RecipeInput.of(itemStacks));
        }

        public SmeltingRecipeBuilder input(TagKey<Item> tag) {
            return this.input(RecipeInput.of(tag));
        }

        public SmeltingRecipeBuilder experience(int experience) {
            if (experience < 0) {
                throw new IllegalArgumentException("Experience for recipe '" + String.valueOf(this.identifier) + "' cannot be negative!");
            }
            this.experience = experience;
            return this;
        }

        public SmeltingRecipeBuilder duration(int ticks) {
            if (ticks <= 0) {
                throw new IllegalArgumentException("Duration for recipe '" + String.valueOf(this.identifier) + "' must be greater than 0!");
            }
            this.duration = ticks;
            return this;
        }

        public SmeltingRecipeBuilder durationSeconds(int seconds) {
            return this.duration(seconds * 20);
        }
    }

    protected static class SmithingRecipeBuilder
    extends RecipeBuilder<SmithingRecipeBuilder> {
        private RecipeInput base;
        private RecipeInput addition;

        private SmithingRecipeBuilder(ResourceLocation identifier, ItemLike output, DataComponentPatch outputComponents, int outputCount) {
            super(identifier, RecipeSerializer.SMITHING_TRANSFORM, output, outputComponents, outputCount);
        }

        private SmithingRecipeBuilder base(RecipeInput input) {
            this.base = input;
            return this;
        }

        public SmithingRecipeBuilder base(ItemLike ... items) {
            return this.base(RecipeInput.of(items));
        }

        public SmithingRecipeBuilder base(ItemStack ... itemStacks) {
            return this.base(RecipeInput.of(itemStacks));
        }

        public SmithingRecipeBuilder base(TagKey<Item> tag) {
            return this.base(RecipeInput.of(tag));
        }

        private SmithingRecipeBuilder addition(RecipeInput input) {
            this.addition = input;
            return this;
        }

        public SmithingRecipeBuilder addition(ItemLike ... items) {
            return this.addition(RecipeInput.of(items));
        }

        public SmithingRecipeBuilder addition(ItemStack ... itemStacks) {
            return this.addition(RecipeInput.of(itemStacks));
        }

        public SmithingRecipeBuilder addition(TagKey<Item> tag) {
            return this.addition(RecipeInput.of(tag));
        }
    }

    protected static class StoneCuttingRecipeBuilder
    extends RecipeBuilder<StoneCuttingRecipeBuilder> {
        private RecipeInput input;

        private StoneCuttingRecipeBuilder(ResourceLocation identifier, ItemLike output, int outputCount) {
            super(identifier, RecipeSerializer.STONECUTTER, output, null, outputCount);
        }

        private StoneCuttingRecipeBuilder input(RecipeInput input) {
            this.input = input;
            return this;
        }

        public StoneCuttingRecipeBuilder input(ItemLike ... items) {
            return this.input(RecipeInput.of(items));
        }

        public StoneCuttingRecipeBuilder input(ItemStack ... itemStacks) {
            return this.input(RecipeInput.of(itemStacks));
        }

        public StoneCuttingRecipeBuilder input(TagKey<Item> tag) {
            return this.input(RecipeInput.of(tag));
        }
    }
}

