/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.extensions.CoreLibModelBakery;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelBakery.class})
public class ModelBakeryMixin
implements CoreLibModelBakery {
    @Unique
    private Map<ResourceLocation, Function<BakedModel, BakedModel>> modelOverwrites;
    @Unique
    private Set<ResourceLocation> missingOverwriteModels;

    @Override
    public Function<BakedModel, BakedModel> supermartijn642corelibGetModelOverwrite(ResourceLocation location) {
        if (this.modelOverwrites == null) {
            return null;
        }
        this.missingOverwriteModels.remove(location);
        return this.modelOverwrites.get(location);
    }

    @Inject(method={"bakeModels"}, at={@At(value="HEAD")})
    private void bakeModelsHead(CallbackInfoReturnable<?> ci) {
        try {
            this.modelOverwrites = ClientRegistrationHandler.gatherModelOverwritesInternal();
            this.missingOverwriteModels = new HashSet<ResourceLocation>(this.modelOverwrites.keySet());
        }
        catch (Exception e) {
            CoreLib.LOGGER.error("Encountered an error while applying model overwrites!", (Throwable)e);
        }
    }

    @Inject(method={"bakeModels"}, at={@At(value="RETURN")})
    private void bakeModelsTail(ModelBakery.TextureGetter textureGetter, CallbackInfoReturnable<ModelBakery.BakingResult> ci) {
        try {
            ModelBakery modelBakery = (ModelBakery)this;
            ClientRegistrationHandler.applyModelConsumersInternal(location -> {
                ModelBakery modelBakery2 = modelBakery;
                Objects.requireNonNull(modelBakery2);
                return new ModelBakery.ModelBakerImpl(modelBakery2, textureGetter, () -> ((ResourceLocation)location).toString()).bake(location, (ModelState)BlockModelRotation.X0_Y0);
            });
            ModelBakery.BakingResult bakingResults = (ModelBakery.BakingResult)ci.getReturnValue();
            Map<ResourceLocation, Function<BakedModel, BakedModel>> blockOverwrites = ClientRegistrationHandler.gatherBlockModelOverwritesInternal();
            Map blockModels = bakingResults.blockStateModels();
            HashSet<ResourceLocation> missingModels = new HashSet<ResourceLocation>(blockOverwrites.keySet());
            for (ModelResourceLocation location2 : blockModels.keySet()) {
                BakedModel model;
                Function<BakedModel, BakedModel> overwrite = blockOverwrites.get(location2.id());
                if (overwrite == null) continue;
                missingModels.remove(location2.id());
                try {
                    model = overwrite.apply((BakedModel)blockModels.get(location2));
                }
                catch (Exception e) {
                    CoreLib.LOGGER.error("Encountered an error while applying block model overwrite for block state '{}'!", (Object)location2, (Object)e);
                    continue;
                }
                if (model == null) {
                    CoreLib.LOGGER.error("Block model overwrite for block state '{}' returned null!", (Object)location2);
                    continue;
                }
                blockModels.put(location2, model);
            }
            if (!missingModels.isEmpty()) {
                CoreLib.LOGGER.error("Missing models for block model overwrites: {}", (Object)missingModels.stream().map(l -> "'" + String.valueOf(l) + "'").collect(Collectors.joining(", ")));
            }
            Map<ResourceLocation, Function<ItemModel, ItemModel>> itemOverwrites = ClientRegistrationHandler.gatherItemModelOverwritesInternal();
            Map itemModels = bakingResults.itemStackModels();
            missingModels = new HashSet<ResourceLocation>(itemOverwrites.keySet());
            for (Map.Entry<ResourceLocation, Function<ItemModel, ItemModel>> entry : itemOverwrites.entrySet()) {
                ResourceLocation location3 = entry.getKey();
                ItemModel model = (ItemModel)itemModels.get(location3);
                if (model == null) {
                    missingModels.add(location3);
                    continue;
                }
                try {
                    model = entry.getValue().apply((ItemModel)itemModels.get(location3));
                }
                catch (Exception e) {
                    CoreLib.LOGGER.error("Encountered an error while applying item model overwrite for item '{}'!", (Object)location3, (Object)e);
                    continue;
                }
                if (model == null) {
                    CoreLib.LOGGER.error("Item model overwrite for item '{}' returned null!", (Object)location3);
                    continue;
                }
                itemModels.put(location3, model);
            }
            if (!missingModels.isEmpty()) {
                CoreLib.LOGGER.error("Missing models for item model overwrites: {}", (Object)missingModels.stream().map(l -> "'" + String.valueOf(l) + "'").collect(Collectors.joining(", ")));
            }
            if (!this.missingOverwriteModels.isEmpty()) {
                CoreLib.LOGGER.error("Missing models for model overwrites: {}", (Object)this.missingOverwriteModels.stream().map(l -> "'" + String.valueOf(l) + "'").collect(Collectors.joining(", ")));
            }
            this.modelOverwrites = Map.of();
            this.missingOverwriteModels = null;
        }
        catch (Exception e) {
            CoreLib.LOGGER.error("Encountered an error while applying model overwrites!", (Throwable)e);
        }
    }
}

