/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import java.util.Map;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ClientItemInfoLoader;
import net.minecraft.client.resources.model.ModelDiscovery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelManager.class})
public class ModelManagerMixin {
    @Inject(method={"discoverModelDependencies"}, at={@At(value="RETURN")})
    private static void discoverModelDependencies(UnbakedModel missingModel, Map<ResourceLocation, UnbakedModel> models, BlockStateModelLoader.LoadedModels blockStates, ClientItemInfoLoader.LoadedClientInfos itemInfos, CallbackInfoReturnable<ModelDiscovery> ci) {
        ModelDiscovery modelDiscovery = (ModelDiscovery)ci.getReturnValue();
        ModelDiscovery.ResolverImpl resolver = new ModelDiscovery.ResolverImpl(modelDiscovery);
        for (ResourceLocation model : ClientRegistrationHandler.getModelConsumerLocations()) {
            if (!models.containsKey(model)) {
                CoreLib.LOGGER.warn("Missing model for model consumer: {}", (Object)model);
            }
            resolver.resolve(model);
        }
    }
}

