/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants;

import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.FinalizeItemComponentsCallback;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.entity.living.ComputeEnchantedLootBonusCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.ShieldBlockCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.level.BlockEvents;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.universalenchants.config.ServerConfig;
import fuzs.universalenchants.handler.BetterEnchantsHandler;
import fuzs.universalenchants.handler.ItemCompatHandler;
import fuzs.universalenchants.init.ModRegistry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UniversalEnchants
implements ModConstructor {
    public static final String MOD_ID = "universalenchants";
    public static final String MOD_NAME = "Universal Enchants";
    public static final Logger LOGGER = LogManager.getLogger((String)"Universal Enchants");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"universalenchants").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.bootstrap();
        UniversalEnchants.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        FinalizeItemComponentsCallback.EVENT.register((item, consumer) -> {
            if (item instanceof ShearsItem || item instanceof ShieldItem) {
                consumer.accept(components -> DataComponentPatch.builder().set(DataComponents.ENCHANTABLE, (Object)new Enchantable(1)).build());
            } else if (item instanceof AnimalArmorItem) {
                consumer.accept(components -> {
                    ItemAttributeModifiers itemAttributeModifiers = (ItemAttributeModifiers)components.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
                    double defenseValue = itemAttributeModifiers.modifiers().stream().filter(entry -> entry.attribute().is(Attributes.ARMOR)).map(ItemAttributeModifiers.Entry::modifier).mapToDouble(AttributeModifier::amount).sum();
                    return DataComponentPatch.builder().set(DataComponents.ENCHANTABLE, (Object)new Enchantable(Math.max(1, Mth.ceil((double)defenseValue)))).build();
                });
            }
        });
        TagsUpdatedCallback.EVENT.register(ItemCompatHandler::onTagsUpdated);
        UseItemEvents.TICK.register(ItemCompatHandler::onUseItemTick);
        ComputeEnchantedLootBonusCallback.EVENT.register(ItemCompatHandler::onComputeEnchantedLootBonus);
        LivingHurtCallback.EVENT.register(BetterEnchantsHandler::onLivingHurt);
        BlockEvents.FARMLAND_TRAMPLE.register(BetterEnchantsHandler::onFarmlandTrample);
        ShieldBlockCallback.EVENT.register(ItemCompatHandler::onShieldBlock);
        LivingExperienceDropCallback.EVENT.register(EventPhase.AFTER, BetterEnchantsHandler::onLivingExperienceDrop);
        BlockEvents.DROP_EXPERIENCE.register(EventPhase.AFTER, BetterEnchantsHandler::onDropExperience);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

