/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.handler;

import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.universalenchants.init.CompositeHolderSet;
import fuzs.universalenchants.init.ModRegistry;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemCompatHandler {
    private static final Set<EquipmentSlotGroup> ARMOR_EQUIPMENT_SLOT_GROUPS = Set.of(EquipmentSlotGroup.FEET, EquipmentSlotGroup.LEGS, EquipmentSlotGroup.CHEST, EquipmentSlotGroup.HEAD, EquipmentSlotGroup.ARMOR);

    public static void onTagsUpdated(HolderLookup.Provider registries, boolean client) {
        HolderLookup.RegistryLookup itemLookup = registries.lookupOrThrow(Registries.ITEM);
        HolderLookup.RegistryLookup enchantmentLookup = registries.lookupOrThrow(Registries.ENCHANTMENT);
        enchantmentLookup.listElements().forEach(holder -> {
            Enchantment enchantment = (Enchantment)holder.value();
            Enchantment.EnchantmentDefinition enchantmentDefinition = enchantment.definition();
            if (!enchantmentDefinition.slots().contains(EquipmentSlotGroup.BODY)) {
                for (EquipmentSlotGroup slot : enchantmentDefinition.slots()) {
                    if (!ARMOR_EQUIPMENT_SLOT_GROUPS.contains(slot)) continue;
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.addAll((Iterable)enchantmentDefinition.slots());
                    builder.add((Object)EquipmentSlotGroup.BODY);
                    enchantmentDefinition.slots = builder.build();
                }
            }
            ItemCompatHandler.setEnchantmentProperty(enchantmentLookup, ModRegistry.getInclusiveSetEnchantmentTag((ResourceKey<Enchantment>)holder.key()), enchantment.exclusiveSet(), holderSet -> {
                enchantment.exclusiveSet = holderSet;
            }, CompositeHolderSet.Removal::new);
            ItemCompatHandler.setSupportedEnchantmentItems(itemLookup, ModRegistry.getSecondaryEnchantableItemTag((ResourceKey<Enchantment>)holder.key()), enchantmentDefinition.supportedItems(), holderSet -> {
                enchantmentDefinition.supportedItems = holderSet;
            });
            enchantmentDefinition.primaryItems().ifPresent(holderSetX -> ItemCompatHandler.setSupportedEnchantmentItems(itemLookup, ModRegistry.getPrimaryEnchantableItemTag((ResourceKey<Enchantment>)holder.key()), holderSetX, holderSet -> {
                enchantmentDefinition.primaryItems = Optional.of(holderSet);
            }));
        });
    }

    private static <T> void setSupportedEnchantmentItems(HolderLookup.RegistryLookup<T> registryLookup, TagKey<T> tagKey, HolderSet<T> supportedItems, Consumer<HolderSet<T>> holderSetSetter) {
        ItemCompatHandler.setEnchantmentProperty(registryLookup, tagKey, supportedItems, holderSetSetter, (o1, o2) -> new CompositeHolderSet.Or(List.of(o1, o2)));
    }

    private static <T> void setEnchantmentProperty(HolderLookup.RegistryLookup<T> registryLookup, TagKey<T> tagKey, HolderSet<T> originalHolderSet, Consumer<HolderSet<T>> holderSetSetter, BinaryOperator<HolderSet<T>> holderSetCombiner) {
        Optional optional = registryLookup.get(tagKey);
        HolderSet newHolderSet = optional.map(holderSetX -> holderSetX).orElse(HolderSet.empty());
        holderSetSetter.accept((HolderSet)holderSetCombiner.apply(originalHolderSet, newHolderSet));
    }

    public static EventResult onShieldBlock(LivingEntity blockingEntity, DamageSource damageSource, float damageAmount) {
        Level level = blockingEntity.level();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (damageSource.isDirect() && (entity = damageSource.getEntity()) instanceof LivingEntity) {
                LivingEntity attackingEntity = (LivingEntity)entity;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)blockingEntity, (DamageSource)damageSource, (ItemStack)blockingEntity.getUseItem());
                float attackKnockback = (float)blockingEntity.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
                attackKnockback = EnchantmentHelper.modifyKnockback((ServerLevel)serverLevel, (ItemStack)blockingEntity.getUseItem(), (Entity)attackingEntity, (DamageSource)damageSource, (float)attackKnockback);
                attackingEntity.knockback(0.5 * (double)attackKnockback, blockingEntity.getX() - attackingEntity.getX(), blockingEntity.getZ() - attackingEntity.getZ());
            }
        }
        return EventResult.PASS;
    }

    public static EventResult onUseItemTick(LivingEntity entity, ItemStack useItem, MutableInt useItemRemaining) {
        Item item = useItem.getItem();
        int itemUseDuration = useItem.getUseDuration(entity) - useItemRemaining.getAsInt();
        if (item instanceof BowItem && itemUseDuration < 20 || item instanceof TridentItem && itemUseDuration < 10) {
            float chargingTime = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)useItem, (LivingEntity)entity, (float)1.25f);
            useItemRemaining.mapInt(duration -> duration - Mth.floor((float)((1.25f - chargingTime) / 0.25f)));
        }
        return EventResult.PASS;
    }

    public static void onComputeEnchantedLootBonus(LivingEntity entity, @Nullable DamageSource damageSource, Holder<Enchantment> enchantment, MutableInt enchantmentLevel) {
        Entity entity2;
        if (enchantment.is(Enchantments.LOOTING) && enchantmentLevel.getAsInt() == 0 && damageSource != null && (entity2 = damageSource.getDirectEntity()) instanceof AbstractArrow) {
            AbstractArrow abstractArrow = (AbstractArrow)entity2;
            enchantmentLevel.accept(EnchantmentHelper.getItemEnchantmentLevel(enchantment, (ItemStack)abstractArrow.getWeaponItem()));
        }
    }
}

