/*
 * Decompiled with CFR 0.152.
 */
package com.jackbusters.wardenhorn;

import com.google.common.base.Suppliers;
import com.jackbusters.wardenhorn.SonicConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class FgLootTableAdder
extends LootModifier {
    public static final Supplier<Codec<FgLootTableAdder>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> FgLootTableAdder.codecStart((RecordCodecBuilder.Instance)instance).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(g -> g.item)).apply((Applicative)instance, FgLootTableAdder::new)));
    public static final Supplier<MapCodec<FgLootTableAdder>> MAP_CODEC = Suppliers.memoize(() -> MapCodec.assumeMapUnsafe(CODEC.get()));
    private final Item item;
    public static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"wardenhorn");
    public static final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<? extends IGlobalLootModifier>> ADD_DROP = LOOT_MODIFIERS.register("add_drop", MAP_CODEC);

    protected FgLootTableAdder(LootItemCondition[] conditionsIn, Item item) {
        super(conditionsIn);
        this.item = item;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> objectArrayList, @NotNull LootContext arg) {
        int amount = (Integer)SonicConfig.dropAmount.get();
        for (int i = 0; i < amount; ++i) {
            objectArrayList.add((Object)new ItemStack((ItemLike)this.item));
        }
        return objectArrayList;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return MAP_CODEC.get();
    }
}

