/*
 * Decompiled with CFR 0.152.
 */
package com.jackbusters.wardenhorn;

import com.jackbusters.wardenhorn.DamageSources;
import com.jackbusters.wardenhorn.SonicConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SonicBoomAPI {
    public static void createBoom(ServerLevel level, Player shooter) {
        int rangeMax = (Integer)SonicConfig.range.get();
        float boomDamage = ((Double)SonicConfig.damage.get()).floatValue();
        double knockbackMultiplier = (Double)SonicConfig.knockback.get();
        boolean shouldBlocksStop = (Boolean)SonicConfig.stopAtBlocks.get();
        Vec3 shooterHeadPosition = shooter.getEyePosition();
        for (int i = 0; i < rangeMax; ++i) {
            Vec3 particleSpawnSpot = shooterHeadPosition.add(shooter.getForward().x * (double)i, shooter.getForward().y * (double)i, shooter.getForward().z * (double)i);
            BlockPos hitBlockPos = new BlockPos((int)particleSpawnSpot.x, (int)particleSpawnSpot.y, (int)particleSpawnSpot.z);
            BlockState hitBlockState = level.getBlockState(hitBlockPos);
            if (!shouldBlocksStop || hitBlockState.isAir() || !hitBlockState.canOcclude()) {
                level.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, particleSpawnSpot.x, particleSpawnSpot.y, particleSpawnSpot.z, 1, 0.0, 0.0, 0.0, 0.0);
                AABB aABB = new AABB(hitBlockPos).inflate(0.8, 0.8, 0.8);
                List livingEntityList = level.getEntitiesOfClass(LivingEntity.class, aABB);
                for (LivingEntity livingEntity : livingEntityList) {
                    if (livingEntity.is((Entity)shooter)) continue;
                    livingEntity.hurtServer(level, DamageSources.hornedShriek((LivingEntity)shooter, (Level)level), boomDamage);
                    double verticalResistance = 0.5 * (1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                    double horizontalResistance = 2.5 * (1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                    livingEntity.push(shooter.getForward().x * knockbackMultiplier * horizontalResistance, shooter.getForward().y * knockbackMultiplier * verticalResistance, shooter.getForward().z * knockbackMultiplier * horizontalResistance);
                }
                continue;
            }
            i = rangeMax + 1;
        }
        shooter.playSound(SoundEvents.WARDEN_SONIC_BOOM, 3.0f, 1.0f);
    }
}

