/*
 * Decompiled with CFR 0.152.
 */
package com.jackbusters.wardenhorn;

import com.jackbusters.wardenhorn.SonicBoomAPI;
import com.jackbusters.wardenhorn.SonicConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WardenHornItem
extends InstrumentItem {
    public WardenHornItem(Item.Properties properties, TagKey<Instrument> tagKey) {
        super(tagKey, properties);
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Optional optional = this.getInstrument(itemstack, (HolderLookup.Provider)player.registryAccess());
        if (optional.isPresent()) {
            Instrument instrument = (Instrument)level.registryAccess().lookupOrThrow(Registries.INSTRUMENT).getOrThrow(WardenHornItem.getProperInstrumentKey("shrieker_horn")).value();
            player.startUsingItem(hand);
            WardenHornItem.play((Level)level, (Player)player, (Instrument)instrument);
            player.getCooldowns().addCooldown(new ItemStack((ItemLike)this), (Integer)SonicConfig.rechargeTime.get() * 20);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SonicBoomAPI.createBoom(serverLevel, player);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private static ResourceKey<Instrument> getProperInstrumentKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.INSTRUMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardenhorn", (String)id));
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext tooltipContext, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"wardenhorn.text.whatitdo").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"wardenhorn.text.range", (Object[])new Object[]{SonicConfig.range.get()}).withStyle(ChatFormatting.DARK_GREEN));
        if ((Double)SonicConfig.damage.get() != Math.floor((Double)SonicConfig.damage.get())) {
            tooltip.add((Component)Component.translatable((String)"wardenhorn.text.damage", (Object[])new Object[]{SonicConfig.damage.get()}).withStyle(ChatFormatting.DARK_GREEN));
        } else {
            tooltip.add((Component)Component.translatable((String)"wardenhorn.text.damage", (Object[])new Object[]{((Double)SonicConfig.damage.get()).intValue()}).withStyle(ChatFormatting.DARK_GREEN));
        }
        if ((Double)SonicConfig.knockback.get() != Math.floor((Double)SonicConfig.knockback.get())) {
            tooltip.add((Component)Component.translatable((String)"wardenhorn.text.knockback", (Object[])new Object[]{SonicConfig.knockback.get()}).withStyle(ChatFormatting.DARK_GREEN));
        } else {
            tooltip.add((Component)Component.translatable((String)"wardenhorn.text.knockback", (Object[])new Object[]{((Double)SonicConfig.knockback.get()).intValue()}).withStyle(ChatFormatting.DARK_GREEN));
        }
        tooltip.add((Component)Component.translatable((String)"wardenhorn.text.recharge_time", (Object[])new Object[]{SonicConfig.rechargeTime.get()}).withStyle(ChatFormatting.DARK_GREEN));
    }
}

