/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix4f;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.graphics.shader.MapShaders;

public class MapRenderHelper {
    public static void renderBranchUpdate(float x, float y, float width, float height, int textureX, int textureY, float textureW, float textureH, float fullTextureWidth, float fullTextureHeight, boolean first) {
        RenderSystem.setShader((ShaderProgram)MapShaders.WORLD_MAP_BRANCH);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float normalizedTextureX = (float)textureX / fullTextureWidth;
        float normalizedTextureY = (float)textureY / fullTextureHeight;
        float normalizedTextureX2 = ((float)textureX + textureW) / fullTextureWidth;
        float normalizedTextureY2 = ((float)textureY + textureH) / fullTextureHeight;
        vertexBuffer.addVertex(x + 0.0f, y + height, 0.0f).setUv(normalizedTextureX, normalizedTextureY2);
        vertexBuffer.addVertex(x + width, y + height, 0.0f).setUv(normalizedTextureX2, normalizedTextureY2);
        vertexBuffer.addVertex(x + width, y + 0.0f, 0.0f).setUv(normalizedTextureX2, normalizedTextureY);
        vertexBuffer.addVertex(x + 0.0f, y + 0.0f, 0.0f).setUv(normalizedTextureX, normalizedTextureY);
        MeshData buffer = vertexBuffer.build();
        if (first) {
            BufferUploader.drawWithShader((MeshData)buffer);
            CompiledShaderProgram compiledShaderProgram = Minecraft.getInstance().getShaderManager().getProgram(MapShaders.WORLD_MAP_BRANCH);
            GlStateManager._glUseProgram((int)compiledShaderProgram.getProgramId());
        } else {
            BufferUploader.draw((MeshData)buffer);
        }
    }

    public static void fillIntoExistingBuffer(Matrix4f matrix, VertexConsumer bufferBuilder, int x1, int y1, int x2, int y2, float r, float g, float b, float a) {
        bufferBuilder.addVertex(matrix, (float)x1, (float)y2, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(matrix, (float)x2, (float)y2, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(matrix, (float)x2, (float)y1, 0.0f).setColor(r, g, b, a);
        bufferBuilder.addVertex(matrix, (float)x1, (float)y1, 0.0f).setColor(r, g, b, a);
    }

    public static void blitIntoExistingBuffer(Matrix4f matrix, VertexConsumer bufferBuilder, float x, float y, int u, int v, int width, int height, int tW, int tH, float r, float g, float b, float a, int textureWidth, int textureHeight) {
        float factorX = 1.0f / (float)textureWidth;
        float factorY = 1.0f / (float)textureHeight;
        float textureX1 = (float)u * factorX;
        float textureX2 = (float)(u + tW) * factorX;
        float textureY1 = (float)v * factorY;
        float textureY2 = (float)(v + tH) * factorY;
        bufferBuilder.addVertex(matrix, x, y + (float)height, 0.0f).setColor(r, g, b, a).setUv(textureX1, textureY2);
        bufferBuilder.addVertex(matrix, x + (float)width, y + (float)height, 0.0f).setColor(r, g, b, a).setUv(textureX2, textureY2);
        bufferBuilder.addVertex(matrix, x + (float)width, y, 0.0f).setColor(r, g, b, a).setUv(textureX2, textureY1);
        bufferBuilder.addVertex(matrix, x, y, 0.0f).setColor(r, g, b, a).setUv(textureX1, textureY1);
    }

    public static void blitIntoExistingBuffer(Matrix4f matrix, VertexConsumer bufferBuilder, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a) {
        MapRenderHelper.blitIntoExistingBuffer(matrix, bufferBuilder, x, y, u, v, width, height, width, height, r, g, b, a, 256, 256);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, float x, float y, int u, int v, int width, int height, int tW, int tH, float r, float g, float b, float a, int textureWidth, int textureHeight, int texture) {
        BufferBuilder bufferBuilder = renderer.begin(texture);
        MapRenderHelper.blitIntoExistingBuffer(matrix, (VertexConsumer)bufferBuilder, x, y, u, v, width, height, tW, tH, r, g, b, a, textureWidth, textureHeight);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, float x, float y, int u, int v, int width, int height, float r, float g, float b, float a, int textureWidth, int textureHeight, int texture) {
        MapRenderHelper.blitIntoMultiTextureRenderer(matrix, renderer, x, y, u, v, width, height, width, height, r, g, b, a, textureWidth, textureHeight, texture);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, float x, float y, int u, int v, int width, int height, float r, float g, float b, float a, int texture) {
        MapRenderHelper.blitIntoMultiTextureRenderer(matrix, renderer, x, y, u, v, width, height, r, g, b, a, 256, 256, texture);
    }

    public static void renderDynamicHighlight(PoseStack matrixStack, VertexConsumer overlayBuffer, int flooredCameraX, int flooredCameraZ, int leftX, int rightX, int topZ, int bottomZ, float sideR, float sideG, float sideB, float sideA, float centerR, float centerG, float centerB, float centerA) {
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), overlayBuffer, leftX - 1 - flooredCameraX, topZ - 1 - flooredCameraZ, leftX - flooredCameraX, bottomZ + 1 - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), overlayBuffer, leftX - flooredCameraX, topZ - 1 - flooredCameraZ, rightX - flooredCameraX, topZ - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), overlayBuffer, rightX - flooredCameraX, topZ - 1 - flooredCameraZ, rightX + 1 - flooredCameraX, bottomZ + 1 - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), overlayBuffer, leftX - flooredCameraX, bottomZ - flooredCameraZ, rightX - flooredCameraX, bottomZ + 1 - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), overlayBuffer, leftX - flooredCameraX, topZ - flooredCameraZ, rightX - flooredCameraX, bottomZ - flooredCameraZ, centerR, centerG, centerB, centerA);
    }

    public static void drawCenteredStringWithBackground(GuiGraphics guiGraphics, Font font, String string, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, VertexConsumer backgroundVertexBuffer) {
        int stringWidth = font.width(string);
        MapRenderHelper.drawStringWithBackground(guiGraphics, font, string, x - stringWidth / 2, y, color, bgRed, bgGreen, bgBlue, bgAlpha, backgroundVertexBuffer);
    }

    public static void drawStringWithBackground(GuiGraphics guiGraphics, Font font, String string, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, VertexConsumer backgroundVertexBuffer) {
        PoseStack matrixStack = guiGraphics.pose();
        int stringWidth = font.width(string);
        matrixStack.translate(0.0f, 0.0f, -1.0f);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), backgroundVertexBuffer, x - 1, y - 1, x + stringWidth + 1, y + 9, bgRed, bgGreen, bgBlue, bgAlpha);
        matrixStack.translate(0.0f, 0.0f, 1.0f);
        guiGraphics.drawString(font, string, x, y, color);
    }

    public static void drawCenteredStringWithBackground(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, VertexConsumer backgroundVertexBuffer) {
        int stringWidth = font.width((FormattedText)text);
        MapRenderHelper.drawStringWithBackground(guiGraphics, font, text, x - stringWidth / 2, y, color, bgRed, bgGreen, bgBlue, bgAlpha, backgroundVertexBuffer);
    }

    public static void drawStringWithBackground(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, VertexConsumer backgroundVertexBuffer) {
        PoseStack matrixStack = guiGraphics.pose();
        int stringWidth = font.width((FormattedText)text);
        matrixStack.translate(0.0f, 0.0f, -1.0f);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), backgroundVertexBuffer, x - 1, y - 1, x + stringWidth + 1, y + 9, bgRed, bgGreen, bgBlue, bgAlpha);
        matrixStack.translate(0.0f, 0.0f, 1.0f);
        guiGraphics.drawString(font, text, x, y, color);
    }

    public static void blitIntoExistingBuffer(Matrix4f matrix, VertexConsumer bufferBuilder, float x, float y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        float factorX = 1.0f / (float)textureWidth;
        float factorY = 1.0f / (float)textureHeight;
        float textureX1 = (float)u * factorX;
        float textureX2 = (float)(u + width) * factorX;
        float textureY1 = (float)v * factorY;
        float textureY2 = (float)(v + height) * factorY;
        bufferBuilder.addVertex(matrix, x, y + (float)height, 0.0f).setUv(textureX1, textureY2);
        bufferBuilder.addVertex(matrix, x + (float)width, y + (float)height, 0.0f).setUv(textureX2, textureY2);
        bufferBuilder.addVertex(matrix, x + (float)width, y, 0.0f).setUv(textureX2, textureY1);
        bufferBuilder.addVertex(matrix, x, y, 0.0f).setUv(textureX1, textureY1);
    }

    public static void blitIntoExistingBuffer(Matrix4f matrix, VertexConsumer bufferBuilder, int x, int y, int u, int v, int width, int height) {
        MapRenderHelper.blitIntoExistingBuffer(matrix, bufferBuilder, x, y, u, v, width, height, 256, 256);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int texture) {
        BufferBuilder bufferBuilder = renderer.begin(texture);
        MapRenderHelper.blitIntoExistingBuffer(matrix, (VertexConsumer)bufferBuilder, x, y, u, v, width, height, textureWidth, textureHeight);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, int texture) {
        MapRenderHelper.blitIntoMultiTextureRenderer(matrix, renderer, x, y, u, v, width, height, 256, 256, texture);
    }

    public static void restoreDefaultShaderBlendState() {
        RenderSystem.defaultBlendFunc();
    }
}

