/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.icon.XaeroIconAtlasManager;
import xaero.map.misc.Misc;

public class WaypointSymbolCreator {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    private static final int ICON_WIDTH = 64;
    public static final ResourceLocation minimapTextures = ResourceLocation.fromNamespaceAndPath((String)"xaerobetterpvp", (String)"gui/guis.png");
    public static final int white = -1;
    private Minecraft mc = Minecraft.getInstance();
    private XaeroIcon deathSymbolTexture;
    private final Map<String, XaeroIcon> charSymbols = new HashMap<String, XaeroIcon>();
    private XaeroIconAtlasManager iconManager;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private XaeroIconAtlas lastAtlas;

    public XaeroIcon getDeathSymbolTexture(GuiGraphics guiGraphics) {
        if (this.deathSymbolTexture == null) {
            this.createDeathSymbolTexture(guiGraphics);
        }
        return this.deathSymbolTexture;
    }

    private void createDeathSymbolTexture(GuiGraphics guiGraphics) {
        this.deathSymbolTexture = this.createCharSymbol(guiGraphics, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XaeroIcon getSymbolTexture(GuiGraphics guiGraphics, String c) {
        XaeroIcon icon;
        Map<String, XaeroIcon> map = this.charSymbols;
        synchronized (map) {
            icon = this.charSymbols.get(c);
        }
        if (icon == null) {
            icon = this.createCharSymbol(guiGraphics, false, c);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XaeroIcon createCharSymbol(GuiGraphics guiGraphics, boolean death, String c) {
        if (this.iconManager == null) {
            OpenGLException.checkGLError();
            int maxTextureSize = GlStateManager._getInteger((int)3379);
            OpenGLException.checkGLError();
            int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
            this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, false);
            OpenGLException.checkGLError();
            GlStateManager._deleteTexture((int)this.atlasRenderFramebuffer.getFramebufferTexture());
            OpenGLException.checkGLError();
            this.atlasRenderFramebuffer.setFramebufferTexture(0);
            this.iconManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        }
        XaeroIconAtlas atlas = this.iconManager.getCurrentAtlas();
        XaeroIcon icon = atlas.createIcon();
        guiGraphics.flush();
        this.atlasRenderFramebuffer.bindAsMainTarget(false);
        GlStateManager._viewport((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
        this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
        this.atlasRenderFramebuffer.checkStatus();
        if (this.lastAtlas != atlas) {
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.clear((int)16384);
            this.lastAtlas = atlas;
        }
        Matrix4f ortho = new Matrix4f().setOrtho(0.0f, 64.0f, 64.0f, 0.0f, -1.0f, 1000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)ortho, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        Matrix4fStack shaderMatrixStack = RenderSystem.getModelViewStack();
        shaderMatrixStack.pushMatrix();
        shaderMatrixStack.identity();
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        matrixStack.setIdentity();
        matrixStack.translate(2.0f, 2.0f, 0.0f);
        if (!death) {
            matrixStack.scale(3.0f, 3.0f, 1.0f);
            guiGraphics.drawString(this.mc.font, c, 0, 0, -1);
        } else {
            matrixStack.scale(3.0f, 3.0f, 1.0f);
            guiGraphics.blit(RenderType::guiTextured, minimapTextures, 1, 1, 0.0f, 0.0f, 78, 9, 9, 256, 256, -16119286);
            guiGraphics.blit(RenderType::guiTextured, minimapTextures, 0, 0, 0.0f, 0.0f, 78, 9, 9, 256, 256, -197380);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrixStack.popPose();
        guiGraphics.flush();
        Misc.minecraftOrtho(this.mc, false);
        shaderMatrixStack.popMatrix();
        this.atlasRenderFramebuffer.unbindWrite();
        this.atlasRenderFramebuffer.bindDefaultFramebuffer(this.mc);
        GlStateManager._viewport((int)0, (int)0, (int)this.mc.getWindow().getWidth(), (int)this.mc.getWindow().getHeight());
        if (death) {
            this.deathSymbolTexture = icon;
        } else {
            Map<String, XaeroIcon> map = this.charSymbols;
            synchronized (map) {
                this.charSymbols.put(c, icon);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChars() {
        Map<String, XaeroIcon> map = this.charSymbols;
        synchronized (map) {
            this.charSymbols.clear();
        }
        this.lastAtlas = null;
        this.deathSymbolTexture = null;
        if (this.iconManager != null) {
            this.iconManager.clearAtlases();
            this.atlasRenderFramebuffer.setFramebufferTexture(0);
        }
    }
}

