/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.category.setting.ObjectCategoryDefaultSettingsSetter;
import xaero.common.category.ui.GuiCategorySettings;
import xaero.common.category.ui.GuiCategoryUIEditorDataConverter;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.EntityRadarCategoryManager;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.minimap.radar.category.ui.GuiEntityRadarCategoryUIEditorData;
import xaero.common.minimap.radar.category.ui.GuiEntityRadarCategoryUIEditorDataConverter;
import xaero.common.minimap.radar.category.ui.data.GuiEntityRadarCategoryUIEditorSettingsData;
import xaero.hud.minimap.radar.RadarSession;

public class GuiEntityRadarCategorySettings
extends GuiCategorySettings<EntityRadarCategory, GuiEntityRadarCategoryUIEditorData, EntityRadarCategory.Builder, GuiEntityRadarCategoryUIEditorSettingsData<?>, GuiEntityRadarCategoryUIEditorSettingsData.Builder, GuiEntityRadarCategoryUIEditorData.Builder> {
    private final EntityRadarCategoryManager entityRadarCategoryManager;

    protected GuiEntityRadarCategorySettings(IXaeroMinimap modMain, Screen parent, Screen escape) {
        super(modMain, parent, escape, (Component)Component.translatable((String)"gui.xaero_entity_radar_categories"), GuiEntityRadarCategoryUIEditorDataConverter.Builder.getDefault().build());
        this.entityRadarCategoryManager = modMain.getEntityRadarCategoryManager();
    }

    @Override
    protected GuiEntityRadarCategoryUIEditorData constructEditorData(GuiCategoryUIEditorDataConverter<EntityRadarCategory, GuiEntityRadarCategoryUIEditorData, EntityRadarCategory.Builder, GuiEntityRadarCategoryUIEditorSettingsData<?>, GuiEntityRadarCategoryUIEditorSettingsData.Builder, GuiEntityRadarCategoryUIEditorData.Builder> dataConverter) {
        EntityRadarCategory rootCategory = this.modMain.getEntityRadarCategoryManager().getRootCategory();
        return dataConverter.convert(rootCategory, true);
    }

    @Override
    protected GuiEntityRadarCategoryUIEditorData constructDefaultData(GuiCategoryUIEditorDataConverter<EntityRadarCategory, GuiEntityRadarCategoryUIEditorData, EntityRadarCategory.Builder, GuiEntityRadarCategoryUIEditorSettingsData<?>, GuiEntityRadarCategoryUIEditorSettingsData.Builder, GuiEntityRadarCategoryUIEditorData.Builder> dataConverter) {
        EntityRadarCategory rootCategory;
        this.modMain.getSettings().resetEntityRadarBackwardsCompatibilityConfig();
        EntityRadarCategoryManager manager = this.modMain.getEntityRadarCategoryManager();
        if (Files.exists(manager.getSecondaryFilePath(), new LinkOption[0])) {
            try {
                rootCategory = manager.getSecondaryFileIO().loadRootCategory();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            rootCategory = manager.getDefaultCategoryConfigurator().setupDefault(this.modMain.getSettings());
        }
        ObjectCategoryDefaultSettingsSetter defaultSettings = ObjectCategoryDefaultSettingsSetter.Builder.getDefault().setSettings(EntityRadarCategorySettings.SETTINGS).build();
        defaultSettings.setDefaultsFor(rootCategory, true);
        return dataConverter.convert(rootCategory, true);
    }

    @Override
    protected void onConfigConfirmed(EntityRadarCategory confirmedRootCategory) {
        this.entityRadarCategoryManager.setRootCategory(confirmedRootCategory);
        this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().resetEntityIcons();
        this.entityRadarCategoryManager.save();
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            MinimapProcessor minimapProcessor = minimapSession.getMinimapProcessor();
            RadarSession radar = minimapProcessor.getRadarSession();
            radar.update(Minecraft.getInstance().level, Minecraft.getInstance().getCameraEntity(), (Player)Minecraft.getInstance().player);
        }
    }
}

