/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries.forge;

import com.google.common.base.Objects;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.impl.RegistrySupplierImpl;
import dev.architectury.platform.hooks.EventBusesHooks;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarBuilder;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.registry.registries.options.DefaultIdRegistrarOption;
import dev.architectury.registry.registries.options.RegistrarOption;
import dev.architectury.registry.registries.options.StandardRegistrarOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RegistrarManagerImpl {
    private static final Logger LOGGER = LogManager.getLogger(RegistrarManagerImpl.class);
    private static final Multimap<RegistryEntryId<?>, Consumer<?>> LISTENERS = HashMultimap.create();

    private static void listen(ResourceKey<?> resourceKey, ResourceLocation id, Consumer<?> listener) {
        LISTENERS.put(new RegistryEntryId(resourceKey, id), listener);
    }

    public static RegistrarManager.RegistryProvider _get(String modId) {
        return new RegistryProviderImpl(modId);
    }

    public record RegistryEntryId<T>(ResourceKey<T> registryKey, ResourceLocation id) {
        @Override
        public String toString() {
            return "Registry Entry [%s / %s]".formatted(this.registryKey.location(), this.id);
        }
    }

    public static class RegistryProviderImpl
    implements RegistrarManager.RegistryProvider {
        private static final Map<ResourceKey<Registry<?>>, Registrar<?>> CUSTOM_REGS = new HashMap();
        private final String modId;
        private final Map<ResourceKey<? extends Registry<?>>, Data<?>> registry = new HashMap();
        private final Multimap<ResourceKey<Registry<?>>, Consumer<Registrar<?>>> listeners = HashMultimap.create();
        @Nullable
        private List<Registry<?>> newRegistries = new ArrayList();

        public RegistryProviderImpl(String modId) {
            this.modId = modId;
            EventBusesHooks.getModEventBus(modId).get().register((Object)new EventListener());
        }

        @Override
        public <T> Registrar<T> get(ResourceKey<Registry<T>> registryKey) {
            Registry registry = (Registry)BuiltInRegistries.REGISTRY.getValue(registryKey.location());
            if (registry != null) {
                return this.get(registry);
            }
            Registrar<?> customReg = CUSTOM_REGS.get(registryKey);
            if (customReg != null) {
                return customReg;
            }
            throw new IllegalArgumentException("Registry " + String.valueOf(registryKey) + " does not exist!");
        }

        @Override
        public <T> Registrar<T> get(Registry<T> registry) {
            return new RegistrarImpl<T>(this.modId, this.registry, registry);
        }

        @Override
        public <T> void forRegistry(ResourceKey<Registry<T>> key, Consumer<Registrar<T>> consumer) {
            this.listeners.put(key, consumer);
        }

        @Override
        public <T> RegistrarBuilder<T> builder(Class<T> type, ResourceLocation registryId) {
            return new RegistryBuilderWrapper(this, new RegistryBuilder(ResourceKey.createRegistryKey((ResourceLocation)registryId)));
        }

        public class EventListener {
            @SubscribeEvent
            public void handleEvent(RegisterEvent event) {
                for (Map.Entry<ResourceKey<Registry<?>>, Data<?>> typeDataEntry : RegistryProviderImpl.this.registry.entrySet()) {
                    if (!typeDataEntry.getKey().equals((Object)event.getRegistryKey())) continue;
                    this.registerFor(event, typeDataEntry.getKey(), typeDataEntry.getValue());
                }
            }

            public <T> void registerFor(RegisterEvent event, ResourceKey<? extends Registry<T>> resourceKey, Data<T> data) {
                event.register(resourceKey, registry -> {
                    data.registered = true;
                    for (Map.Entry entry : data.objects.entrySet()) {
                        ResourceLocation location = entry.getKey();
                        Object value = entry.getValue().get();
                        registry.register(location, value);
                        RegistryEntryId registryEntryId = new RegistryEntryId(resourceKey, location);
                        for (Consumer consumer : LISTENERS.get(registryEntryId)) {
                            consumer.accept(value);
                        }
                        LISTENERS.removeAll(registryEntryId);
                    }
                    data.objects.clear();
                    Registrar archRegistry = RegistryProviderImpl.this.get(event.getRegistry());
                    for (Map.Entry entry : RegistryProviderImpl.this.listeners.entries()) {
                        if (!((ResourceKey)entry.getKey()).location().equals((Object)resourceKey.location())) continue;
                        ((Consumer)entry.getValue()).accept(archRegistry);
                    }
                });
            }

            @SubscribeEvent(priority=EventPriority.LOWEST)
            public void handleEventPost(RegisterEvent event) {
                Registrar archRegistry = RegistryProviderImpl.this.get(event.getRegistry());
                ArrayList<RegistryEntryId> toRemove = new ArrayList<RegistryEntryId>();
                for (Map.Entry entry : LISTENERS.asMap().entrySet()) {
                    if (!((RegistryEntryId)entry.getKey()).registryKey.equals(event.getRegistryKey())) continue;
                    if (archRegistry.contains(((RegistryEntryId)entry.getKey()).id)) {
                        Object value = archRegistry.get(((RegistryEntryId)entry.getKey()).id);
                        for (Consumer consumer : (Collection)entry.getValue()) {
                            consumer.accept(value);
                        }
                        toRemove.add((RegistryEntryId)entry.getKey());
                        continue;
                    }
                    LOGGER.warn("Registry entry listened {} was not realized!", entry.getKey());
                }
                for (RegistryEntryId id : toRemove) {
                    LISTENERS.removeAll((Object)id);
                }
            }

            @SubscribeEvent
            public void handleEvent(NewRegistryEvent event) {
                if (RegistryProviderImpl.this.newRegistries != null) {
                    for (Registry<?> registry : RegistryProviderImpl.this.newRegistries) {
                        event.register(registry);
                    }
                    RegistryProviderImpl.this.newRegistries = null;
                }
            }
        }
    }

    public static class RegistrarImpl<T>
    implements Registrar<T> {
        private final String modId;
        private final Registry<T> delegate;
        private final Map<ResourceKey<? extends Registry<?>>, Data<?>> registry;

        public RegistrarImpl(String modId, Map<ResourceKey<? extends Registry<?>>, Data<?>> registry, Registry<T> delegate) {
            this.modId = modId;
            this.registry = registry;
            this.delegate = delegate;
        }

        @Override
        public RegistrySupplier<T> delegate(ResourceLocation id) {
            com.google.common.base.Supplier value = Suppliers.memoize(() -> this.get(id));
            return this.asSupplier(id, this, () -> this.contains(id), (Supplier<T>)value);
        }

        @Override
        public <E extends T> RegistrySupplier<E> register(ResourceLocation id, Supplier<E> supplier) {
            Data data = this.registry.computeIfAbsent(this.key(), type -> new Data());
            MutableObject object = new MutableObject();
            data.register(this.delegate, id, object, supplier);
            return this.asSupplier(id, this, () -> RegistrarImpl.lambda$register$3((Mutable)object), () -> ((Mutable)object).getValue());
        }

        private <E extends T> RegistrySupplier<E> asSupplier(final ResourceLocation id, final Registrar<E> registrar, final BooleanSupplier isPresent, final Supplier<T> object) {
            return new RegistrySupplierImpl<E>(){
                @Nullable
                Holder<E> holder = null;

                @Override
                @Nullable
                public Holder<E> getHolder() {
                    if (this.holder != null) {
                        return this.holder;
                    }
                    this.holder = registrar.getHolder(this.getId());
                    return this.holder;
                }

                @Override
                public ResourceKey<E> getKey() {
                    return RegistrySupplierImpl.super.getKey();
                }

                @Override
                public RegistrarManager getRegistrarManager() {
                    return RegistrarManager.get(modId);
                }

                @Override
                public Registrar<E> getRegistrar() {
                    return registrar;
                }

                @Override
                public ResourceLocation getRegistryId() {
                    return delegate.key().location();
                }

                @Override
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return isPresent.getAsBoolean();
                }

                @Override
                public E get() {
                    Object value = object.get();
                    if (value == null) {
                        throw new NullPointerException("Value missing: " + String.valueOf(this.getId()) + "@" + String.valueOf(this.getRegistryId()));
                    }
                    return value;
                }

                public int hashCode() {
                    return Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return String.valueOf(this.getRegistryId()) + "@" + id.toString();
                }
            };
        }

        @Override
        @Nullable
        public ResourceLocation getId(T obj) {
            return this.delegate.getKey(obj);
        }

        @Override
        public int getRawId(T obj) {
            return this.delegate.getId(obj);
        }

        @Override
        public Optional<ResourceKey<T>> getKey(T t) {
            return this.delegate.getResourceKey(t);
        }

        @Override
        @Nullable
        public T get(ResourceLocation id) {
            return (T)this.delegate.getValue(id);
        }

        @Override
        public T byRawId(int rawId) {
            return (T)this.delegate.byId(rawId);
        }

        @Override
        public boolean contains(ResourceLocation resourceLocation) {
            return this.delegate.keySet().contains(resourceLocation);
        }

        @Override
        public boolean containsValue(T t) {
            return this.delegate.getResourceKey(t).isPresent();
        }

        @Override
        public Set<ResourceLocation> getIds() {
            return this.delegate.keySet();
        }

        @Override
        public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
            return this.delegate.entrySet();
        }

        @Override
        public ResourceKey<? extends Registry<T>> key() {
            return this.delegate.key();
        }

        @Override
        @Nullable
        public Holder<T> getHolder(ResourceKey<T> key) {
            return this.delegate.get(key).orElse(null);
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public void listen(ResourceLocation id, Consumer<T> callback) {
            if (this.contains(id)) {
                callback.accept(this.get(id));
            } else {
                RegistrarManagerImpl.listen(this.key(), id, callback);
            }
        }

        private static /* synthetic */ boolean lambda$register$3(Mutable object) {
            return object.getValue() != null;
        }
    }

    public static class RegistryBuilderWrapper<T>
    implements RegistrarBuilder<T> {
        private final RegistryProviderImpl provider;
        private final RegistryBuilder<T> builder;
        private boolean syncToClients = false;

        public RegistryBuilderWrapper(RegistryProviderImpl provider, RegistryBuilder<T> builder) {
            this.provider = provider;
            this.builder = builder;
        }

        @Override
        public Registrar<T> build() {
            this.builder.sync(this.syncToClients);
            if (this.provider.newRegistries == null) {
                throw new IllegalStateException("Cannot create registries when registries are already aggregated!");
            }
            Registry registry = this.builder.create();
            Registrar registrar = this.provider.get(registry);
            this.provider.newRegistries.add(registry);
            RegistryProviderImpl.CUSTOM_REGS.put(registrar.key(), registrar);
            return registrar;
        }

        @Override
        public RegistrarBuilder<T> option(RegistrarOption option) {
            if (option == StandardRegistrarOption.SYNC_TO_CLIENTS) {
                this.syncToClients = true;
            } else if (option instanceof DefaultIdRegistrarOption) {
                DefaultIdRegistrarOption opt = (DefaultIdRegistrarOption)option;
                this.builder.defaultKey(opt.defaultId());
            }
            return this;
        }
    }

    public static class Data<T> {
        private boolean registered = false;
        private final Map<ResourceLocation, Supplier<? extends T>> objects = new LinkedHashMap<ResourceLocation, Supplier<? extends T>>();

        public void register(Registry<T> registry, ResourceLocation location, Mutable<T> object, Supplier<? extends T> reference) {
            if (!this.registered) {
                this.objects.put(location, () -> {
                    Object value = reference.get();
                    object.setValue(value);
                    return value;
                });
            } else {
                ResourceKey resourceKey = registry.key();
                T value = reference.get();
                Registry.register(registry, (ResourceLocation)location, value);
                object.setValue(value);
                RegistryEntryId registryEntryId = new RegistryEntryId(resourceKey, location);
                for (Consumer consumer : LISTENERS.get(registryEntryId)) {
                    consumer.accept(value);
                }
                LISTENERS.removeAll(registryEntryId);
            }
        }
    }
}

