/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.cyclopscore.blockentity.IBlockEntityDelayedTickable;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTProviderComponent;

public class CyclopsBlockEntity
extends BlockEntity
implements INBTProvider,
IDirtyMarkListener,
IBlockEntityDelayedTickable {
    private static final int UPDATE_BACKOFF_TICKS = 1;
    private INBTProvider nbtProviderComponent = new NBTProviderComponent(this);
    private boolean shouldSendUpdate = false;
    private int sendUpdateBackoff = (int)Math.round(Math.random() * (double)this.getUpdateBackoffTicks());

    public CyclopsBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    @Override
    public int getUpdateBackoffTicks() {
        return 1;
    }

    @Override
    public void sendUpdate() {
        this.shouldSendUpdate = true;
    }

    @Override
    public boolean shouldSendUpdate() {
        return this.shouldSendUpdate;
    }

    @Override
    public void unsetSendUpdate() {
        this.shouldSendUpdate = false;
    }

    @Override
    public void setUpdateBackoff(int updateBackoff) {
        this.sendUpdateBackoff = updateBackoff;
    }

    @Override
    public int getUpdateBackoff() {
        return this.sendUpdateBackoff;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean canInteractWith(Player entityPlayer) {
        return true;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        this.writeGeneratedFieldsToNBT(tag, lookupProvider);
    }

    public CompoundTag writeToItemStack(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.saveAdditional(tag, lookupProvider);
        return tag;
    }

    public final void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.read(tag, provider);
    }

    public void read(CompoundTag tag, HolderLookup.Provider provider) {
        this.readGeneratedFieldsFromNBT(tag, provider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    protected Direction transformFacingForRotation(Direction facing) {
        if (facing == null) {
            return null;
        }
        if (this.getRotation() == null) {
            return facing;
        }
        return DirectionHelpers.transformFacingForRotation(facing, this.getRotation());
    }

    public Direction getRotation() {
        return null;
    }

    @Override
    public void onDirty() {
        this.setChanged();
    }

    @Override
    public void writeGeneratedFieldsToNBT(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        this.nbtProviderComponent.writeGeneratedFieldsToNBT(tag, holderLookupProvider);
    }

    @Override
    public void readGeneratedFieldsFromNBT(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        this.nbtProviderComponent.readGeneratedFieldsFromNBT(tag, holderLookupProvider);
    }
}

