/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ItemDecoratorHandler;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class GuiGraphicsExtended {
    private final GuiGraphics guiGraphics;

    public GuiGraphicsExtended(GuiGraphics guiGraphics) {
        this.guiGraphics = guiGraphics;
    }

    public void drawSlotText(Font font, @javax.annotation.Nullable String text, int x, int y) {
        this.guiGraphics.pose().pushPose();
        this.guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
        float scale = 0.5f;
        this.guiGraphics.pose().scale(scale, scale, 1.0f);
        this.guiGraphics.drawString(font, text, (float)(x + 19 - 2) / scale - (float)font.width(text), (float)(y + 6 + 6) / scale, 0xFFFFFF, true);
        this.guiGraphics.pose().popPose();
    }

    public void renderItemDecorations(Font font, ItemStack stack, int x, int y) {
        this.renderItemDecorations(font, stack, x, y, null);
    }

    public void renderItemDecorations(Font font, ItemStack stack, int x, int y, @Nullable String text) {
        if (!stack.isEmpty()) {
            float f;
            this.guiGraphics.pose().pushPose();
            if (stack.getCount() != 1 || text != null) {
                String s = text == null ? IModHelpers.get().getGuiHelpers().quantityToScaledString(stack.getCount()) : text;
                this.drawSlotText(font, s, x, y);
            }
            if (stack.isBarVisible()) {
                int l = stack.getBarWidth();
                int i = stack.getBarColor();
                int j = x + 2;
                int k = y + 13;
                this.guiGraphics.fill(RenderType.guiOverlay(), j, k, j + 13, k + 2, -16777216);
                this.guiGraphics.fill(RenderType.guiOverlay(), j, k, j + l, k + 1, i | 0xFF000000);
            }
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer localplayer = minecraft.player;
            float f2 = f = localplayer == null ? 0.0f : localplayer.getCooldowns().getCooldownPercent(stack, minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(true));
            if (f > 0.0f) {
                int i1 = y + Mth.floor((float)(16.0f * (1.0f - f)));
                int j1 = i1 + Mth.ceil((float)(16.0f * f));
                this.guiGraphics.fill(RenderType.guiOverlay(), x, i1, x + 16, j1, Integer.MAX_VALUE);
            }
            this.guiGraphics.pose().popPose();
            ItemDecoratorHandler.of((ItemStack)stack).render(this.guiGraphics, font, stack, x, y);
        }
    }
}

