/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.model;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.cyclops.cyclopscore.client.model.DynamicBaseModel;

public abstract class DynamicItemAndBlockModel
extends DynamicBaseModel {
    private final boolean factory;
    private final boolean item;
    private Direction renderingSide;

    public DynamicItemAndBlockModel(boolean factory, boolean item) {
        this.factory = factory;
        this.item = item;
    }

    protected boolean isItemStack() {
        return this.item;
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, RenderType.cutout());
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        BakedModel bakedModel;
        this.renderingSide = side;
        if (this.factory && (bakedModel = this.isItemStack() ? this.handleItemState(null, null, null) : this.handleBlockState(state, side, rand, extraData, renderType)) != null) {
            return bakedModel.getQuads(state, side, rand);
        }
        return this.getGeneralQuads();
    }

    public List<BakedQuad> getGeneralQuads() {
        return Collections.emptyList();
    }

    public abstract BakedModel handleBlockState(@Nullable BlockState var1, @Nullable Direction var2, @Nonnull RandomSource var3, @Nonnull ModelData var4, @Nullable RenderType var5);

    public abstract BakedModel handleItemState(@Nullable ItemStack var1, @Nullable Level var2, @Nullable LivingEntity var3);

    public Direction getRenderingSide() {
        return this.renderingSide;
    }
}

