/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;

public class ParticleBlur
extends TextureSheetParticle {
    public static final RenderType RENDER_TYPE = new RenderType("cyclopscore:blur", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, 1536, false, false, () -> {
        RenderType.translucentParticle((ResourceLocation)TextureAtlas.LOCATION_PARTICLES).setupRenderState();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_PARTICLES);
        texture.setFilter(true, false);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        RenderType.translucentParticle((ResourceLocation)TextureAtlas.LOCATION_PARTICLES).clearRenderState();
    }){};
    public static final ParticleRenderType PARTICLE_RENDER_TYPE = new ParticleRenderType("cyclopscore:blur", RENDER_TYPE);
    private static final int MAX_VIEW_DISTANCE = 30;
    protected float originalScale;
    protected float scaleLife;

    public ParticleBlur(ParticleBlurData data, ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.rCol = data.getRed();
        this.gCol = data.getGreen();
        this.bCol = data.getBlue();
        this.alpha = 0.9f;
        this.gravity = 0.0f;
        this.originalScale = (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f * data.getScale();
        this.lifetime = (int)((this.random.nextFloat() * 0.33f + 0.66f) * data.getAgeMultiplier());
        this.setSize(0.01f, 0.01f);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.scaleLife = (float)((double)this.lifetime / 2.5);
        this.validateDistance();
    }

    private void validateDistance() {
        LocalPlayer renderentity = Minecraft.getInstance().player;
        int visibleDistance = 30;
        if (((GraphicsStatus)Minecraft.getInstance().options.graphicsMode().get()).getId() == 0) {
            visibleDistance /= 2;
        }
        if (renderentity == null || renderentity.distanceToSqr(this.x, this.y, this.z) > (double)(visibleDistance * visibleDistance)) {
            this.lifetime = 0;
        }
    }

    public ParticleRenderType getRenderType() {
        return PARTICLE_RENDER_TYPE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.yd -= 0.04 * (double)this.gravity;
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
    }

    protected int getLightColor(float partialTicks) {
        return 0xF000F0;
    }

    public void setGravity(float particleGravity) {
        this.gravity = particleGravity;
    }

    public float getQuadSize(float p_217561_1_) {
        float agescale = (float)this.age / this.scaleLife;
        if (agescale > 1.0f) {
            agescale = 2.0f - agescale;
        }
        this.quadSize = this.originalScale * agescale * 0.5f;
        return this.quadSize;
    }
}

