/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;

public abstract class RenderBlockEntityModel<T extends CyclopsBlockEntity, M>
implements BlockEntityRenderer<T> {
    protected final M model;
    private final Material material;

    public RenderBlockEntityModel(M model, Material material) {
        this.model = model;
        this.material = material;
    }

    public M getModel() {
        return this.model;
    }

    public Material getMaterial() {
        return this.material;
    }

    public Function<ResourceLocation, RenderType> getRenderTypeGetter() {
        return RenderType::entityCutout;
    }

    protected void preRotate(T tile, PoseStack matrixStack) {
        matrixStack.translate(0.5f, 0.5f, 0.5f);
    }

    protected void postRotate(T tile, PoseStack matrixStack) {
        matrixStack.translate(-0.5f, -0.5f, -0.5f);
    }

    public void render(T tile, float partialTick, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction direction = ((CyclopsBlockEntity)tile).getRotation();
        VertexConsumer vertexBuilder = this.material.buffer(buffer, this.getRenderTypeGetter());
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 1.0f, 1.0f);
        matrixStack.scale(1.0f, -1.0f, -1.0f);
        this.preRotate(tile, matrixStack);
        int rotation = 0;
        if (direction == Direction.SOUTH) {
            rotation = 180;
        }
        if (direction == Direction.NORTH) {
            rotation = 0;
        }
        if (direction == Direction.EAST) {
            rotation = 90;
        }
        if (direction == Direction.WEST) {
            rotation = -90;
        }
        matrixStack.mulPose(Axis.YP.rotationDegrees((float)rotation));
        this.postRotate(tile, matrixStack);
        this.renderModel(tile, this.getModel(), partialTick, matrixStack, vertexBuilder, buffer, combinedLight, combinedOverlay);
        matrixStack.popPose();
    }

    protected abstract void renderModel(T var1, M var2, float var3, PoseStack var4, VertexConsumer var5, MultiBufferSource var6, int var7, int var8);
}

