/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.base.Function;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.cyclops.cyclopscore.helper.IRenderHelpers;
import org.joml.Matrix4f;

public class RenderHelpersCommon
implements IRenderHelpers {
    private static final Random rand = new Random();
    private static final Function<ResourceLocation, TextureAtlasSprite> TEXTURE_GETTER = location -> (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(location);

    @Override
    public void bindTexture(ResourceLocation texture) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    @Override
    public void emitParticle(Particle particle) {
        Minecraft.getInstance().particleEngine.add(particle);
    }

    @Override
    public void drawScaledString(GuiGraphics guiGraphics, Font fontRenderer, String string, int x, int y, float scale, int color, boolean shadow, Font.DisplayMode displayMode) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 0.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.drawString(fontRenderer, string, x, y, color, shadow);
        guiGraphics.pose().popPose();
    }

    @Override
    public void drawScaledCenteredString(GuiGraphics guiGraphics, Font fontRenderer, String string, int x, int y, int maxWidth, int color, boolean shadow, Font.DisplayMode displayMode) {
        this.drawScaledCenteredString(guiGraphics, fontRenderer, string, x, y, maxWidth, 1.0f, maxWidth, color, shadow, displayMode);
    }

    @Override
    public void drawScaledCenteredString(GuiGraphics guiGraphics, Font fontRenderer, String string, int x, int y, int width, float originalScale, int maxWidth, int color, boolean shadow, Font.DisplayMode displayMode) {
        float originalWidth = (float)fontRenderer.width(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        this.drawScaledCenteredString(guiGraphics, fontRenderer, string, x, y, width, scale, color, shadow, displayMode);
    }

    @Override
    public void drawScaledCenteredString(GuiGraphics guiGraphics, Font fontRenderer, String string, int x, int y, int width, float scale, int color, boolean shadow, Font.DisplayMode displayMode) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        int titleLength = fontRenderer.width(string);
        Objects.requireNonNull(fontRenderer);
        int titleHeight = 9;
        guiGraphics.drawString(fontRenderer, string, Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), Math.round((float)y / scale - (float)(titleHeight / 2)), color, false);
        guiGraphics.pose().popPose();
    }

    @Override
    public BakedModel getBakedModel(BlockState blockState) {
        Minecraft mc = Minecraft.getInstance();
        BlockRenderDispatcher blockRendererDispatcher = mc.getBlockRenderer();
        BlockModelShaper blockModelShapes = blockRendererDispatcher.getBlockModelShaper();
        return blockModelShapes.getBlockModel(blockState);
    }

    @Override
    public BakedModel getDynamicBakedModel(Level world, BlockPos pos) {
        return this.getBakedModel(world.getBlockState(pos));
    }

    @Override
    public void addBlockHitEffects(ParticleEngine particleManager, ClientLevel world, BlockState blockState, BlockPos pos, Direction side) {
        if (blockState.getRenderShape() != RenderShape.INVISIBLE) {
            int i = pos.getX();
            int j = pos.getY();
            int k = pos.getZ();
            float f = 0.1f;
            AABB bb = blockState.getShape((BlockGetter)world, pos).bounds();
            double d0 = (double)i + rand.nextDouble() * (bb.maxX - bb.minX - (double)(f * 2.0f)) + (double)f + bb.minX;
            double d1 = (double)j + rand.nextDouble() * (bb.maxY - bb.minY - (double)(f * 2.0f)) + (double)f + bb.minY;
            double d2 = (double)k + rand.nextDouble() * (bb.maxZ - bb.minZ - (double)(f * 2.0f)) + (double)f + bb.minZ;
            if (side == Direction.DOWN) {
                d1 = (double)j + bb.minY - (double)f;
            }
            if (side == Direction.UP) {
                d1 = (double)j + bb.maxY + (double)f;
            }
            if (side == Direction.NORTH) {
                d2 = (double)k + bb.minZ - (double)f;
            }
            if (side == Direction.SOUTH) {
                d2 = (double)k + bb.maxZ + (double)f;
            }
            if (side == Direction.WEST) {
                d0 = (double)i + bb.minX - (double)f;
            }
            if (side == Direction.EAST) {
                d0 = (double)i + bb.maxX + (double)f;
            }
            Particle fx = new TerrainParticle.Provider().createParticle(new BlockParticleOption(ParticleTypes.BLOCK, blockState), world, d0, d1, d2, 0.0, 0.0, 0.0);
            particleManager.add(fx);
        }
    }

    @Override
    public Function<ResourceLocation, TextureAtlasSprite> getBlockTextureGetter() {
        return TEXTURE_GETTER;
    }

    @Override
    public TextureAtlasSprite getBlockIcon(Block block) {
        return Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(block.defaultBlockState());
    }

    @Override
    public boolean isPointInRegion(int left, int top, int width, int height, double pointX, double pointY) {
        return pointX >= (double)left && pointX < (double)(left + width) && pointY >= (double)top && pointY < (double)(top + height);
    }

    @Override
    public boolean isPointInRegion(Rectangle region, Point point) {
        return this.isPointInRegion(region.x, region.y, region.width, region.height, point.x, point.y);
    }

    @Override
    public boolean isPointInButton(Button button, int pointX, int pointY) {
        return this.isPointInRegion(button.getX(), button.getY(), button.getWidth(), button.getHeight(), pointX, pointY);
    }

    @Override
    public void blitColored(GuiGraphics guiGraphics, int x, int y, int z, float u, float v, int width, int height, float r, float g, float b, float a) {
        this.blitColored(guiGraphics, x, y, z, width, height, u / 256.0f, (u + (float)width) / 256.0f, v / 256.0f, (v + (float)height) / 256.0f, r, g, b, a);
    }

    @Override
    public void blitColored(GuiGraphics guiGraphics, int x, int y, int z, int width, int height, float u0, float u1, float v0, float v1, float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, (float)x, (float)y + (float)height, (float)z).setUv(u0, v1);
        bufferbuilder.addVertex(matrix4f, (float)x + (float)width, (float)y + (float)height, (float)z).setUv(u1, v1);
        bufferbuilder.addVertex(matrix4f, (float)x + (float)width, (float)y, (float)z).setUv(u1, v0);
        bufferbuilder.addVertex(matrix4f, (float)x, (float)y, (float)z).setUv(u0, v0);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

