/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;

public class KeyBindingAppendix
extends SectionAppendix {
    public static final int WIDTH = 100;
    public static final int HEIGHT = 30;
    @OnlyIn(value=Dist.CLIENT)
    private KeyMapping keyBinding;

    public KeyBindingAppendix(IInfoBook infoBook, String keybindingName) throws InfoBookParser.InvalidAppendixException {
        super(infoBook);
        if (infoBook.getMod().getModHelpers().getMinecraftHelpers().isClientSide()) {
            this.keyBinding = (KeyMapping)KeyMapping.ALL.get(keybindingName);
            if (this.keyBinding == null) {
                throw new InfoBookParser.InvalidAppendixException("Could not find a keybinding by name " + keybindingName);
            }
        }
    }

    @Override
    protected int getOffsetY() {
        return 0;
    }

    @Override
    protected int getWidth() {
        return 100;
    }

    @Override
    protected int getHeight() {
        return 30;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        gui.drawOuterBorder(guiGraphics, x - 1, y - 1, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(guiGraphics, x + width / 2, y - 2);
        gui.drawScaledCenteredString(guiGraphics, IModHelpers.get().getL10NHelpers().localize("gui." + this.getInfoBook().getMod().getModId() + ".keybinding", new Object[0]), x, y - 2, width, 0.9f, gui.getBannerWidth() - 6, IModHelpers.get().getBaseHelpers().RGBToInt(30, 20, 120));
        gui.drawScaledCenteredString(guiGraphics, ChatFormatting.ITALIC.toString() + IModHelpers.get().getL10NHelpers().localize(this.keyBinding.getName(), new Object[0]), x, y - 2 + 12, width, 0.9f, gui.getBannerWidth() + 8, IModHelpers.get().getBaseHelpers().RGBToInt(30, 20, 120));
        String binding = IModHelpers.get().getL10NHelpers().localize(this.keyBinding.saveString(), new Object[0]);
        int bindingWidth = gui.getFont().width(binding) + 2;
        gui.drawOuterBorder(guiGraphics, x + width / 2 - bindingWidth / 2 - 1, y + 17, bindingWidth, 10, 1.0f, 1.0f, 1.0f, 0.2f);
        gui.drawScaledCenteredString(guiGraphics, binding, x, y + 22, width, 0.9f, gui.getBannerWidth() - 6, IModHelpers.get().getBaseHelpers().RGBToInt(30, 20, 120));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void postDrawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
    }

    @Override
    public void preBakeElement(InfoSection infoSection) {
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
    }
}

