/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.RegistryEntries;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class NBTSimpleInventoryItemStack
extends SimpleInventory {
    protected final ItemStack itemStack;
    protected final String tagName;

    public NBTSimpleInventoryItemStack(ItemStack itemStack, int size, int stackLimit, String tagName) {
        super(size, stackLimit);
        this.itemStack = itemStack;
        this.tagName = tagName;
        SimpleInventory contents = (SimpleInventory)itemStack.get(RegistryEntries.COMPONENT_INVENTORY);
        if (contents != null) {
            for (int i = 0; i < contents.getContainerSize(); ++i) {
                this.setItem(i, contents.getItem(i));
            }
        }
    }

    @Override
    public void setChanged() {
        this.itemStack.set(RegistryEntries.COMPONENT_INVENTORY, (Object)this);
    }

    @Override
    public void readFromNBT(HolderLookup.Provider provider, CompoundTag data, String tagName) {
        IModHelpers.get().getInventoryHelpers().readFromNBT(provider, this, data, tagName);
    }

    @Override
    public void writeToNBT(HolderLookup.Provider provider, CompoundTag data, String tagName) {
        IModHelpers.get().getInventoryHelpers().writeToNBT(provider, this, data, tagName);
    }
}

