/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.handler.codec.EncoderException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.SyncedGuiVariable;
import org.cyclops.cyclopscore.inventory.container.button.IContainerButtonAction;
import org.cyclops.cyclopscore.inventory.container.button.IContainerButtonClickAcceptorServer;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.packet.ValueNotifyPacket;

public abstract class ContainerExtended
extends AbstractContainerMenu
implements IContainerButtonClickAcceptorServer<ContainerExtended>,
IValueNotifier,
IValueNotifiable {
    private static final EquipmentSlot[] EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    protected static final int ITEMBOX = 18;
    private final Map<String, IContainerButtonAction<ContainerExtended>> buttonActions = Maps.newHashMap();
    private final Map<Integer, CompoundTag> values = Maps.newHashMap();
    private final List<SyncedGuiVariable<?>> syncedGuiVariables = Lists.newArrayList();
    private int nextValueId = 0;
    private IValueNotifiable guiValueListener = null;
    private Inventory playerIInventory;
    protected final Player player;
    protected int offsetX = 0;
    protected int offsetY = 0;
    private int quickcraftType = -1;
    private int quickcraftStatus;
    private final Set<Slot> quickcraftSlots = Sets.newHashSet();

    public ContainerExtended(@Nullable MenuType<?> type, int id, Inventory inventory) {
        super(type, id);
        this.playerIInventory = inventory;
        this.player = inventory.player;
    }

    @Override
    public HolderLookup.Provider getHolderLookupProvider() {
        return this.player.level().registryAccess();
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (!this.player.level().isClientSide()) {
            for (SyncedGuiVariable<?> syncedGuiVariable : this.syncedGuiVariables) {
                syncedGuiVariable.detectAndSendChanges();
            }
        }
    }

    public void setGuiValueListener(IValueNotifiable listener) {
        this.guiValueListener = listener;
    }

    public void addSlotListener(ContainerListener listener) {
        super.addSlotListener(listener);
        if (!this.player.getCommandSenderWorld().isClientSide()) {
            this.initializeValues();
        }
    }

    protected void initializeValues() {
    }

    protected Slot createNewSlot(Container inventory, int index, int x, int y) {
        return new Slot(inventory, index, x, y);
    }

    public static void setSlotPosX(Slot slot, int newValue) {
        slot.x = newValue;
    }

    public static void setSlotPosY(Slot slot, int newValue) {
        slot.y = newValue;
    }

    protected Slot addSlot(Slot slot) {
        ContainerExtended.setSlotPosX(slot, slot.x + this.offsetX);
        ContainerExtended.setSlotPosY(slot, slot.y + this.offsetY);
        return super.addSlot(slot);
    }

    protected void addInventory(Container inventory, int indexOffset, int offsetX, int offsetY, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                this.addSlot(this.createNewSlot(inventory, x + y * cols + indexOffset, offsetX + x * 18, offsetY + y * 18));
            }
        }
    }

    protected void addPlayerInventory(Inventory inventory, int offsetX, int offsetY) {
        int rows = 3;
        int cols = 9;
        this.addInventory((Container)inventory, 0, offsetX, offsetY + 58, 1, cols);
        this.addInventory((Container)inventory, cols, offsetX, offsetY, rows, cols);
    }

    protected abstract int getSizeInventory();

    protected int getSlotStart(int originSlot, int slotStart, boolean reverse) {
        return slotStart;
    }

    protected int getSlotRange(int originSlot, int slotRange, boolean reverse) {
        return slotRange;
    }

    public ItemStack quickMoveStack(Player player, int slotID) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotID);
        int slots = this.getSizeInventory();
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem().copy();
            stack = stackInSlot.copy();
            if (slotID < slots ? !this.moveItemStackTo(stackInSlot, this.getSlotStart(slotID, slots, true), this.getSlotRange(slotID, this.slots.size(), true), true) : !this.moveItemStackTo(stackInSlot, this.getSlotStart(slotID, 0, false), this.getSlotRange(slotID, slots, false), false)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.set(stackInSlot);
            }
            if (stackInSlot.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stackInSlot);
        }
        return stack;
    }

    protected boolean moveItemStackTo(ItemStack stack, int slotStart, int slotRange, boolean reverse) {
        ItemStack existingStack;
        Slot slot;
        boolean successful = false;
        int slotIndex = slotStart;
        int maxStack = stack.getMaxStackSize();
        if (reverse) {
            slotIndex = slotRange - 1;
        }
        if (stack.isStackable()) {
            while (stack.getCount() > 0 && (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart)) {
                slot = (Slot)this.slots.get(slotIndex);
                int maxSlotSize = Math.min(slot.getMaxStackSize(), maxStack);
                existingStack = slot.getItem().copy();
                if (slot.mayPlace(stack) && !existingStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existingStack)) {
                    int existingSize = existingStack.getCount() + stack.getCount();
                    if (existingSize <= maxSlotSize) {
                        stack.setCount(0);
                        existingStack.setCount(existingSize);
                        slot.set(existingStack);
                        successful = true;
                    } else if (existingStack.getCount() < maxSlotSize) {
                        stack.shrink(maxSlotSize - existingStack.getCount());
                        existingStack.setCount(maxSlotSize);
                        slot.set(existingStack);
                        successful = true;
                    }
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        if (stack.getCount() > 0) {
            slotIndex = reverse ? slotRange - 1 : slotStart;
            while (stack.getCount() > 0 && (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart)) {
                slot = (Slot)this.slots.get(slotIndex);
                existingStack = slot.getItem().copy();
                if (slot.mayPlace(stack) && existingStack.isEmpty()) {
                    int placedAmount = Math.min(stack.getCount(), slot.getMaxStackSize());
                    ItemStack toPut = stack.copy();
                    toPut.setCount(placedAmount);
                    slot.set(toPut);
                    stack.shrink(placedAmount);
                    successful = true;
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        return successful;
    }

    public Inventory getPlayerIInventory() {
        return this.playerIInventory;
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        Slot slot = slotId < 0 ? null : (Slot)this.slots.get(slotId);
        Inventory inventory = player.getInventory();
        if (clickType == ClickType.QUICK_CRAFT) {
            int i = this.quickcraftStatus;
            this.quickcraftStatus = ContainerExtended.getQuickcraftHeader((int)dragType);
            if ((i != 1 || this.quickcraftStatus != 2) && i != this.quickcraftStatus) {
                this.resetQuickCraft();
            } else if (this.getCarried().isEmpty()) {
                this.resetQuickCraft();
            } else if (this.quickcraftStatus == 0) {
                this.quickcraftType = ContainerExtended.getQuickcraftType((int)dragType);
                if (ContainerExtended.isValidQuickcraftType((int)this.quickcraftType, (Player)player)) {
                    this.quickcraftStatus = 1;
                    this.quickcraftSlots.clear();
                } else {
                    this.resetQuickCraft();
                }
            } else if (this.quickcraftStatus == 1) {
                ItemStack itemstack = this.getCarried();
                if (ContainerExtended.canItemQuickReplace((Slot)slot, (ItemStack)itemstack, (boolean)true) && slot.mayPlace(itemstack) && (this.quickcraftType == 2 || itemstack.getCount() > this.quickcraftSlots.size()) && this.canDragTo(slot)) {
                    this.quickcraftSlots.add(slot);
                }
            } else if (this.quickcraftStatus == 2) {
                if (!this.quickcraftSlots.isEmpty()) {
                    int phantomCount = 0;
                    if (this.quickcraftSlots.size() == 1) {
                        int l = this.quickcraftSlots.iterator().next().index;
                        this.resetQuickCraft();
                        this.clicked(l, this.quickcraftType, ClickType.PICKUP, player);
                        return;
                    }
                    ItemStack itemstack2 = this.getCarried().copy();
                    if (itemstack2.isEmpty()) {
                        this.resetQuickCraft();
                        return;
                    }
                    int k1 = this.getCarried().getCount();
                    for (Slot slot1 : this.quickcraftSlots) {
                        ItemStack itemstack1 = this.getCarried();
                        if (slot1 == null || !ContainerExtended.canItemQuickReplace((Slot)slot1, (ItemStack)itemstack1, (boolean)true) || !slot1.mayPlace(itemstack1) || this.quickcraftType != 2 && itemstack1.getCount() < this.quickcraftSlots.size() || !this.canDragTo(slot1)) continue;
                        int j = slot1.hasItem() ? slot1.getItem().getCount() : 0;
                        int k = Math.min(itemstack2.getMaxStackSize(), slot1.getMaxStackSize(itemstack2));
                        int l = Math.min(ContainerExtended.getQuickCraftPlaceCount(this.quickcraftSlots, (int)this.quickcraftType, (ItemStack)itemstack2) + j, k);
                        k1 -= l - j;
                        slot1.setByPlayer(itemstack2.copyWithCount(l));
                        if (!(slot1 instanceof SlotExtended) || !((SlotExtended)slot1).isPhantom()) continue;
                        phantomCount += l - j;
                    }
                    itemstack2.setCount(k1 + phantomCount);
                    this.setCarried(itemstack2);
                }
                this.resetQuickCraft();
            } else {
                this.resetQuickCraft();
            }
        } else if (this.quickcraftStatus != 0) {
            this.resetQuickCraft();
        } else if (slot instanceof SlotExtended && ((SlotExtended)slot).isPhantom()) {
            this.slotClickPhantom(slot, dragType, clickType, player);
        } else {
            super.clicked(slotId, dragType, clickType, player);
        }
    }

    protected void resetQuickCraft() {
        super.resetQuickCraft();
        this.quickcraftStatus = 0;
        this.quickcraftSlots.clear();
    }

    private ItemStack slotClickPhantom(Slot slot, int mouseButton, ClickType clickType, Player player) {
        ItemStack stack = ItemStack.EMPTY;
        if (mouseButton == 2) {
            if (((SlotExtended)slot).isAdjustable()) {
                slot.set(ItemStack.EMPTY);
            }
        } else if (mouseButton == 0 || mouseButton == 1) {
            slot.setChanged();
            ItemStack stackSlot = slot.getItem();
            ItemStack stackHeld = this.getCarried();
            if (!stackSlot.isEmpty()) {
                stack = stackSlot.copy();
            }
            if (stackSlot.isEmpty()) {
                if (!stackHeld.isEmpty() && slot.mayPlace(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, clickType);
                }
            } else if (stackHeld.isEmpty()) {
                this.adjustPhantomSlot(slot, mouseButton, clickType);
                slot.onTake(player, this.getCarried());
            } else if (slot.mayPlace(stackHeld)) {
                if (ItemStack.isSameItemSameComponents((ItemStack)stackSlot, (ItemStack)stackHeld)) {
                    this.adjustPhantomSlot(slot, mouseButton, clickType);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, clickType);
                }
            }
        }
        return stack;
    }

    protected void adjustPhantomSlot(Slot slot, int mouseButton, ClickType clickType) {
        int stackSize;
        if (!((SlotExtended)slot).isAdjustable()) {
            return;
        }
        ItemStack stackSlot = slot.getItem();
        if (clickType == ClickType.QUICK_MOVE) {
            stackSize = mouseButton == 0 ? (stackSlot.getCount() + 1) / 2 : stackSlot.getCount() * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.getCount() - 1 : stackSlot.getCount() + 1;
        }
        if (stackSize > slot.getMaxStackSize()) {
            stackSize = slot.getMaxStackSize();
        }
        stackSlot.setCount(stackSize);
        if (stackSlot.getCount() <= 0) {
            slot.set(ItemStack.EMPTY);
        }
    }

    protected void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton, ClickType clickType) {
        int stackSize;
        if (!((SlotExtended)slot).isAdjustable()) {
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.getCount() : 1;
        if (stackSize > slot.getMaxStackSize()) {
            stackSize = slot.getMaxStackSize();
        }
        ItemStack phantomStack = stackHeld.copy();
        phantomStack.setCount(stackSize);
        slot.set(phantomStack);
    }

    @Override
    public void putButtonAction(String buttonId, IContainerButtonAction<ContainerExtended> action) {
        this.buttonActions.put(buttonId, action);
    }

    @Override
    public boolean onButtonClick(String buttonId) {
        IContainerButtonAction<ContainerExtended> action = this.buttonActions.get(buttonId);
        if (action != null) {
            action.onAction(buttonId, this);
            return true;
        }
        return false;
    }

    protected int getNextValueId() {
        return this.nextValueId++;
    }

    @Override
    public void setValue(int valueId, CompoundTag value) {
        if (!this.values.containsKey(valueId) || !this.values.get(valueId).equals((Object)value)) {
            try {
                if (!this.player.level().isClientSide()) {
                    CyclopsCoreInstance.MOD.getPacketHandler().sendToPlayer(new ValueNotifyPacket(this.getType(), valueId, value), (ServerPlayer)this.player);
                } else {
                    CyclopsCoreInstance.MOD.getPacketHandler().sendToServer(new ValueNotifyPacket(this.getType(), valueId, value));
                }
                this.values.put(valueId, value);
            }
            catch (EncoderException e) {
                CyclopsCoreInstance.MOD.log(Level.WARN, e.getMessage());
            }
        }
    }

    @Override
    public CompoundTag getValue(int valueId) {
        return this.values.get(valueId);
    }

    @Override
    public Set<Integer> getValueIds() {
        return this.values.keySet();
    }

    @Override
    public MenuType<?> getValueNotifiableType() {
        return this.getType();
    }

    @Override
    public void onUpdate(int valueId, CompoundTag value) {
        this.values.put(valueId, value);
        if (this.guiValueListener != null) {
            this.guiValueListener.onUpdate(valueId, value);
        }
    }

    public <T> Supplier<T> registerSyncedVariable(Class<T> clazz, Supplier<T> serverValueSupplier) {
        SyncedGuiVariable<T> variable = new SyncedGuiVariable<T>(this, clazz, serverValueSupplier, (HolderLookup.Provider)this.player.level().registryAccess());
        this.syncedGuiVariables.add(variable);
        return variable;
    }
}

