/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.CyclopsCoreNeoForge;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.packet.SendRecipeDisplayPacket;

public class RequestRecipeDisplayPacket
extends PacketCodec<RequestRecipeDisplayPacket> {
    public static final CustomPacketPayload.Type<RequestRecipeDisplayPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cyclopscore", (String)"request_recipe_display_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestRecipeDisplayPacket> CODEC = RequestRecipeDisplayPacket.getCodec(RequestRecipeDisplayPacket::new);
    @CodecField
    private String recipeType;
    @CodecField
    private String recipe;

    public RequestRecipeDisplayPacket() {
        super(TYPE);
    }

    public RequestRecipeDisplayPacket(RecipeType<?> recipeType, ResourceLocation recipe) {
        this();
        this.recipeType = recipeType.toString();
        this.recipe = recipe.toString();
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level level, Player player) {
    }

    @Override
    public void actionServer(Level level, ServerPlayer player) {
        List<RecipeDisplayEntry> recipeDisplays = IModHelpers.get().getCraftingHelpers().getRecipeDisplays((RecipeType)BuiltInRegistries.RECIPE_TYPE.getValue(ResourceLocation.parse((String)this.recipeType)), ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)this.recipe)));
        if (recipeDisplays.isEmpty()) {
            CyclopsCoreNeoForge.clog(org.apache.logging.log4j.Level.ERROR, "Received an invalid recipe request for recipe type " + this.recipeType.toString() + " with recipe id " + this.recipe + " from " + String.valueOf(player.getName()));
            return;
        }
        CyclopsCoreNeoForge._instance.getPacketHandler().sendToPlayer(new SendRecipeDisplayPacket(this.recipeType, this.recipe, recipeDisplays.getFirst()), player);
    }
}

