/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.core;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import me.ichun.mods.ichunutil.loader.event.client.LivingRenderPreEvent;
import me.ichun.mods.ichunutil.loader.event.listener.EventListener;
import me.ichun.mods.ichunutil.loader.event.listener.EventListenerBi;
import me.ichun.mods.ichunutil.loader.event.listener.EventListenerBoolean;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class EventHandlerClient {
    private EventListener<Minecraft> clientTickStartListener;
    private EventListener<Minecraft> clientTickEndListener;
    private EventListener<Minecraft> clientConnectListener;
    private EventListener<Minecraft> clientDisconnectListener;
    private EventListener<LevelAccessor> clientLevelLoadListener;
    private EventListenerBi<Level, Entity> clientEntityJoinLevelListener;
    private EventListenerBoolean<LivingRenderPreEvent> livingRenderPreListener;

    public abstract void registerKeyMapping(KeyMapping var1, Object var2, String ... var3);

    protected abstract void registerAsClientTickStartListener(EventListener<Minecraft> var1);

    public final void registerClientTickStartListener(Consumer<Minecraft> consumer) {
        if (this.clientTickStartListener == null) {
            this.clientTickStartListener = new EventListener(this::registerAsClientTickStartListener);
        }
        this.clientTickStartListener.register(consumer);
    }

    protected abstract void registerAsClientTickEndListener(EventListener<Minecraft> var1);

    public final void registerClientTickEndListener(Consumer<Minecraft> consumer) {
        if (this.clientTickEndListener == null) {
            this.clientTickEndListener = new EventListener(this::registerAsClientTickEndListener);
        }
        this.clientTickEndListener.register(consumer);
    }

    protected abstract void registerAsOnClientConnectListener(EventListener<Minecraft> var1);

    public final void registerOnClientConnectListener(Consumer<Minecraft> consumer) {
        if (this.clientConnectListener == null) {
            this.clientConnectListener = new EventListener(this::registerAsOnClientConnectListener);
        }
        this.clientConnectListener.register(consumer);
    }

    protected abstract void registerAsOnClientDisconnectListener(EventListener<Minecraft> var1);

    public final void registerOnClientDisconnectListener(Consumer<Minecraft> consumer) {
        if (this.clientDisconnectListener == null) {
            this.clientDisconnectListener = new EventListener(this::registerAsOnClientDisconnectListener);
        }
        this.clientDisconnectListener.register(consumer);
    }

    protected abstract void registerClientLevelLoadListener(EventListener<LevelAccessor> var1);

    public final void registerClientLevelLoadListener(Consumer<LevelAccessor> consumer) {
        if (this.clientLevelLoadListener == null) {
            this.clientLevelLoadListener = new EventListener(this::registerClientLevelLoadListener);
        }
        this.clientLevelLoadListener.register(consumer);
    }

    protected abstract void registerClientEntityJoinLevelListener(EventListenerBi<Level, Entity> var1);

    public final void registerClientEntityJoinLevelListener(BiConsumer<Level, Entity> consumer) {
        if (this.clientEntityJoinLevelListener == null) {
            this.clientEntityJoinLevelListener = new EventListenerBi(this::registerClientEntityJoinLevelListener);
        }
        this.clientEntityJoinLevelListener.register(consumer);
    }

    private void createLivingRenderPreListener() {
        if (this.livingRenderPreListener == null) {
            this.livingRenderPreListener = new EventListenerBoolean(null);
        }
    }

    public final void registerLivingRenderPreListener(Consumer<LivingRenderPreEvent> consumer) {
        this.createLivingRenderPreListener();
        this.livingRenderPreListener.register(consumer);
    }

    public final void registerCancelableLivingRenderPreListener(Function<LivingRenderPreEvent, Boolean> function) {
        this.createLivingRenderPreListener();
        this.livingRenderPreListener.register(function);
    }

    public <E extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>> boolean fireLivingRenderPreEvent(E livingEntity, LivingEntityRenderer<E, S, M> renderer, S renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float partialTick) {
        return this.livingRenderPreListener != null && this.livingRenderPreListener.trigger(new LivingRenderPreEvent(livingEntity, renderer, renderState, poseStack, bufferSource, packedLight, partialTick));
    }

    public boolean fireClientHandleSystemMessage(Component message, boolean isOverlay) {
        return false;
    }

    public void fireClientLevelLoad(ClientLevel level) {
    }

    public abstract void fireOverlayChange(@Nullable Overlay var1, @Nullable Overlay var2);

    public boolean fireMouseScroll(double scrollDeltaX, double scrollDeltaY) {
        return false;
    }

    public String getPlayerName() {
        return Minecraft.getInstance().getUser().getName();
    }

    @Nullable
    public LocalPlayer getPlayer() {
        return Minecraft.getInstance().player;
    }

    @Nullable
    public ClientLevel getWorld() {
        return Minecraft.getInstance().level;
    }

    public String getLocalisedString(String s, Object ... params) {
        return I18n.get((String)s, (Object[])params);
    }
}

