/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.contextmenu.IContextMenu;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowContextMenu<M extends Workspace, I>
extends Window<M, View<?>> {
    private final ElementList<ViewContextMenu, I> list;
    private int minWidth = 1;
    private boolean killed;

    private WindowContextMenu(M parent) {
        super(parent);
        this.setBorderSize(() -> 1);
        this.setView(new ViewContextMenu(this, this, ""));
        this.list = (ElementList)((View)this.getCurrentView()).elements.get(1);
        this.disableTitle();
        this.disableDocking();
        this.disableDockStacking();
        this.disableDrag();
        this.disableDragResize();
        this.disableUndocking();
    }

    private ElementList<ViewContextMenu, I> getList() {
        return this.list;
    }

    private void setupAround(double posX, double posY, int minWidth, int yFlipHeight) {
        this.width = this.minWidth = minWidth;
        this.resize(Minecraft.getInstance(), this.parent.getWidth(), this.parent.getHeight());
        this.height = this.list.getTotalItemHeight() + (Integer)this.borderSize.get() * 2 + this.list.getBorderSize() * 2;
        int pX = (int)posX;
        int pY = (int)posY;
        int screenWidth = this.parent.getWidth();
        int screenHeight = this.parent.getHeight();
        int tooltipX = pX;
        if (tooltipX + minWidth > screenWidth) {
            tooltipX = pX - minWidth;
        }
        int tooltipY = pY;
        int tooltipHeight = this.height;
        if (tooltipY < 0) {
            tooltipY = 0;
        } else if (tooltipY + tooltipHeight > screenHeight) {
            if (tooltipHeight > pY - yFlipHeight) {
                this.height = tooltipHeight = Math.min(Math.max(pY - yFlipHeight, screenHeight - tooltipY) - 2, this.list.getTotalItemHeight() + (Integer)this.borderSize.get() * 2 + this.list.getBorderSize() * 2);
            }
            if (tooltipY + tooltipHeight > screenHeight && (tooltipY = pY - yFlipHeight - tooltipHeight) < 0) {
                tooltipY = screenHeight - tooltipHeight;
            }
        }
        this.constraint.apply();
        this.pos(tooltipX, tooltipY);
        this.resize(Minecraft.getInstance(), this.parent.getWidth(), this.parent.getHeight());
    }

    @Override
    public int getMinWidth() {
        return this.minWidth;
    }

    @Override
    public void unfocus(@Nullable GuiEventListener guiReplacing) {
        super.unfocus(guiReplacing);
        if (!this.killed) {
            this.killed = true;
            this.parent.removeWindow(this);
        }
    }

    public static <W extends Workspace, I, M extends IContextMenu<M, I>> WindowContextMenu<W, I> create(W parent, M context, double posX, double posY, int minWidth, int yFlipHeight) {
        WindowContextMenu<W, I> windowContextMenu = new WindowContextMenu<W, I>(parent);
        ElementList list = windowContextMenu.getList();
        List<I> contextMenuObjects = context.getObjects();
        Function nameProvider = context.getNameProvider();
        BiConsumer contextMenuContext = context.getReceiver();
        contextMenuObjects.forEach(o -> list.addItem(o).addTextWrapper((String)((List)nameProvider.apply(o)).getFirst()).setSelectionHandler(item -> {
            ((Workspace)item.getWorkspace()).setFocused(null);
            contextMenuContext.accept(context, (ElementList.Item)item);
        }));
        if (((Workspace)windowContextMenu.getWorkspace()).hasInit()) {
            windowContextMenu.init();
        }
        windowContextMenu.setupAround(posX, posY, minWidth, yFlipHeight);
        ((Workspace)windowContextMenu.getWorkspace()).addWindow(windowContextMenu);
        ((Workspace)windowContextMenu.getWorkspace()).setFocused((GuiEventListener)windowContextMenu);
        return windowContextMenu;
    }

    private class ViewContextMenu
    extends View<WindowContextMenu<M, I>> {
        public ViewContextMenu(@NotNull WindowContextMenu windowContextMenu, @NotNull WindowContextMenu<M, I> parent, String s) {
            super(parent, s);
            ElementScrollBar sv = new ElementScrollBar(this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
            sv.setConstraint(new Constraint(sv).top(this, Constraint.Property.Type.TOP, 0).bottom(this, Constraint.Property.Type.BOTTOM, 0).right(this, Constraint.Property.Type.RIGHT, 0));
            this.elements.add(sv);
            ElementList list = new ElementList(this);
            ((Fragment)list.setScrollVertical(sv)).setConstraint(new Constraint(list).left(this, Constraint.Property.Type.LEFT, 0).bottom(this, Constraint.Property.Type.BOTTOM, 0).top(this, Constraint.Property.Type.TOP, 0).right(sv, Constraint.Property.Type.LEFT, 0));
            this.elements.add(list);
        }
    }
}

