/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButtonAbstract;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementButtonTextured
extends ElementButtonAbstract<ElementButtonTextured> {
    public ResourceLocation textureLocation;
    public boolean warping;

    public ElementButtonTextured(@NotNull Fragment<?> parent, ResourceLocation rl, TriConsumer<ElementButtonTextured, Double, Double> callback, @Nullable TriConsumer<ElementButtonTextured, Double, Double> rightMouseCallback) {
        super(parent, "", callback, rightMouseCallback);
        this.textureLocation = rl;
    }

    public ElementButtonTextured(@NotNull Fragment<?> parent, ResourceLocation rl, TriConsumer<ElementButtonTextured, Double, Double> callback) {
        this(parent, rl, callback, null);
    }

    public ElementButtonTextured setWarping() {
        this.warping = true;
        return this;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack stack = graphics.pose();
        if (this.warping) {
            RenderHelper.draw(this.textureLocation, stack, this.getLeft() + 2, this.getTop() + 2, this.width - 4, this.height - 4, 0.0);
        } else {
            int length = Math.min(this.width, this.height) - 4;
            int x = (int)((double)this.getLeft() + (double)this.width / 2.0 - (double)length / 2.0);
            int y = (int)((double)this.getTop() + (double)this.height / 2.0 - (double)length / 2.0);
            RenderHelper.draw(this.textureLocation, stack, x, y, length, length, 0.0);
        }
    }
}

