/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.TextureDefinition;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class ElementScrollBar
extends Element<Fragment<?>> {
    public final Orientation orientation;
    private float scrollBarSize;
    public Consumer<ElementScrollBar> callback;
    public float scrollProg;
    public boolean resizing;
    public Element.MousePos pos;

    public ElementScrollBar(@NotNull Fragment<?> parent, Orientation orientation, float scrollBarSize) {
        super(parent);
        this.orientation = orientation;
        this.scrollBarSize = scrollBarSize;
    }

    public ElementScrollBar setCallback(Consumer<ElementScrollBar> callback) {
        this.callback = callback;
        return this;
    }

    public void setScrollBarSize(float f) {
        f = Math.min(f, 1.01f);
        float oldSize = this.scrollBarSize;
        this.scrollBarSize = f;
        float size = (float)(this.orientation == Orientation.VERTICAL ? this.height : this.width) * f;
        if (size < 4.0f) {
            this.scrollBarSize = 4.0f / (float)this.getDistance();
        }
        this.updateSize(oldSize);
    }

    public float getScrollbarSize() {
        return this.scrollBarSize;
    }

    public void setScrollProg(float f) {
        float scroll = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        if (scroll != this.scrollProg) {
            this.scrollProg = scroll;
            if (this.callback != null) {
                this.callback.accept(this);
            }
        }
    }

    private void updateSize(float oldSize) {
        if (this.scrollBarSize > 1.0f) {
            switch (this.orientation.ordinal()) {
                case 0: {
                    this.width = 0;
                    break;
                }
                case 1: {
                    this.height = 0;
                }
            }
            this.setScrollProg(0.0f);
        } else {
            this.setScrollProg(this.scrollProg / oldSize * this.scrollBarSize);
        }
        if (!this.resizing && (oldSize <= 1.0f && this.scrollBarSize > 1.0f || this.scrollBarSize <= 1.0f && oldSize > 1.0f)) {
            this.resizing = true;
            this.constraint.apply();
            ((Fragment)this.parent).resize(((Workspace)this.getWorkspace()).getMinecraft(), ((Fragment)this.parent).getParentWidth(), ((Fragment)this.parent).getParentHeight());
            this.resizing = false;
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        PoseStack stack = graphics.pose();
        int scrollBar = Math.max(8, (int)((float)this.getDistance() * this.scrollBarSize));
        int space = this.getDistance() - scrollBar;
        int preSpace = (int)((float)space * this.scrollProg);
        if (this.renderMinecraftStyle() > 0) {
            TextureDefinition texdefScroller = TEXDEF_SCROLLER;
            if (this.orientation == Orientation.VERTICAL) {
                int dist;
                VertexConsumer vertexConsumer = RenderHelper.startDrawBatch(this.resourceTabItems());
                int i = this.height - 6;
                int x = this.getTop() + 3;
                while (i > 0) {
                    dist = Math.min(i, 106);
                    RenderHelper.drawBatch(stack, vertexConsumer, this.getLeft(), x, 14.0, dist, 0.0, 0.6796875, 0.734375, 0.078125, 0.4921875);
                    i -= dist;
                    x += dist;
                }
                RenderHelper.drawBatch(stack, vertexConsumer, this.getLeft(), this.getTop(), 14.0, 3.0, 0.0, 0.6796875, 0.734375, 0.06640625, 0.078125);
                RenderHelper.drawBatch(stack, vertexConsumer, this.getLeft(), this.getBottom() - 3, 14.0, 3.0, 0.0, 0.6796875, 0.734375, 0.4921875, 0.50390625);
                RenderHelper.endDrawBatch();
                vertexConsumer = RenderHelper.startDrawBatch(this.resourceScroller());
                i = scrollBar - 7 - 2;
                x = this.getTop() + preSpace + 4 + 1;
                while (i > 0) {
                    dist = Math.min(i, 8);
                    RenderHelper.drawBatch(stack, vertexConsumer, this.getLeft() + 1, x, 12.0, dist, 0.0, (double)texdefScroller.x1() / texdefScroller.width(), (double)texdefScroller.x2() / texdefScroller.width(), 4.0 / texdefScroller.height(), (double)(4 + dist) / texdefScroller.height());
                    i -= dist;
                    x += dist;
                }
                RenderHelper.drawBatch(stack, vertexConsumer, this.getLeft() + 1, this.getTop() + preSpace + 1, 12.0, 4.0, 0.0, (double)texdefScroller.x1() / texdefScroller.width(), (double)texdefScroller.x2() / texdefScroller.width(), 0.0 / texdefScroller.height(), 4.0 / texdefScroller.height());
                RenderHelper.drawBatch(stack, vertexConsumer, this.getLeft() + 1, this.getTop() + preSpace + scrollBar - 3 - 1, 12.0, 3.0, 0.0, (double)texdefScroller.x1() / texdefScroller.width(), (double)texdefScroller.x2() / texdefScroller.width(), 12.0 / texdefScroller.height(), 15.0 / texdefScroller.height());
                RenderHelper.endDrawBatch();
            } else {
                int dist;
                VertexConsumer vertexConsumer = RenderHelper.startDrawBatch(this.resourceTabItems());
                int i = this.width - 6;
                int x = this.getLeft() + 3;
                while (i > 0) {
                    dist = Math.min(i, 106);
                    ElementScrollBar.drawBatch(stack, vertexConsumer, x, this.getTop(), dist, 14.0, 0.0, 0.6796875, 0.734375, 0.078125, 0.4921875);
                    i -= dist;
                    x += dist;
                }
                ElementScrollBar.drawBatch(stack, vertexConsumer, this.getLeft(), this.getTop(), 3.0, 14.0, 0.0, 0.6796875, 0.734375, 0.06640625, 0.078125);
                ElementScrollBar.drawBatch(stack, vertexConsumer, this.getRight() - 3, this.getTop(), 3.0, 14.0, 0.0, 0.6796875, 0.734375, 0.4921875, 0.50390625);
                vertexConsumer = RenderHelper.startDrawBatch(this.resourceScroller());
                i = scrollBar - 7 - 2;
                x = this.getLeft() + preSpace + 4 + 1;
                while (i > 0) {
                    dist = Math.min(i, 8);
                    ElementScrollBar.drawBatch(stack, vertexConsumer, x, this.getTop() + 1, dist, 12.0, 0.0, (double)texdefScroller.x1() / texdefScroller.width(), (double)texdefScroller.x2() / texdefScroller.width(), 4.0 / texdefScroller.height(), (double)(4 + dist) / texdefScroller.height());
                    i -= dist;
                    x += dist;
                }
                ElementScrollBar.drawBatch(stack, vertexConsumer, this.getLeft() + preSpace + 1, this.getTop() + 1, 4.0, 12.0, 0.0, (double)texdefScroller.x1() / texdefScroller.width(), (double)texdefScroller.x2() / texdefScroller.width(), 0.0 / texdefScroller.height(), 4.0 / texdefScroller.height());
                ElementScrollBar.drawBatch(stack, vertexConsumer, this.getLeft() + preSpace + scrollBar - 3 - 1, this.getTop() + 1, 3.0, 12.0, 0.0, (double)texdefScroller.x1() / texdefScroller.width(), (double)texdefScroller.x2() / texdefScroller.width(), 12.0 / texdefScroller.height(), 15.0 / texdefScroller.height());
            }
        } else {
            this.fill(graphics, this.getTheme().elementScrollBarBackground, 0);
            if (this.orientation == Orientation.VERTICAL) {
                RenderHelper.drawColour(graphics, this.getTheme().elementScrollBarBorder, 255, (double)(this.getLeft() + 6), (double)(this.getTop() + 4), 2.0, (double)(this.height - 8), 0.0);
                RenderHelper.drawColour(graphics, this.getTheme().elementScrollBarBorder, 255, (double)this.getLeft(), (double)(this.getTop() + preSpace), 14.0, (double)scrollBar, 0.0);
                RenderHelper.drawColour(graphics, this.getTheme().elementScrollBar, 255, (double)(this.getLeft() + 1), (double)(this.getTop() + preSpace + 1), 12.0, (double)(scrollBar - 2), 0.0);
            } else {
                RenderHelper.drawColour(graphics, this.getTheme().elementScrollBarBorder, 255, (double)(this.getLeft() + 4), (double)(this.getTop() + 6), (double)(this.width - 8), 2.0, 0.0);
                RenderHelper.drawColour(graphics, this.getTheme().elementScrollBarBorder, 255, (double)(this.getLeft() + preSpace), (double)this.getTop(), (double)scrollBar, 14.0, 0.0);
                RenderHelper.drawColour(graphics, this.getTheme().elementScrollBar, 255, (double)(this.getLeft() + preSpace + 1), (double)(this.getTop() + 1), (double)(scrollBar - 2), 12.0, 0.0);
            }
        }
    }

    public int getDistance() {
        return this.orientation == Orientation.VERTICAL ? this.height : this.width;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.pos = new Element.MousePos((int)mouseX, (int)mouseY);
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double distX, double distY) {
        if (this.pos != null) {
            int moved = this.orientation == Orientation.VERTICAL ? (int)mouseY - this.pos.y : (int)mouseX - this.pos.x;
            if (moved != 0) {
                this.setScrollProg(this.scrollProg + (float)moved / ((float)this.getDistance() * (1.0f - this.scrollBarSize)));
            }
            this.pos.x = (int)mouseX;
            this.pos.y = (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isMouseOver(mouseX, mouseY) && this.scrollBarSize < 1.0f) {
            if (Screen.hasShiftDown()) {
                this.setScrollProg((float)scrollY * -100.0f);
            } else if (Screen.hasControlDown()) {
                this.setScrollProg(this.scrollProg + (float)(scrollY * -0.01));
            } else {
                this.secondHandScroll(scrollY);
            }
            return true;
        }
        return false;
    }

    public void secondHandScroll(double dist) {
        this.setScrollProg(this.scrollProg + (float)(dist * -0.1));
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.pos = null;
        super.mouseReleased(mouseX, mouseY, button);
        ((Fragment)this.parent).setFocused(null);
        return this.getFocused() != null && this.getFocused().mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        return null;
    }

    @Override
    public int getMinWidth() {
        return this.orientation == Orientation.VERTICAL && this.scrollBarSize < 1.0f ? 14 : 0;
    }

    @Override
    public int getMinHeight() {
        return this.orientation == Orientation.HORIZONTAL && this.scrollBarSize < 1.0f ? 14 : 0;
    }

    @Override
    public int getMaxWidth() {
        return this.orientation == Orientation.VERTICAL && this.scrollBarSize < 1.0f ? 14 : (this.orientation == Orientation.HORIZONTAL ? 10000 : 0);
    }

    @Override
    public int getMaxHeight() {
        return this.orientation == Orientation.HORIZONTAL && this.scrollBarSize < 1.0f ? 14 : (this.orientation == Orientation.VERTICAL ? 10000 : 0);
    }

    private static void drawBatch(PoseStack stack, VertexConsumer vertexConsumer, double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        Matrix4f matrix = stack.last().pose();
        vertexConsumer.addVertex(matrix, (float)posX, (float)(posY + height), (float)zLevel).setUv((float)u2, (float)v1).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vertexConsumer.addVertex(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).setUv((float)u2, (float)v2).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vertexConsumer.addVertex(matrix, (float)(posX + width), (float)posY, (float)zLevel).setUv((float)u1, (float)v2).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vertexConsumer.addVertex(matrix, (float)posX, (float)posY, (float)zLevel).setUv((float)u1, (float)v1).setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

