/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementToggleAbstract;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class ElementToggleTextured
extends ElementToggleAbstract<ElementToggleTextured> {
    public ResourceLocation textureLocation;
    public boolean warping;

    public ElementToggleTextured(@NotNull Fragment<?> parent, @NotNull String tooltip, ResourceLocation rl, TriConsumer<ElementToggleTextured, Double, Double> callback, TriConsumer<ElementToggleTextured, Double, Double> rightMouseCallback) {
        super(parent, "", callback, rightMouseCallback);
        this.tooltip = tooltip;
        this.textureLocation = rl;
    }

    public ElementToggleTextured(@NotNull Fragment<?> parent, @NotNull String tooltip, ResourceLocation rl, TriConsumer<ElementToggleTextured, Double, Double> callback) {
        this(parent, tooltip, rl, callback, null);
    }

    public ElementToggleTextured setWarping() {
        this.warping = true;
        return this;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack stack = graphics.pose();
        if (this.warping) {
            RenderHelper.draw(this.textureLocation, stack, this.getLeft() + 2, this.getTop() + 2, this.width - 4, this.height - 4, 0.0);
        } else {
            int length = Math.min(this.width, this.height) - 4;
            int x = (int)((double)this.getLeft() + (double)this.width / 2.0 - (double)length / 2.0);
            int y = (int)((double)this.getTop() + (double)this.height / 2.0 - (double)length / 2.0);
            RenderHelper.draw(this.textureLocation, stack, x, y, length, length, 0.0);
        }
    }
}

