/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class RenderHelper {
    public static MultiBufferSource.BufferSource getBufferSource() {
        return Minecraft.getInstance().renderBuffers().bufferSource();
    }

    public static void draw(ResourceLocation resourceLocation, PoseStack stack, double posX, double posY, double width, double height, double zLevel) {
        RenderHelper.draw(RenderType::guiTextured, resourceLocation, stack, posX, posY, width, height, zLevel);
    }

    public static void draw(Function<ResourceLocation, RenderType> renderTypeGetter, ResourceLocation resourceLocation, PoseStack stack, double posX, double posY, double width, double height, double zLevel) {
        RenderHelper.draw(renderTypeGetter, resourceLocation, stack, posX, posY, width, height, zLevel, 0.0, 1.0, 0.0, 1.0);
    }

    public static void draw(ResourceLocation resourceLocation, PoseStack stack, double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        RenderHelper.draw(RenderType::guiTextured, resourceLocation, stack, posX, posY, width, height, zLevel, u1, u2, v1, v2);
    }

    public static void draw(Function<ResourceLocation, RenderType> renderTypeGetter, ResourceLocation resourceLocation, PoseStack stack, double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        VertexConsumer vertexConsumer = RenderHelper.startDrawBatch(renderTypeGetter, resourceLocation);
        RenderHelper.drawBatch(stack, vertexConsumer, posX, posY, width, height, zLevel, u1, u2, v1, v2);
        RenderHelper.getBufferSource().endLastBatch();
    }

    public static VertexConsumer startDrawBatch(ResourceLocation resourceLocation) {
        return RenderHelper.startDrawBatch(RenderType::guiTextured, resourceLocation);
    }

    public static VertexConsumer startDrawBatch(Function<ResourceLocation, RenderType> renderTypeGetter, ResourceLocation resourceLocation) {
        RenderType renderType = renderTypeGetter.apply(resourceLocation);
        return RenderHelper.getBufferSource().getBuffer(renderType);
    }

    public static void drawBatch(PoseStack stack, VertexConsumer vertexConsumer, double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        Matrix4f matrix = stack.last().pose();
        vertexConsumer.addVertex(matrix, (float)posX, (float)(posY + height), (float)zLevel).setUv((float)u1, (float)v2).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vertexConsumer.addVertex(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).setUv((float)u2, (float)v2).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vertexConsumer.addVertex(matrix, (float)(posX + width), (float)posY, (float)zLevel).setUv((float)u2, (float)v1).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vertexConsumer.addVertex(matrix, (float)posX, (float)posY, (float)zLevel).setUv((float)u1, (float)v1).setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void endDrawBatch() {
        RenderHelper.getBufferSource().endLastBatch();
    }

    public static void drawColour(GuiGraphics graphics, int colour, int alpha, double posX, double posY, double width, double height, double zLevel) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        RenderHelper.drawColour(graphics, r, g, b, alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColour(GuiGraphics graphics, int[] rgb, int alpha, double posX, double posY, double width, double height, double zLevel) {
        RenderHelper.drawColour(graphics, rgb[0], rgb[1], rgb[2], alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColour(GuiGraphics graphics, int r, int g, int b, int alpha, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        Matrix4f matrix = graphics.pose().last().pose();
        VertexConsumer bufferbuilder = RenderHelper.getBufferSource().getBuffer(RenderType.gui());
        bufferbuilder.addVertex(matrix, (float)posX, (float)(posY + height), (float)zLevel).setColor(r, g, b, alpha);
        bufferbuilder.addVertex(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).setColor(r, g, b, alpha);
        bufferbuilder.addVertex(matrix, (float)(posX + width), (float)posY, (float)zLevel).setColor(r, g, b, alpha);
        bufferbuilder.addVertex(matrix, (float)posX, (float)posY, (float)zLevel).setColor(r, g, b, alpha);
        RenderHelper.getBufferSource().endLastBatch();
    }

    public static void colour(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void colour(int color, float alpha) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)alpha);
    }

    public static int getRandomColourFromString(String s) {
        Random rand = new Random();
        rand.setSeed(Math.abs(s.hashCode() * 1000));
        int clr = Math.round(1.6777215E7f * rand.nextFloat());
        float[] hsb = new float[3];
        Color.RGBtoHSB(clr >> 16 & 0xFF, clr >> 8 & 0xFF, clr & 0xFF, hsb);
        hsb[2] = 0.65f + 0.25f * hsb[2];
        clr = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        return clr;
    }

    public static void startGlScissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.getInstance();
        double scaleW = (double)mc.getWindow().getWidth() / (double)mc.getWindow().getGuiScaledWidth();
        double scaleH = (double)mc.getWindow().getHeight() / (double)mc.getWindow().getGuiScaledHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        RenderSystem.enableScissor((int)((int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.getWindow().getHeight() - (double)(y + height) * scaleH)), (int)((int)Math.floor((double)(x + width) * scaleW) - (int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.getWindow().getHeight() - (double)y * scaleH) - (int)Math.floor((double)mc.getWindow().getHeight() - (double)(y + height) * scaleH)));
    }

    public static void endGlScissor() {
        RenderSystem.disableScissor();
    }

    public static void renderTestScissor(GuiGraphics graphics) {
        Minecraft mc = Minecraft.getInstance();
        RenderHelper.startGlScissor(mc.getWindow().getGuiScaledWidth() / 2 - 50, mc.getWindow().getGuiScaledHeight() / 2 - 50, 100, 100);
        RenderHelper.drawColour(graphics, 0xFFFFFF, 255, 0.0, 0.0, (double)mc.getWindow().getGuiScaledWidth(), (double)mc.getWindow().getGuiScaledHeight(), 0.0);
        RenderHelper.endGlScissor();
    }
}

