/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.loader.event.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.ref.WeakReference;
import java.util.function.Predicate;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public record LivingRenderPreEvent(LivingEntity livingEntity, LivingEntityRenderer<?, ?, ?> renderer, LivingEntityRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float partialTick) {

    public static class LastRenderedEntitySupplier<E extends LivingEntity> {
        public final Predicate<LivingRenderPreEvent> predicate;
        @Nullable
        private WeakReference<E> entity;

        public LastRenderedEntitySupplier(Predicate<LivingRenderPreEvent> predicate) {
            this.predicate = predicate;
            iChunUtil.eC().registerClientLevelLoadListener(level -> this.clean());
            iChunUtil.eC().registerOnClientDisconnectListener(client -> this.clean());
            iChunUtil.eC().registerLivingRenderPreListener(this::onLivingRenderPreEvent);
        }

        private void clean() {
            this.entity = null;
        }

        private void onLivingRenderPreEvent(LivingRenderPreEvent event) {
            if (this.predicate.test(event)) {
                this.entity = new WeakReference<LivingEntity>(event.livingEntity);
            }
        }

        @Nullable
        public E get() {
            if (this.entity == null || this.entity.get() == null) {
                return null;
            }
            return (E)((LivingEntity)this.entity.get());
        }
    }
}

