/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.loader.event.listener;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class EventListenerBoolean<T> {
    private final ArrayList<Function<T, Boolean>> listeners = new ArrayList();

    public EventListenerBoolean(@Nullable Consumer<EventListenerBoolean<T>> registration) {
        if (registration != null) {
            registration.accept(this);
        }
    }

    public void register(Consumer<T> listener) {
        this.listeners.add(t -> {
            listener.accept(t);
            return false;
        });
    }

    public void register(Function<T, Boolean> listener) {
        this.listeners.add(listener);
    }

    public boolean trigger(T t) {
        for (Function<T, Boolean> listener : this.listeners) {
            if (!listener.apply(t).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

