/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.experimental.entity.block_caching.fire_lava_touching;

import com.google.common.base.Predicate;
import java.util.stream.Stream;
import net.caffeinemc.mods.lithium.common.tracking.VicinityCache;
import net.caffeinemc.mods.lithium.common.tracking.VicinityCacheProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements VicinityCacheProvider {
    private static final Stream<BlockState> EMPTY_BLOCKSTATE_STREAM = Stream.empty();
    @Shadow
    private int remainingFireTicks;
    @Shadow
    public boolean wasOnFire;
    @Shadow
    public boolean isInPowderSnow;

    @Shadow
    protected abstract int getFireImmuneTicks();

    @Shadow
    public abstract boolean isInWaterRainOrBubble();

    @Redirect(method={"applyEffectsFromBlocks(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", remap=false, target="Lcom/google/common/collect/Iterables;any(Ljava/lang/Iterable;Lcom/google/common/base/Predicate;)Z"))
    private boolean skipFireTestIfResultDoesNotMatterOrIsCached(Iterable<BlockState> iterable, Predicate<? super BlockState> predicate) {
        if (!(this.remainingFireTicks <= 0 && this.remainingFireTicks != -this.getFireImmuneTicks() || this.wasOnFire && (this.isInPowderSnow || this.isInWaterRainOrBubble()))) {
            return true;
        }
        VicinityCache bc = this.getUpdatedVicinityCache((Entity)this);
        byte cachedTouchingFireLava = bc.getIsTouchingFireLava();
        if (cachedTouchingFireLava == 0) {
            return true;
        }
        if (cachedTouchingFireLava == 1) {
            return false;
        }
        for (BlockState state : iterable) {
            if (!state.is(BlockTags.FIRE) && !state.is(Blocks.LAVA)) continue;
            bc.setCachedTouchingFireLava(true);
            return false;
        }
        bc.setCachedTouchingFireLava(false);
        return true;
    }
}

