/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.lootmanager;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.configs.RSMainModdedLootConfig;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.PlatformHooks;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.loot.LootTable;

public class StructureModdedLootImporter {
    public static final Map<ResourceKey<LootTable>, ResourceKey<LootTable>> TABLE_IMPORTS = StructureModdedLootImporter.createMap();
    private static Set<ResourceKey<LootTable>> BLACKLISTED_LOOTTABLES;

    public static Map<ResourceKey<LootTable>, ResourceKey<LootTable>> createMap() {
        Object2ObjectOpenHashMap tableMap = new Object2ObjectOpenHashMap();
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/cities/nether"), StructureModdedLootImporter.generateKey("minecraft", "chests/bastion_treasure"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/cities/overworld"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_plains_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ancient_cities/ocean"), StructureModdedLootImporter.generateKey("minecraft", "chests/ancient_city"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ancient_cities/ocean_ice_box"), StructureModdedLootImporter.generateKey("minecraft", "chests/ancient_city_ice_box"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ancient_cities/nether"), StructureModdedLootImporter.generateKey("minecraft", "chests/ancient_city"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ancient_cities/nether_magma_box"), StructureModdedLootImporter.generateKey("minecraft", "chests/ancient_city_ice_box"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ancient_cities/end"), StructureModdedLootImporter.generateKey("minecraft", "chests/ancient_city"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ancient_cities/end_spawner_box"), StructureModdedLootImporter.generateKey("minecraft", "chests/ancient_city_ice_box"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/bastions/underground/treasure"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_crossing"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/bastions/underground/bridge"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_corridor"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/bastions/underground/other"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_corridor"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/bastions/underground/skeleton_horse_stable"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_corridor"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/dungeons/badlands"), StructureModdedLootImporter.generateKey("minecraft", "chests/simple_dungeon"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/dungeons/dark_forest"), StructureModdedLootImporter.generateKey("minecraft", "chests/simple_dungeon"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/dungeons/deep"), StructureModdedLootImporter.generateKey("minecraft", "chests/simple_dungeon"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/dungeons/desert"), StructureModdedLootImporter.generateKey("minecraft", "chests/simple_dungeon"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/dungeons/icy"), StructureModdedLootImporter.generateKey("minecraft", "chests/simple_dungeon"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/dungeons/jungle"), StructureModdedLootImporter.generateKey("minecraft", "chests/simple_dungeon"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/dungeons/mushroom"), StructureModdedLootImporter.generateKey("minecraft", "chests/simple_dungeon"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/dungeons/nether"), StructureModdedLootImporter.generateKey("minecraft", "chests/simple_dungeon"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/dungeons/ocean"), StructureModdedLootImporter.generateKey("minecraft", "chests/simple_dungeon"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/dungeons/snow"), StructureModdedLootImporter.generateKey("minecraft", "chests/simple_dungeon"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/dungeons/swamp"), StructureModdedLootImporter.generateKey("minecraft", "chests/simple_dungeon"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "shulker_boxes/dungeons/end"), StructureModdedLootImporter.generateKey("minecraft", "chests/simple_dungeon"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/fortresses/jungle_center"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_crossing"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/fortresses/jungle_hallway"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_corridor"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/fortresses/jungle_shrine"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_crossing"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/igloos/grassy"), StructureModdedLootImporter.generateKey("minecraft", "chests/igloo_chest"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/igloos/stone"), StructureModdedLootImporter.generateKey("minecraft", "chests/igloo_chest"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/igloos/mangrove"), StructureModdedLootImporter.generateKey("minecraft", "chests/igloo_chest"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/igloos/mushroom"), StructureModdedLootImporter.generateKey("minecraft", "chests/igloo_chest"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mansions/birch"), StructureModdedLootImporter.generateKey("minecraft", "chests/woodland_mansion"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mansions/desert"), StructureModdedLootImporter.generateKey("minecraft", "chests/woodland_mansion"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mansions/jungle"), StructureModdedLootImporter.generateKey("minecraft", "chests/woodland_mansion"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mansions/mangrove"), StructureModdedLootImporter.generateKey("minecraft", "chests/woodland_mansion"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mansions/oak"), StructureModdedLootImporter.generateKey("minecraft", "chests/woodland_mansion"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mansions/savanna"), StructureModdedLootImporter.generateKey("minecraft", "chests/woodland_mansion"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mansions/snowy"), StructureModdedLootImporter.generateKey("minecraft", "chests/woodland_mansion"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mansions/taiga"), StructureModdedLootImporter.generateKey("minecraft", "chests/woodland_mansion"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/basalt"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/birch"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/crimson"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/dark_forest"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/desert"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/end"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/icy"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/jungle"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/nether"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/ocean"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/savanna"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/soul"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/stone"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/swamp"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/taiga"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/mineshafts/warped"), StructureModdedLootImporter.generateKey("minecraft", "chests/abandoned_mineshaft"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/basalt"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/badlands"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/birch"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/crimson"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/desert"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/giant_tree_taiga"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/icy"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/jungle"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/mangrove"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/nether_brick"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/oak"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/ocean"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/savanna"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/soul"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/snowy"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/taiga"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/outposts/warped"), StructureModdedLootImporter.generateKey("minecraft", "chests/pillager_outpost"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "shulker_boxes/outposts/end"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/pyramids/dark_forest"), StructureModdedLootImporter.generateKey("minecraft", "chests/desert_pyramid"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/pyramids/end"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/pyramids/flower_forest"), StructureModdedLootImporter.generateKey("minecraft", "chests/desert_pyramid"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/pyramids/giant_tree_taiga"), StructureModdedLootImporter.generateKey("minecraft", "chests/desert_pyramid"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/pyramids/icy"), StructureModdedLootImporter.generateKey("minecraft", "chests/desert_pyramid"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/pyramids/jungle"), StructureModdedLootImporter.generateKey("minecraft", "chests/desert_pyramid"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/pyramids/mushroom"), StructureModdedLootImporter.generateKey("minecraft", "chests/desert_pyramid"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/pyramids/snowy"), StructureModdedLootImporter.generateKey("minecraft", "chests/desert_pyramid"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "trapped_chests/pyramids/badlands"), StructureModdedLootImporter.generateKey("minecraft", "chests/desert_pyramid"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "trapped_chests/pyramids/end"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "trapped_chests/pyramids/nether"), StructureModdedLootImporter.generateKey("minecraft", "chests/desert_pyramid"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "trapped_chests/pyramids/ocean"), StructureModdedLootImporter.generateKey("minecraft", "chests/desert_pyramid"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "dispensers/pyramids/dark_forest"), StructureModdedLootImporter.generateKey("minecraft", "chests/desert_pyramid"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ruined_portals/end/large_portal"), StructureModdedLootImporter.generateKey("minecraft", "chests/ruined_portal"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ruined_portals/end/small_portal"), StructureModdedLootImporter.generateKey("minecraft", "chests/ruined_portal"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ruins/land_hot/large"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_desert_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ruins/land_hot/small"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_desert_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ruins/land_warm/large"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_plains_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ruins/land_warm/small"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_plains_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ruins/land_cold/large"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_taiga_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ruins/land_cold/small"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_taiga_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ruins/land_icy/large"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_snowy_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ruins/land_icy/small"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_snowy_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/ruins/nether"), StructureModdedLootImporter.generateKey("minecraft", "chests/bastion_other"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/shipwrecks/crimson/map"), StructureModdedLootImporter.generateKey("minecraft", "chests/shipwreck_map"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/shipwrecks/crimson/supply"), StructureModdedLootImporter.generateKey("minecraft", "chests/shipwreck_supply"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/shipwrecks/crimson/treasure"), StructureModdedLootImporter.generateKey("minecraft", "chests/shipwreck_treasure"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/shipwrecks/end/map"), StructureModdedLootImporter.generateKey("minecraft", "chests/shipwreck_map"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/shipwrecks/end/supply"), StructureModdedLootImporter.generateKey("minecraft", "chests/shipwreck_supply"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/shipwrecks/end/treasure"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/shipwrecks/warped/map"), StructureModdedLootImporter.generateKey("minecraft", "chests/shipwreck_map"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/shipwrecks/warped/supply"), StructureModdedLootImporter.generateKey("minecraft", "chests/shipwreck_supply"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/shipwrecks/warped/treasure"), StructureModdedLootImporter.generateKey("minecraft", "chests/shipwreck_treasure"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/shipwrecks/nether_bricks/treasure"), StructureModdedLootImporter.generateKey("minecraft", "chests/shipwreck_treasure"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "shulker_boxes/strongholds/end_storage_room"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "shulker_boxes/strongholds/end_hallway"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "shulker_boxes/strongholds/end_library"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/strongholds/nether_storage_room"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_crossing"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/strongholds/nether_hallway"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_corridor"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/strongholds/nether_library"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_library"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/temples/basalt"), StructureModdedLootImporter.generateKey("minecraft", "chests/nether_bridge"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/temples/crimson"), StructureModdedLootImporter.generateKey("minecraft", "chests/nether_bridge"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/temples/soul"), StructureModdedLootImporter.generateKey("minecraft", "chests/nether_bridge"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/temples/warped"), StructureModdedLootImporter.generateKey("minecraft", "chests/nether_bridge"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/temples/wasteland"), StructureModdedLootImporter.generateKey("minecraft", "chests/nether_bridge"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/temples/taiga"), StructureModdedLootImporter.generateKey("minecraft", "chests/jungle_temple"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/temples/ocean"), StructureModdedLootImporter.generateKey("minecraft", "chests/jungle_temple"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "trapped_chests/temples/warped"), StructureModdedLootImporter.generateKey("minecraft", "chests/nether_bridge"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "dispensers/temples/basalt"), StructureModdedLootImporter.generateKey("minecraft", "chests/jungle_temple_dispenser"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "dispensers/temples/crimson"), StructureModdedLootImporter.generateKey("minecraft", "chests/jungle_temple_dispenser"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "dispensers/temples/soul"), StructureModdedLootImporter.generateKey("minecraft", "chests/jungle_temple_dispenser"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "dispensers/temples/warped"), StructureModdedLootImporter.generateKey("minecraft", "chests/jungle_temple_dispenser"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "dispensers/temples/wasteland"), StructureModdedLootImporter.generateKey("minecraft", "chests/jungle_temple_dispenser"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "dispensers/temples/taiga"), StructureModdedLootImporter.generateKey("minecraft", "chests/jungle_temple_dispenser"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/badlands_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_desert_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/bamboo_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_savanna_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/birch_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_plains_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/cherry_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_plains_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/dark_forest_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_plains_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/giant_taiga_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_taiga_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/jungle_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_savanna_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/mountains_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_snowy_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/mushroom_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_plains_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/oak_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_plains_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/ocean_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_plains_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/ocean_cartographer"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_cartographer"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/swamp_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_plains_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/crimson_cartographer"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_cartographer"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/crimson_fisher"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_fisher"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/crimson_tannery"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_tannery"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/crimson_weaponsmith"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_weaponsmith"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/crimson_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_desert_house"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/warped_cartographer"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_cartographer"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/warped_fisher"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_fisher"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/warped_tannery"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_tannery"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/warped_weaponsmith"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_weaponsmith"));
        tableMap.put(StructureModdedLootImporter.generateKey("repurposed_structures", "chests/villages/warped_house"), StructureModdedLootImporter.generateKey("minecraft", "chests/village/village_desert_house"));
        if (PlatformHooks.isModLoaded("betterstrongholds")) {
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/end/armoury"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/end/common"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/end/crypt"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/end/grand_library"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/end/library_md"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/end/mess"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/end/prison_lg"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/end/trap"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/end/treasure"), StructureModdedLootImporter.generateKey("minecraft", "chests/end_city_treasure"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/nether/common"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_crossing"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/nether/mess"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_crossing"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/nether/armoury"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_corridor"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/nether/crypt"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_corridor"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/nether/prison_lg"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_corridor"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/nether/trap"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_corridor"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/nether/treasure"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_corridor"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/nether/grand_library"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_library"));
            tableMap.put(StructureModdedLootImporter.generateKey("betterstrongholds", "chests/nether/library_md"), StructureModdedLootImporter.generateKey("minecraft", "chests/stronghold_library"));
        }
        return tableMap;
    }

    public static boolean isInBlacklist(ResourceKey<LootTable> lootTableID) {
        if (BLACKLISTED_LOOTTABLES == null) {
            String cleanedBlacklist = RSMainModdedLootConfig.blacklistedRSLoottablesFromImportingModdedItems.trim();
            BLACKLISTED_LOOTTABLES = cleanedBlacklist.isEmpty() ? new HashSet<ResourceKey<LootTable>>() : Arrays.stream(cleanedBlacklist.split(",")).map(entry -> ResourceLocation.tryParse((String)entry.trim())).filter(Objects::nonNull).map(entry -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)entry)).collect(Collectors.toSet());
        }
        return BLACKLISTED_LOOTTABLES.contains(lootTableID);
    }

    public static void checkLoottables(MinecraftServer minecraftServer) {
        boolean invalidLootTableFound = false;
        for (Map.Entry<ResourceKey<LootTable>, ResourceKey<LootTable>> entry : TABLE_IMPORTS.entrySet()) {
            if (entry.getKey().location().getNamespace().equals("betterstrongholds") || !GeneralUtils.isInvalidLootTableFound(minecraftServer, entry)) continue;
            invalidLootTableFound = true;
        }
        if (GeneralUtils.isMissingLootImporting(minecraftServer, TABLE_IMPORTS.keySet())) {
            invalidLootTableFound = true;
        }
        if (invalidLootTableFound) {
            RepurposedStructures.LOGGER.error("Unknown import/target loot tables found for Repurposed Structures. See above logs and report to TelepathicGrunt please.");
        }
    }

    public static ResourceKey<LootTable> generateKey(String namespace, String path) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }
}

