/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.neoforge.lootmanager;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.configs.neoforge.RSModdedLootConfig;
import com.telepathicgrunt.repurposedstructures.misc.lootmanager.StructureModdedLootImporter;
import com.telepathicgrunt.repurposedstructures.misc.neoforge.lootmanager.EndRemasteredDedicatedLootApplier;
import com.telepathicgrunt.repurposedstructures.mixins.resources.LootContextAccessor;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class StructureModdedLootImporterApplier
extends LootModifier {
    public static final Supplier<MapCodec<StructureModdedLootImporterApplier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> StructureModdedLootImporterApplier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, StructureModdedLootImporterApplier::new)));

    public StructureModdedLootImporterApplier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)RSModdedLootConfig.importModdedItems.get()).booleanValue()) {
            return generatedLoot;
        }
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)context.getQueriedLootTableId());
        if (StructureModdedLootImporter.isInBlacklist((ResourceKey<LootTable>)key)) {
            return generatedLoot;
        }
        ResourceKey<LootTable> tableToImportLoot = StructureModdedLootImporter.TABLE_IMPORTS.get(key);
        if (tableToImportLoot == null) {
            return generatedLoot;
        }
        LootContext newContext = StructureModdedLootImporterApplier.copyLootContextWithNewQueryID(context, tableToImportLoot.location());
        Optional optionalLootTableReference = context.getResolver().get(tableToImportLoot);
        ObjectArrayList newlyGeneratedLoot = optionalLootTableReference.isPresent() ? ((LootTable)((Holder.Reference)optionalLootTableReference.get()).value()).getRandomItems(((LootContextAccessor)newContext).getParams()) : new ArrayList();
        newlyGeneratedLoot.removeIf(itemStack -> BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getNamespace().equals("minecraft"));
        EndRemasteredDedicatedLootApplier.handleDedicatedModCompat((List<ItemStack>)newlyGeneratedLoot, context);
        generatedLoot.addAll((Collection)newlyGeneratedLoot);
        return generatedLoot;
    }

    protected static LootContext copyLootContextWithNewQueryID(LootContext oldLootContext, ResourceLocation newQueryID) {
        LootContext.Builder newContextBuilder = new LootContext.Builder(((LootContextAccessor)oldLootContext).getParams()).withOptionalRandomSeed(oldLootContext.getRandom().nextLong()).withQueriedLootTableId(newQueryID);
        return newContextBuilder.create(Optional.empty());
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

