/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.mobspawners.MobSpawnerManager;
import com.telepathicgrunt.repurposedstructures.mixins.structures.TemplateAccessor;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.features.configs.NbtDungeonConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class NbtDungeon
extends Feature<NbtDungeonConfig> {
    public NbtDungeon(Codec<NbtDungeonConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<NbtDungeonConfig> context) {
        BlockPos position = context.origin().above(-1);
        ResourceLocation nbtRL = (ResourceLocation)GeneralUtils.getRandomEntry(((NbtDungeonConfig)context.config()).nbtResourcelocationsAndWeights, context.random());
        StructureTemplateManager structureTemplateManager = context.level().getLevel().getStructureManager();
        Optional template = structureTemplateManager.get(nbtRL);
        if (template.isEmpty()) {
            RepurposedStructures.LOGGER.error("Identifier to the specified nbt file was not found! : {}", (Object)nbtRL);
            return false;
        }
        Rotation rotation = Rotation.getRandom((RandomSource)context.random());
        BlockPos size = new BlockPos(((StructureTemplate)template.get()).getSize());
        BlockPos halfLengths = new BlockPos(size.getX() / 2, size.getY() / 2, size.getZ() / 2);
        BlockPos fullLengths = new BlockPos(Math.abs(size.rotate(rotation).getX()), Math.abs(size.rotate(rotation).getY()), Math.abs(size.rotate(rotation).getZ()));
        BlockPos halfLengthsRotated = new BlockPos(fullLengths.getX() / 2, fullLengths.getY() / 2, fullLengths.getZ() / 2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)position);
        ChunkAccess cachedChunk = context.level().getChunk((BlockPos)mutable);
        int xMin = -halfLengthsRotated.getX();
        int xMax = halfLengthsRotated.getX();
        int zMin = -halfLengthsRotated.getZ();
        int zMax = halfLengthsRotated.getZ();
        int wallOpenings = 0;
        int ceilingOpenings = 0;
        int ceiling = size.getY();
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                for (int y = 0; y <= ceiling; ++y) {
                    mutable.set((Vec3i)position).move(x, y, z);
                    if (mutable.getX() >> 4 != cachedChunk.getPos().x || mutable.getZ() >> 4 != cachedChunk.getPos().z) {
                        cachedChunk = context.level().getChunk((BlockPos)mutable);
                    }
                    BlockState state = cachedChunk.getBlockState((BlockPos)mutable);
                    if (((NbtDungeonConfig)context.config()).airRequirementIsNowWater ? state.isAir() || state.getFluidState().is(FluidTags.LAVA) : !state.getFluidState().isEmpty()) {
                        return false;
                    }
                    if (!GeneralUtils.isFullCube(state)) {
                        if (y == 0 && !state.isSolid()) {
                            return false;
                        }
                        if (state.is(BlockTags.LEAVES)) continue;
                        if (y == ceiling) {
                            ++ceilingOpenings;
                        }
                    }
                    if ((x == xMin || x == xMax || z == zMin || z == zMax) && y == 1 && this.isValidNonSolidBlock((NbtDungeonConfig)context.config(), state)) {
                        BlockState aboveState = cachedChunk.getBlockState((BlockPos)mutable);
                        if (((NbtDungeonConfig)context.config()).airRequirementIsNowWater ? !aboveState.getFluidState().isEmpty() : aboveState.isAir()) {
                            ++wallOpenings;
                        }
                    }
                    if (wallOpenings <= ((NbtDungeonConfig)context.config()).maxAirSpace && ceilingOpenings <= ((NbtDungeonConfig)context.config()).maxAirSpace) continue;
                    return false;
                }
            }
        }
        if (wallOpenings >= ((NbtDungeonConfig)context.config()).minAirSpace) {
            position = position.above(((NbtDungeonConfig)context.config()).structureYOffset);
            Registry processorListRegistry = context.level().getLevel().getServer().registryAccess().lookupOrThrow(Registries.PROCESSOR_LIST);
            ResourceKey emptyKey = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty"));
            StructurePlaceSettings placementsettings = new StructurePlaceSettings().setRotation(rotation).setRotationPivot(halfLengths).setIgnoreEntities(false);
            Optional processor = processorListRegistry.getOptional(((NbtDungeonConfig)context.config()).processor);
            processor.orElse((StructureProcessorList)processorListRegistry.getValue(emptyKey)).list().forEach(arg_0 -> ((StructurePlaceSettings)placementsettings).addProcessor(arg_0));
            BlockPos.MutableBlockPos finalPos = mutable.set((Vec3i)position).move(-halfLengths.getX(), 0, -halfLengths.getZ());
            ((StructureTemplate)template.get()).placeInWorld((ServerLevelAccessor)context.level(), (BlockPos)finalPos, (BlockPos)finalPos, placementsettings, context.random(), 2);
            placementsettings.clearProcessors();
            Optional postProcessor = processorListRegistry.getOptional(((NbtDungeonConfig)context.config()).processor);
            postProcessor.orElse((StructureProcessorList)processorListRegistry.getValue(emptyKey)).list().forEach(arg_0 -> ((StructurePlaceSettings)placementsettings).addProcessor(arg_0));
            List list = placementsettings.getRandomPalette(((TemplateAccessor)template.get()).repurposedstructures_getPalettes(), (BlockPos)mutable).blocks();
            StructureTemplate.processBlockInfos((ServerLevelAccessor)context.level(), (BlockPos)mutable, (BlockPos)mutable, (StructurePlaceSettings)placementsettings, (List)list);
            this.spawnLootBlocks(context.level(), context.random(), position, (NbtDungeonConfig)context.config(), fullLengths, halfLengthsRotated, mutable);
            return true;
        }
        return false;
    }

    private boolean isValidNonSolidBlock(NbtDungeonConfig config, BlockState state) {
        if (config.airRequirementIsNowWater) {
            return !state.getFluidState().isEmpty();
        }
        return state.isAir();
    }

    private void SolidifyBlock(WorldGenLevel world, BlockPos pos) {
        BlockState blockBelow = world.getBlockState(pos);
        if (blockBelow.hasProperty((Property)SlabBlock.TYPE)) {
            world.setBlock(pos, (BlockState)blockBelow.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE), 3);
        }
    }

    private void spawnLootBlocks(WorldGenLevel world, RandomSource random, BlockPos position, NbtDungeonConfig config, BlockPos fullLengths, BlockPos halfLengths, BlockPos.MutableBlockPos mutable) {
        boolean isPlacingChestLikeBlock = config.lootBlock.defaultBlockState().getBlock() instanceof ChestBlock;
        int currentChestAttempt = 0;
        while (currentChestAttempt < config.maxNumOfChests) {
            boolean addedChestThisAttempt = false;
            for (int currentChestPosAttempt = 0; currentChestPosAttempt < fullLengths.getX() + fullLengths.getZ() + halfLengths.getY(); ++currentChestPosAttempt) {
                BlockState belowState;
                if (config.chanceOfSpawningLootBlockAtSpot.isPresent() && random.nextFloat() >= config.chanceOfSpawningLootBlockAtSpot.get().floatValue()) continue;
                mutable.set((Vec3i)position).move(random.nextInt(Math.max(fullLengths.getX() - 2, 1)) - halfLengths.getX() + 1, random.nextInt(Math.max(fullLengths.getY() - 1, 1)), random.nextInt(Math.max(fullLengths.getZ() - 2, 1)) - halfLengths.getZ() + 1);
                BlockState currentBlock = world.getBlockState((BlockPos)mutable);
                if (!this.isValidNonSolidBlock(config, currentBlock) || !(belowState = world.getBlockState((BlockPos)mutable.move(Direction.DOWN))).isFaceSturdy((BlockGetter)world, (BlockPos)mutable, Direction.UP) || belowState.getBlock() == config.lootBlock) continue;
                mutable.move(Direction.UP);
                boolean isOnWall = false;
                ResourceKey lootTableResourceKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)config.chestResourcelocation);
                for (Direction neighborDirection : Direction.Plane.HORIZONTAL) {
                    mutable.move(neighborDirection);
                    BlockState neighboringState = world.getBlockState((BlockPos)mutable);
                    mutable.move(neighborDirection.getOpposite());
                    if (isPlacingChestLikeBlock && neighboringState.getBlock() instanceof ChestBlock) {
                        boolean chestTyping;
                        if (neighboringState.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) continue;
                        BlockState currentStateForChest = GeneralUtils.orientateChest((ServerLevelAccessor)world, (BlockPos)mutable, config.lootBlock.defaultBlockState());
                        Direction currentDirection = (Direction)currentStateForChest.getValue((Property)HorizontalDirectionalBlock.FACING);
                        if (neighborDirection.getAxis() == currentDirection.getAxis()) {
                            currentDirection = currentDirection.getClockWise();
                            BlockPos wallCheckPos = mutable.relative(currentDirection);
                            BlockPos wallCheckPos2 = wallCheckPos.relative(neighborDirection);
                            BlockState blockState = world.getBlockState(wallCheckPos);
                            BlockState blockState2 = world.getBlockState(wallCheckPos2);
                            if (blockState.isSolid() && !(blockState.getBlock() instanceof SpawnerBlock) || blockState2.isSolid() && !(blockState2.getBlock() instanceof SpawnerBlock)) {
                                currentDirection = currentDirection.getOpposite();
                            }
                        }
                        boolean bl = chestTyping = neighborDirection.getAxisDirection() == currentDirection.getAxisDirection();
                        if (neighborDirection.getAxis() == Direction.Axis.Z) {
                            chestTyping = !chestTyping;
                        }
                        world.setBlock((BlockPos)mutable, (BlockState)((BlockState)((BlockState)config.lootBlock.defaultBlockState().setValue((Property)ChestBlock.WATERLOGGED, (Comparable)Boolean.valueOf(currentBlock.getFluidState().is(FluidTags.WATER)))).setValue((Property)ChestBlock.FACING, (Comparable)currentDirection)).setValue((Property)ChestBlock.TYPE, (Comparable)(chestTyping ? ChestType.RIGHT : ChestType.LEFT)), 2);
                        RandomizableContainer.setBlockEntityLootTable((BlockGetter)world, (RandomSource)random, (BlockPos)mutable, (ResourceKey)lootTableResourceKey);
                        world.setBlock((BlockPos)mutable.move(neighborDirection), (BlockState)((BlockState)neighboringState.setValue((Property)ChestBlock.FACING, (Comparable)currentDirection)).setValue((Property)ChestBlock.TYPE, (Comparable)(chestTyping ? ChestType.LEFT : ChestType.RIGHT)), 2);
                        RandomizableContainer.setBlockEntityLootTable((BlockGetter)world, (RandomSource)random, (BlockPos)mutable, (ResourceKey)lootTableResourceKey);
                        this.SolidifyBlock(world, mutable.below());
                        isOnWall = false;
                        addedChestThisAttempt = true;
                        if (++currentChestAttempt != config.maxNumOfChests) break;
                        return;
                    }
                    if (!GeneralUtils.isFullCube(neighboringState) || neighboringState.getBlock() instanceof SpawnerBlock) continue;
                    isOnWall = true;
                }
                if (!isOnWall) continue;
                BlockState lootBlock = config.lootBlock.defaultBlockState();
                if (lootBlock.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    lootBlock.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(currentBlock.getFluidState().is(FluidTags.WATER)));
                }
                if (lootBlock.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    lootBlock = GeneralUtils.orientateChest((ServerLevelAccessor)world, (BlockPos)mutable, lootBlock);
                }
                world.setBlock((BlockPos)mutable, lootBlock, 2);
                ++currentChestAttempt;
                addedChestThisAttempt = true;
                RandomizableContainer.setBlockEntityLootTable((BlockGetter)world, (RandomSource)random, (BlockPos)mutable, (ResourceKey)lootTableResourceKey);
                mutable.move(Direction.DOWN);
                if (lootBlock.getBlock() == Blocks.SHULKER_BOX && world.getBlockEntity((BlockPos)mutable) == null) {
                    EntityType<?> entity = MobSpawnerManager.MOB_SPAWNER_MANAGER.getSpawnerMob(config.rsSpawnerResourcelocation, random);
                    if (entity == null) break;
                    world.setBlock((BlockPos)mutable, Blocks.SPAWNER.defaultBlockState(), 2);
                    BlockEntity blockEntity = world.getBlockEntity((BlockPos)mutable);
                    if (!(blockEntity instanceof SpawnerBlockEntity)) break;
                    SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                    spawnerBlockEntity.getSpawner().setEntityId(entity, null, random, (BlockPos)mutable);
                    break;
                }
                this.SolidifyBlock(world, (BlockPos)mutable);
                break;
            }
            if (addedChestThisAttempt) continue;
            ++currentChestAttempt;
        }
    }
}

