/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.codecs.YRangeAllowance;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import org.joml.Vector3f;

public class MineshaftEndStructure
extends Structure {
    public static final MapCodec<MineshaftEndStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MineshaftEndStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)YRangeAllowance.CODEC.optionalFieldOf("y_allowance").forGetter(structure -> structure.yAllowance), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)ResourceLocation.CODEC.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("min_island_thickness_allowed").forGetter(config -> config.minIslandThickness), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)JigsawStructure.DEFAULT_LIQUID_SETTINGS).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, MineshaftEndStructure::new));
    public final Holder<StructureTemplatePool> startPool;
    public final int size;
    public final Optional<YRangeAllowance> yAllowance;
    public final HeightProvider startHeight;
    public final Optional<Integer> biomeRadius;
    public final HashSet<ResourceLocation> poolsThatIgnoreBoundaries;
    public final Optional<Integer> maxDistanceFromCenter;
    public final Optional<Integer> minIslandThickness;
    public final LiquidSettings liquidSettings;

    public MineshaftEndStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, Optional<YRangeAllowance> yAllowance, HeightProvider startHeight, Optional<Integer> biomeRadius, HashSet<ResourceLocation> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<Integer> minIslandThickness, LiquidSettings liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.size = size;
        this.yAllowance = yAllowance;
        this.startHeight = startHeight;
        this.biomeRadius = biomeRadius;
        this.poolsThatIgnoreBoundaries = poolsThatIgnoreBoundaries;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.minIslandThickness = minIslandThickness;
        this.liquidSettings = liquidSettings;
        if (yAllowance.isPresent() && yAllowance.get().maxYAllowed.isPresent() && yAllowance.get().minYAllowed.isPresent() && yAllowance.get().maxYAllowed.get() < yAllowance.get().minYAllowed.get()) {
            throw new RuntimeException("    Repurposed Structures: maxYAllowed cannot be less than minYAllowed.\n    Please correct this error as there's no way to spawn this structure properly\n        Structure pool of problematic structure: %s\n".formatted(startPool.value()));
        }
    }

    protected boolean extraSpawningChecks(Structure.GenerationContext context, BlockPos blockPos, BlockPos.MutableBlockPos islandTopBottomThickness) {
        if (this.minIslandThickness.isEmpty()) {
            return true;
        }
        int xPos = blockPos.getX();
        int zPos = blockPos.getZ();
        int landHeight = Integer.MAX_VALUE;
        for (int i = 2; i >= 1; --i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vector3f offsetPos = direction.step();
                offsetPos.mul(30.0f * (float)i);
                landHeight = MineshaftEndStructure.getHeightAt(context, xPos + (int)offsetPos.x(), zPos + (int)offsetPos.z(), landHeight);
                if (landHeight - context.chunkGenerator().getMinY() >= this.minIslandThickness.get()) continue;
                return false;
            }
        }
        MineshaftEndStructure.analyzeLand(context, xPos, zPos, islandTopBottomThickness, context.heightAccessor());
        return islandTopBottomThickness.getZ() >= this.minIslandThickness.get();
    }

    private static int getHeightAt(Structure.GenerationContext context, int xPos, int zPos, int landHeight) {
        landHeight = Math.min(landHeight, GeneralUtils.getCachedFreeHeight(context.chunkGenerator(), xPos, zPos, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()) - 1);
        return landHeight;
    }

    private static void analyzeLand(Structure.GenerationContext context, int xPos, int zPos, BlockPos.MutableBlockPos islandTopBottomThickness, LevelHeightAccessor heightLimitView) {
        NoiseColumn columnOfBlocks = context.chunkGenerator().getBaseColumn(xPos, zPos, heightLimitView, context.randomState());
        int minY = context.chunkGenerator().getMinY();
        int rangeHeight = GeneralUtils.getMaxTerrainLimit(context.chunkGenerator());
        int maxY = minY + rangeHeight;
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(xPos, maxY, zPos);
        boolean isInIsland = false;
        while (currentPos.getY() >= minY) {
            BlockState state = columnOfBlocks.getBlock(currentPos.getY());
            if (!state.isAir() && !isInIsland) {
                isInIsland = true;
                int topIslandY = Math.min(currentPos.getY(), islandTopBottomThickness.getX());
                islandTopBottomThickness.set(topIslandY, islandTopBottomThickness.getY(), islandTopBottomThickness.getZ());
            } else if (state.isAir() && isInIsland || currentPos.getY() == minY) {
                int bottomIslandY = Math.max(currentPos.getY(), islandTopBottomThickness.getY());
                islandTopBottomThickness.set(islandTopBottomThickness.getX(), bottomIslandY, islandTopBottomThickness.getZ());
                break;
            }
            currentPos.move(Direction.DOWN);
        }
        if (!isInIsland) {
            islandTopBottomThickness.set(0, 0, 0);
        }
        int thickness = islandTopBottomThickness.getX() - islandTopBottomThickness.getY();
        islandTopBottomThickness.set(islandTopBottomThickness.getX(), islandTopBottomThickness.getY(), thickness);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        BlockPos.MutableBlockPos islandTopBottomThickness;
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(context.chunkPos().getMinBlockX(), 0, context.chunkPos().getMinBlockZ());
        if (!this.extraSpawningChecks(context, (BlockPos)blockpos, islandTopBottomThickness = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE))) {
            return Optional.empty();
        }
        int maxY = 53;
        int minY = 15;
        if (this.minIslandThickness.isEmpty()) {
            blockpos.move(Direction.UP, 35);
        } else {
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.setLargeFeatureSeed(context.seed(), context.chunkPos().x, context.chunkPos().z);
            int structureStartHeight = random.nextInt(Math.max(islandTopBottomThickness.getZ() - this.minIslandThickness.get() + 1, 1)) + islandTopBottomThickness.getY() + this.minIslandThickness.get() / 2;
            blockpos.move(Direction.UP, structureStartHeight);
            maxY = islandTopBottomThickness.getX() - 10;
            minY = islandTopBottomThickness.getY();
            if (maxY - minY <= 10) {
                minY = maxY - 10;
            }
        }
        int finalMaxY = maxY;
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, this.startPool, this.size, context.registryAccess().lookupOrThrow(Registries.STRUCTURE).getKey((Object)this), (BlockPos)blockpos, false, Optional.empty(), maxY, minY, this.poolsThatIgnoreBoundaries, this.maxDistanceFromCenter, Optional.empty(), this.liquidSettings, (structurePiecesBuilder, pieces) -> {
            Optional<PoolElementStructurePiece> highestPiece = pieces.stream().max(Comparator.comparingInt(p -> p.getBoundingBox().maxY()));
            int topY = highestPiece.map(poolElementStructurePiece -> poolElementStructurePiece.getBoundingBox().maxY()).orElseGet(() -> ((BlockPos.MutableBlockPos)blockpos).getY());
            if (topY > finalMaxY) {
                int newOffset = finalMaxY - topY;
                for (StructurePiece piece : pieces) {
                    GeneralUtils.movePieceProperly(piece, 0, newOffset, 0);
                }
            }
        });
    }

    public StructureType<?> type() {
        return RSStructures.MINESHAFT_END.get();
    }
}

