/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.teamresourceful.resourcefulconfig.api.annotations.ConfigOption;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigButton;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigObjectEntry;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigValueEntry;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryData;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryType;
import com.teamresourceful.resourcefulconfig.api.types.options.Option;
import com.teamresourceful.resourcefulconfig.client.UIConstants;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.CustomButton;
import com.teamresourceful.resourcefulconfig.client.components.base.SpriteButton;
import com.teamresourceful.resourcefulconfig.client.components.options.OptionItem;
import com.teamresourceful.resourcefulconfig.client.components.options.OptionsListWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.SeparatorItem;
import com.teamresourceful.resourcefulconfig.client.components.options.range.DecimalOptionRange;
import com.teamresourceful.resourcefulconfig.client.components.options.range.OptionRange;
import com.teamresourceful.resourcefulconfig.client.components.options.range.WholeOptionRange;
import com.teamresourceful.resourcefulconfig.client.components.options.types.BooleanOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.ColorOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.DraggableListOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.DropdownWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.KeybindOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.MultilineStringOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.NumberOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.ObjectOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.RangeOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.ResetableWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.SelectWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.StringOptionWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;

public final class Options {
    public static void populateOptions(OptionsListWidget widget, Map<String, ResourcefulConfigEntry> entries, List<ResourcefulConfigButton> buttons) {
        ListMultimap buttonsBefore = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
        ListMultimap buttonsAfter = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
        buttons.forEach(arg_0 -> Options.lambda$populateOptions$0((Multimap)buttonsBefore, (Multimap)buttonsAfter, arg_0));
        buttonsBefore.get((Object)"").forEach(button -> Options.addButton(widget, button));
        for (Map.Entry<String, ResourcefulConfigEntry> value : entries.entrySet()) {
            EntryData options = value.getValue().options();
            if (options.hasOption(Option.HIDDEN)) continue;
            if (options.hasOption(Option.SEPARATOR)) {
                ConfigOption.Separator separator = options.getOption(Option.SEPARATOR);
                widget.add(new SeparatorItem((Component)Component.literal((String)separator.value()), (Component)Component.literal((String)separator.description())));
            }
            buttonsBefore.get((Object)value.getKey()).forEach(button -> Options.addButton(widget, button));
            ResourcefulConfigEntry resourcefulConfigEntry = value.getValue();
            if (resourcefulConfigEntry instanceof ResourcefulConfigValueEntry) {
                ResourcefulConfigValueEntry entry = (ResourcefulConfigValueEntry)resourcefulConfigEntry;
                Options.populateValueEntry(widget, entry);
            } else {
                resourcefulConfigEntry = value.getValue();
                if (resourcefulConfigEntry instanceof ResourcefulConfigObjectEntry) {
                    ResourcefulConfigObjectEntry entry = (ResourcefulConfigObjectEntry)resourcefulConfigEntry;
                    widget.add(new OptionItem(entry, List.of(new ObjectOptionWidget(entry))));
                }
            }
            buttonsAfter.get((Object)value.getKey()).forEach(button -> Options.addButton(widget, button));
        }
        buttonsAfter.get((Object)"").forEach(button -> Options.addButton(widget, button));
    }

    private static void addButton(OptionsListWidget list, ResourcefulConfigButton button) {
        list.add(new OptionItem((Component)Component.translatable((String)button.title()), (Component)Component.translatable((String)button.description()), List.of(new CustomButton(96, 12, (Component)Component.translatable((String)button.text()), button::invoke))));
    }

    private static void populateValueEntry(OptionsListWidget list, ResourcefulConfigValueEntry entry) {
        EntryData data = entry.options();
        ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        switch (entry.type()) {
            case BOOLEAN: {
                widgets.add(new BooleanOptionWidget(entry::getBoolean, entry::setBoolean));
                break;
            }
            case STRING: {
                if (data.hasOption(Option.MULTILINE)) {
                    widgets.add(new MultilineStringOptionWidget(entry::getString, entry::setString));
                    break;
                }
                if (entry.isArray()) {
                    widgets.add(new MultilineStringOptionWidget(() -> String.join((CharSequence)"\n", (String[])entry.getArray()), s -> entry.setArray(s.split("\n"))));
                    break;
                }
                widgets.add((AbstractWidget)new StringOptionWidget(entry::getString, entry::setString));
                break;
            }
            case ENUM: {
                if (entry.isArray()) {
                    if (data.hasOption(Option.DRAGGABLE)) {
                        widgets.add(DraggableListOptionWidget.of(entry, data));
                        break;
                    }
                    widgets.add(new SelectWidget((Component)data.getOrDefaultOption(Option.SELECT, Component.literal((String)"Select")), (Enum[])entry.objectType().getEnumConstants(), () -> (Enum[])entry.getArray(), entry::setArray));
                    break;
                }
                widgets.add(new DropdownWidget((Enum[])entry.objectType().getEnumConstants(), entry::getEnum, entry::setEnum));
                break;
            }
            case INTEGER: {
                Record range = WholeOptionRange.of(entry);
                if (range.hasRange() && data.hasOption(Option.SLIDER)) {
                    widgets.add(new RangeOptionWidget((OptionRange)((Object)range)));
                    break;
                }
                if (data.hasOption(Option.COLOR)) {
                    ConfigOption.Color color = data.getOption(Option.COLOR);
                    widgets.add(new ColorOptionWidget(color.presets(), color.alpha(), () -> color.alpha() ? entry.getInt() : entry.getInt() | 0xFF000000, value -> {
                        value = color.alpha() ? value : value & 0xFFFFFF;
                        entry.setInt(value);
                    }));
                    widgets.add((AbstractWidget)new StringOptionWidget(() -> "#" + String.format("%06X", entry.getInt()), s -> {
                        try {
                            if (((String)s).length() == 8 && !color.alpha()) {
                                s = ((String)s).substring(2);
                            }
                            if (((String)s).length() == 3) {
                                s = "" + ((String)s).charAt(0) + ((String)s).charAt(0) + ((String)s).charAt(1) + ((String)s).charAt(1) + ((String)s).charAt(2) + ((String)s).charAt(2);
                            }
                            entry.setInt(Long.decode((String)s).intValue());
                            return true;
                        }
                        catch (NumberFormatException e) {
                            return false;
                        }
                    }, false));
                    break;
                }
                if (data.hasOption(Option.KEYBIND)) {
                    widgets.add(new KeybindOptionWidget(entry::getInt, entry::setInt));
                    break;
                }
                widgets.add((AbstractWidget)new NumberOptionWidget<Integer>(entry::getInt, entry::setInt, Options.parseNumber(data, Integer::parseInt), NumberOptionWidget.INTEGER_FILTER));
                break;
            }
            case BYTE: 
            case SHORT: 
            case LONG: {
                Record range = WholeOptionRange.of(entry);
                if (range.hasRange() && data.hasOption(Option.SLIDER)) {
                    widgets.add(new RangeOptionWidget((OptionRange)((Object)range)));
                    break;
                }
                widgets.add((AbstractWidget)(switch (entry.type()) {
                    case EntryType.BYTE -> new NumberOptionWidget<Byte>(entry::getByte, entry::setByte, Options.parseNumber(data, Byte::parseByte), NumberOptionWidget.INTEGER_FILTER);
                    case EntryType.SHORT -> new NumberOptionWidget<Short>(entry::getShort, entry::setShort, Options.parseNumber(data, Short::parseShort), NumberOptionWidget.INTEGER_FILTER);
                    case EntryType.LONG -> new NumberOptionWidget<Long>(entry::getLong, entry::setLong, Options.parseNumber(data, Long::parseLong), NumberOptionWidget.INTEGER_FILTER);
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)entry.type()));
                }));
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                Record range = DecimalOptionRange.of(entry);
                if (range.hasRange() && data.hasOption(Option.SLIDER)) {
                    widgets.add(new RangeOptionWidget((OptionRange)((Object)range)));
                    break;
                }
                widgets.add((AbstractWidget)(switch (entry.type()) {
                    case EntryType.FLOAT -> new NumberOptionWidget<Float>(entry::getFloat, entry::setFloat, Float::parseFloat, NumberOptionWidget.DECIMAL_FILTER);
                    case EntryType.DOUBLE -> new NumberOptionWidget<Double>(entry::getDouble, entry::setDouble, Double::parseDouble, NumberOptionWidget.DECIMAL_FILTER);
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)entry.type()));
                }));
                break;
            }
            case OBJECT: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)entry.type()));
            }
        }
        SpriteButton reset = SpriteButton.builder(12, 12).padding(2).sprite(ModSprites.RESET).tooltip(UIConstants.RESET).onPress(Options.resetValue(entry, widgets)).build();
        widgets.add((AbstractWidget)reset);
        list.add(new OptionItem(entry, widgets));
    }

    private static Runnable resetValue(ResourcefulConfigEntry entry, List<AbstractWidget> widgets) {
        return () -> {
            entry.reset();
            for (AbstractWidget widget : widgets) {
                if (!(widget instanceof ResetableWidget)) continue;
                ResetableWidget resetable = (ResetableWidget)widget;
                resetable.reset();
            }
        };
    }

    private static <T extends Number> Function<String, T> parseNumber(EntryData options, Function<String, T> parser) {
        return s -> {
            Number value = (Number)parser.apply((String)s);
            if (options.hasOption(Option.RANGE)) {
                ConfigOption.Range range = options.getOption(Option.RANGE);
                if (value.doubleValue() < range.min()) {
                    throw new NumberFormatException();
                }
                if (value.doubleValue() > range.max()) {
                    throw new NumberFormatException();
                }
            }
            return value;
        };
    }

    private static /* synthetic */ void lambda$populateOptions$0(Multimap buttonsBefore, Multimap buttonsAfter, ResourcefulConfigButton button) {
        switch (button.position()) {
            case BEFORE: {
                buttonsBefore.put((Object)button.target(), (Object)button);
                break;
            }
            case AFTER: {
                buttonsAfter.put((Object)button.target(), (Object)button);
            }
        }
    }
}

