/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types;

import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigObjectEntry;
import com.teamresourceful.resourcefulconfig.api.types.info.Translatable;
import com.teamresourceful.resourcefulconfig.client.UIConstants;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.Options;
import com.teamresourceful.resourcefulconfig.client.components.options.OptionsListWidget;
import com.teamresourceful.resourcefulconfig.client.screens.base.ModalOverlay;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.FormattedText;

public class ObjectOptionWidget
extends BaseWidget {
    private static final int WIDTH = 100;
    private static final int SIZE = 12;
    private static final int SPACING = 4;
    private static final int PADDING = 2;
    private final ResourcefulConfigObjectEntry entry;

    public ObjectOptionWidget(ResourcefulConfigObjectEntry entry) {
        super(100, 16);
        this.entry = entry;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(RenderType::guiTextured, ModSprites.ofButton(this.isHovered()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int contentWidth = this.font.width((FormattedText)UIConstants.EDIT) + 4 + 12;
        graphics.blitSprite(RenderType::guiTextured, ModSprites.EDIT, this.getX() + (this.getWidth() - contentWidth) / 2, this.getY() + 2, 12, 12);
        int n = this.getX() + (this.getWidth() - contentWidth) / 2 + 12 + 4;
        int n2 = this.getY();
        int n3 = this.getHeight();
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, UIConstants.EDIT, n, n2 + (n3 - 9) / 2 + 1, -329226);
    }

    public void onClick(double mouseX, double mouseY) {
        new ObjectEditOverlay(this.entry).open();
    }

    private static class ObjectEditOverlay
    extends ModalOverlay {
        private final ResourcefulConfigObjectEntry entry;

        protected ObjectEditOverlay(ResourcefulConfigObjectEntry entry) {
            this.entry = entry;
            this.title = Translatable.toSpeifiedComponent(entry.instance(), UIConstants.EDIT_OBJECT);
        }

        @Override
        protected void init() {
            super.init();
            OptionsListWidget list = (OptionsListWidget)this.addRenderableWidget((GuiEventListener)new OptionsListWidget(this.contentWidth, this.contentHeight));
            list.setPosition(this.left, this.top);
            Options.populateOptions(list, this.entry.entries(), List.of());
        }

        @Override
        public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderBackground(graphics, mouseX, mouseY, partialTicks);
        }
    }
}

