/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.region;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.gl.arena.GlBufferArena;
import net.caffeinemc.mods.sodium.client.gl.arena.PendingUpload;
import net.caffeinemc.mods.sodium.client.gl.arena.staging.FallbackStagingBuffer;
import net.caffeinemc.mods.sodium.client.gl.arena.staging.MappedStagingBuffer;
import net.caffeinemc.mods.sodium.client.gl.arena.staging.StagingBuffer;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.BuilderTaskOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkSortOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import net.caffeinemc.mods.sodium.client.render.chunk.data.SectionRenderDataStorage;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class RenderRegionManager {
    private final Long2ReferenceOpenHashMap<RenderRegion> regions = new Long2ReferenceOpenHashMap();
    private final StagingBuffer stagingBuffer;

    public RenderRegionManager(CommandList commandList) {
        this.stagingBuffer = RenderRegionManager.createStagingBuffer(commandList);
    }

    public void update() {
        this.stagingBuffer.flip();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            ObjectIterator it = this.regions.values().iterator();
            while (it.hasNext()) {
                RenderRegion region = (RenderRegion)it.next();
                region.update(commandList);
                if (!region.isEmpty()) continue;
                region.delete(commandList);
                it.remove();
            }
        }
    }

    public void uploadResults(CommandList commandList, Collection<BuilderTaskOutput> results) {
        for (Reference2ReferenceMap.Entry entry : this.createMeshUploadQueues(results)) {
            this.uploadResults(commandList, (RenderRegion)entry.getKey(), (Collection)entry.getValue());
        }
    }

    private void uploadResults(CommandList commandList, RenderRegion region, Collection<BuilderTaskOutput> results) {
        ArrayList<PendingSectionMeshUpload> uploads = new ArrayList<PendingSectionMeshUpload>();
        ArrayList<PendingSectionIndexBufferUpload> indexUploads = new ArrayList<PendingSectionIndexBufferUpload>();
        for (BuilderTaskOutput result : results) {
            NativeBuffer buffer;
            ChunkSortOutput indexDataOutput;
            int renderSectionIndex = result.render.getSectionIndex();
            if (result.render.isDisposed()) {
                throw new IllegalStateException("Render section is disposed");
            }
            if (result instanceof ChunkBuildOutput) {
                ChunkBuildOutput chunkBuildOutput = (ChunkBuildOutput)result;
                for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
                    BuiltSectionMeshParts mesh;
                    SectionRenderDataStorage storage = region.getStorage(pass);
                    if (storage != null) {
                        storage.removeVertexData(renderSectionIndex);
                    }
                    if ((mesh = chunkBuildOutput.getMesh(pass)) == null) continue;
                    uploads.add(new PendingSectionMeshUpload(result.render, mesh, pass, new PendingUpload(mesh.getVertexData())));
                }
            }
            if (!(result instanceof ChunkSortOutput) || (indexDataOutput = (ChunkSortOutput)result).isReusingUploadedIndexData() || (buffer = indexDataOutput.getIndexBuffer()) == null) continue;
            indexUploads.add(new PendingSectionIndexBufferUpload(result.render, new PendingUpload(buffer)));
            SectionRenderDataStorage storage = region.getStorage(DefaultTerrainRenderPasses.TRANSLUCENT);
            if (storage == null) continue;
            storage.removeIndexData(renderSectionIndex);
        }
        ProfilerFiller profiler = Profiler.get();
        if (uploads.isEmpty() && indexUploads.isEmpty()) {
            return;
        }
        RenderRegion.DeviceResources resources = region.createResources(commandList);
        profiler.push("upload_vertices");
        if (!uploads.isEmpty()) {
            GlBufferArena arena = resources.getGeometryArena();
            boolean bufferChanged = arena.upload(commandList, uploads.stream().map(upload -> upload.vertexUpload));
            if (bufferChanged) {
                region.refreshTesselation(commandList);
            }
            for (PendingSectionMeshUpload upload2 : uploads) {
                SectionRenderDataStorage storage = region.createStorage(upload2.pass);
                storage.setVertexData(upload2.section.getSectionIndex(), upload2.vertexUpload.getResult(), upload2.meshData.getVertexCounts());
            }
        }
        profiler.popPush("upload_indices");
        if (!indexUploads.isEmpty()) {
            GlBufferArena arena = resources.getIndexArena();
            boolean bufferChanged = arena.upload(commandList, indexUploads.stream().map(upload -> upload.indexBufferUpload));
            if (bufferChanged) {
                region.refreshIndexedTesselation(commandList);
            }
            for (PendingSectionIndexBufferUpload upload3 : indexUploads) {
                SectionRenderDataStorage storage = region.createStorage(DefaultTerrainRenderPasses.TRANSLUCENT);
                storage.setIndexData(upload3.section.getSectionIndex(), upload3.indexBufferUpload.getResult());
            }
        }
        profiler.pop();
    }

    private Reference2ReferenceMap.FastEntrySet<RenderRegion, List<BuilderTaskOutput>> createMeshUploadQueues(Collection<BuilderTaskOutput> results) {
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        for (BuilderTaskOutput result : results) {
            List queue = (List)map.computeIfAbsent((Object)result.render.getRegion(), k -> new ArrayList());
            queue.add(result);
        }
        return map.reference2ReferenceEntrySet();
    }

    public void delete(CommandList commandList) {
        for (RenderRegion region : this.regions.values()) {
            region.delete(commandList);
        }
        this.regions.clear();
        this.stagingBuffer.delete(commandList);
    }

    public Collection<RenderRegion> getLoadedRegions() {
        return this.regions.values();
    }

    public StagingBuffer getStagingBuffer() {
        return this.stagingBuffer;
    }

    public RenderRegion createForChunk(int chunkX, int chunkY, int chunkZ) {
        return this.create(chunkX >> RenderRegion.REGION_WIDTH_SH, chunkY >> RenderRegion.REGION_HEIGHT_SH, chunkZ >> RenderRegion.REGION_LENGTH_SH);
    }

    @NotNull
    private RenderRegion create(int x, int y, int z) {
        long key = RenderRegion.key(x, y, z);
        RenderRegion instance = (RenderRegion)this.regions.get(key);
        if (instance == null) {
            instance = new RenderRegion(x, y, z, this.stagingBuffer);
            this.regions.put(key, (Object)instance);
        }
        return instance;
    }

    private static StagingBuffer createStagingBuffer(CommandList commandList) {
        if (SodiumClientMod.options().advanced.useAdvancedStagingBuffers && MappedStagingBuffer.isSupported(RenderDevice.INSTANCE)) {
            return new MappedStagingBuffer(commandList);
        }
        return new FallbackStagingBuffer(commandList);
    }

    private record PendingSectionMeshUpload(RenderSection section, BuiltSectionMeshParts meshData, TerrainRenderPass pass, PendingUpload vertexUpload) {
    }

    private record PendingSectionIndexBufferUpload(RenderSection section, PendingUpload indexBufferUpload) {
    }
}

