/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.immediate;

import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.InputStream;
import java.util.Objects;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorU8;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ColorVertex;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ShaderDefines;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sodium-CloudRenderer");
    private static final ShaderProgram CLOUDS_SHADER = new ShaderProgram(ResourceLocation.fromNamespaceAndPath((String)"sodium", (String)"clouds"), DefaultVertexFormat.POSITION_COLOR, ShaderDefines.builder().build());
    private static final ResourceLocation CLOUDS_TEXTURE_ID = ResourceLocation.withDefaultNamespace((String)"textures/environment/clouds.png");
    private static final float CLOUD_HEIGHT = 4.0f;
    private static final float CLOUD_WIDTH = 12.0f;
    private static final int FACE_MASK_NEG_Y = 1;
    private static final int FACE_MASK_POS_Y = 2;
    private static final int FACE_MASK_NEG_X = 4;
    private static final int FACE_MASK_POS_X = 8;
    private static final int FACE_MASK_NEG_Z = 16;
    private static final int FACE_MASK_POS_Z = 32;
    private static final int BRIGHTNESS_POS_Y = ColorU8.normalizedFloatToByte(1.0f);
    private static final int BRIGHTNESS_NEG_Y = ColorU8.normalizedFloatToByte(0.7f);
    private static final int BRIGHTNESS_X_AXIS = ColorU8.normalizedFloatToByte(0.9f);
    private static final int BRIGHTNESS_Z_AXIS = ColorU8.normalizedFloatToByte(0.8f);
    @Nullable
    private CloudTextureData textureData;
    @Nullable
    private CloudGeometry builtGeometry;

    public CloudRenderer(ResourceProvider resourceProvider) {
        this.reload(resourceProvider);
    }

    public void render(Camera camera, ClientLevel level, Matrix4f projectionMatrix, Matrix4f modelView, float ticks, float tickDelta, int color) {
        VertexBuffer vertexBuffer;
        float height = level.effects().getCloudHeight() + 0.33f;
        if (Float.isNaN(height)) {
            return;
        }
        if (this.textureData == null) {
            return;
        }
        Vec3 cameraPos = camera.getPosition();
        int renderDistance = CloudRenderer.getCloudRenderDistance();
        CloudStatus renderMode = Minecraft.getInstance().options.getCloudsType();
        double worldX = cameraPos.x + (double)(ticks + tickDelta) * 0.03;
        double worldZ = cameraPos.z + 3.96;
        double textureWidth = (float)this.textureData.width * 12.0f;
        double textureHeight = (float)this.textureData.height * 12.0f;
        worldX -= (double)Mth.floor((double)(worldX / textureWidth)) * textureWidth;
        worldZ -= (double)Mth.floor((double)(worldZ / textureHeight)) * textureHeight;
        int cellX = Mth.floor((double)(worldX / 12.0));
        int cellZ = Mth.floor((double)(worldZ / 12.0));
        ViewOrientation orientation = renderMode == CloudStatus.FANCY ? ViewOrientation.getOrientation(cameraPos, height, height + 4.0f) : null;
        CloudGeometryParameters parameters = new CloudGeometryParameters(cellX, cellZ, renderDistance, orientation, renderMode);
        CloudGeometry geometry = this.builtGeometry;
        if (geometry == null || !Objects.equals(geometry.params(), parameters)) {
            this.builtGeometry = geometry = CloudRenderer.rebuildGeometry(geometry, parameters, this.textureData);
        }
        if ((vertexBuffer = geometry.vertexBuffer()) == null) {
            return;
        }
        float viewPosX = (float)(worldX - (double)((float)cellX * 12.0f));
        float viewPosY = (float)cameraPos.y() - height;
        float viewPosZ = (float)(worldZ - (double)((float)cellZ * 12.0f));
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)modelView);
        modelViewMatrix.translate(-viewPosX, -viewPosY, -viewPosZ);
        FogParameters prevFogParameters = CloudRenderer.copyShaderFogParameters(RenderSystem.getShaderFog());
        boolean flat = geometry.params().renderMode() == CloudStatus.FAST;
        FogParameters fogParameters = FogRenderer.setupFog((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (Vector4f)new Vector4f(prevFogParameters.red(), prevFogParameters.green(), prevFogParameters.blue(), prevFogParameters.alpha()), (float)(renderDistance * 8), (boolean)CloudRenderer.shouldUseWorldFog(level, cameraPos), (float)tickDelta);
        RenderSystem.setShaderColor((float)ARGB.redFloat((int)color), (float)ARGB.greenFloat((int)color), (float)ARGB.blueFloat((int)color), (float)0.8f);
        RenderSystem.setShaderFog((FogParameters)fogParameters);
        RenderTarget renderTarget = Minecraft.getInstance().levelRenderer.getCloudsTarget();
        if (renderTarget != null) {
            renderTarget.bindWrite(false);
        } else {
            Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader((ShaderProgram)CLOUDS_SHADER);
        if (flat) {
            RenderSystem.disableCull();
        }
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)513);
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(modelViewMatrix, projectionMatrix, RenderSystem.getShader());
        VertexBuffer.unbind();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        if (flat) {
            RenderSystem.enableCull();
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        if (renderTarget != null) {
            Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        }
        RenderSystem.setShaderFog((FogParameters)prevFogParameters);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @NotNull
    private static CloudGeometry rebuildGeometry(@Nullable CloudGeometry existingGeometry, CloudGeometryParameters parameters, CloudTextureData textureData) {
        int layer;
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)bufferBuilder);
        int radius = parameters.radius();
        ViewOrientation orientation = parameters.orientation();
        boolean flat = parameters.renderMode() == CloudStatus.FAST;
        CloudTextureData.Slice slice = textureData.slice(parameters.originX(), parameters.originZ(), radius);
        CloudRenderer.addCellGeometryToBuffer(writer, slice, 0, 0, orientation, flat);
        for (layer = 1; layer <= radius; ++layer) {
            int x;
            int z;
            for (z = -layer; z < layer; ++z) {
                x = Math.abs(z) - layer;
                CloudRenderer.addCellGeometryToBuffer(writer, slice, x, z, orientation, flat);
            }
            for (z = layer; z > -layer; --z) {
                x = layer - Math.abs(z);
                CloudRenderer.addCellGeometryToBuffer(writer, slice, x, z, orientation, flat);
            }
        }
        for (layer = radius + 1; layer <= 2 * radius; ++layer) {
            int x;
            int z;
            int l = layer - radius;
            for (z = -radius; z <= -l; ++z) {
                x = -z - layer;
                CloudRenderer.addCellGeometryToBuffer(writer, slice, x, z, orientation, flat);
            }
            for (z = l; z <= radius; ++z) {
                x = z - layer;
                CloudRenderer.addCellGeometryToBuffer(writer, slice, x, z, orientation, flat);
            }
            for (z = radius; z >= l; --z) {
                x = layer - z;
                CloudRenderer.addCellGeometryToBuffer(writer, slice, x, z, orientation, flat);
            }
            for (z = -l; z >= -radius; --z) {
                x = layer + z;
                CloudRenderer.addCellGeometryToBuffer(writer, slice, x, z, orientation, flat);
            }
        }
        @Nullable MeshData meshData = bufferBuilder.build();
        VertexBuffer vertexBuffer = null;
        if (existingGeometry != null) {
            vertexBuffer = existingGeometry.vertexBuffer();
        }
        if (meshData != null) {
            if (vertexBuffer == null) {
                vertexBuffer = new VertexBuffer(BufferUsage.DYNAMIC_WRITE);
            }
            CloudRenderer.uploadToVertexBuffer(vertexBuffer, meshData);
        } else if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
        Tesselator.getInstance().clear();
        return new CloudGeometry(vertexBuffer, parameters);
    }

    private static void addCellGeometryToBuffer(VertexBufferWriter writer, CloudTextureData.Slice textureData, int x, int z, @Nullable ViewOrientation orientation, boolean flat) {
        int index = textureData.getCellIndex(x, z);
        int faces = textureData.getCellFaces(index) & CloudRenderer.getVisibleFaces(x, z, orientation);
        if (faces == 0) {
            return;
        }
        int color = textureData.getCellColor(index);
        if (CloudRenderer.isTransparent(color)) {
            return;
        }
        if (flat) {
            CloudRenderer.emitCellGeometryFlat(writer, color, x, z);
        } else {
            CloudRenderer.emitCellGeometryExterior(writer, faces, color, x, z);
            if (CloudRenderer.taxicabDistance(x, z) <= 1) {
                CloudRenderer.emitCellGeometryInterior(writer, color, x, z);
            }
        }
    }

    private static int getVisibleFaces(int x, int z, ViewOrientation orientation) {
        int faces = 0;
        if (x <= 0) {
            faces |= 8;
        }
        if (z <= 0) {
            faces |= 0x20;
        }
        if (x >= 0) {
            faces |= 4;
        }
        if (z >= 0) {
            faces |= 0x10;
        }
        if (orientation != ViewOrientation.BELOW_CLOUDS) {
            faces |= 2;
        }
        if (orientation != ViewOrientation.ABOVE_CLOUDS) {
            faces |= 1;
        }
        return faces;
    }

    private static void emitCellGeometryFlat(VertexBufferWriter writer, int texel, int x, int z) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long vertexBuffer;
            long ptr = vertexBuffer = stack.nmalloc(64);
            float x0 = (float)x * 12.0f;
            float x1 = x0 + 12.0f;
            float z0 = (float)z * 12.0f;
            float z1 = z0 + 12.0f;
            int color = ColorABGR.mulRGB(texel, BRIGHTNESS_POS_Y);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, color);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, color);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, color);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, color);
            writer.push(stack, vertexBuffer, 4, ColorVertex.FORMAT);
        }
    }

    private static void emitCellGeometryExterior(VertexBufferWriter writer, int cellFaces, int cellColor, int cellX, int cellZ) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            int vertexColor;
            long vertexBuffer = stack.nmalloc(384);
            int vertexCount = 0;
            long ptr = vertexBuffer;
            float x0 = (float)cellX * 12.0f;
            float y0 = 0.0f;
            float z0 = (float)cellZ * 12.0f;
            float x1 = x0 + 12.0f;
            float y1 = 4.0f;
            float z1 = z0 + 12.0f;
            if ((cellFaces & 1) != 0) {
                vertexColor = ColorABGR.mulRGB(cellColor, BRIGHTNESS_NEG_Y);
                ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, vertexColor);
                ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, vertexColor);
                ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, vertexColor);
                ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, vertexColor);
                vertexCount += 4;
            }
            if ((cellFaces & 2) != 0) {
                vertexColor = ColorABGR.mulRGB(cellColor, BRIGHTNESS_POS_Y);
                ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z1, vertexColor);
                ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z1, vertexColor);
                ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z0, vertexColor);
                ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z0, vertexColor);
                vertexCount += 4;
            }
            if ((cellFaces & 0xC) != 0) {
                vertexColor = ColorABGR.mulRGB(cellColor, BRIGHTNESS_X_AXIS);
                if ((cellFaces & 4) != 0) {
                    ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z0, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, vertexColor);
                    vertexCount += 4;
                }
                if ((cellFaces & 8) != 0) {
                    ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z0, vertexColor);
                    vertexCount += 4;
                }
            }
            if ((cellFaces & 0x30) != 0) {
                vertexColor = ColorABGR.mulRGB(cellColor, BRIGHTNESS_Z_AXIS);
                if ((cellFaces & 0x10) != 0) {
                    ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z0, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z0, vertexColor);
                    vertexCount += 4;
                }
                if ((cellFaces & 0x20) != 0) {
                    ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, vertexColor);
                    vertexCount += 4;
                }
            }
            writer.push(stack, vertexBuffer, vertexCount, ColorVertex.FORMAT);
        }
    }

    private static void emitCellGeometryInterior(VertexBufferWriter writer, int baseColor, int cellX, int cellZ) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long vertexBuffer;
            long ptr = vertexBuffer = stack.nmalloc(384);
            float x0 = (float)cellX * 12.0f;
            float y0 = 0.0f;
            float z0 = (float)cellZ * 12.0f;
            float x1 = x0 + 12.0f;
            float y1 = 4.0f;
            float z1 = z0 + 12.0f;
            int vertexColor = ColorABGR.mulRGB(baseColor, BRIGHTNESS_NEG_Y);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, vertexColor);
            vertexColor = ColorABGR.mulRGB(baseColor, BRIGHTNESS_POS_Y);
            ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z1, vertexColor);
            vertexColor = ColorABGR.mulRGB(baseColor, BRIGHTNESS_X_AXIS);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z1, vertexColor);
            vertexColor = ColorABGR.mulRGB(baseColor, BRIGHTNESS_Z_AXIS);
            ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, vertexColor);
            writer.push(stack, vertexBuffer, 24, ColorVertex.FORMAT);
        }
    }

    private static long writeVertex(long buffer, float x, float y, float z, int color) {
        ColorVertex.put(buffer, x, y, z, color);
        return buffer + 16L;
    }

    private static void uploadToVertexBuffer(VertexBuffer vertexBuffer, MeshData builtBuffer) {
        vertexBuffer.bind();
        vertexBuffer.upload(builtBuffer);
        VertexBuffer.unbind();
    }

    public void reload(ResourceProvider resourceProvider) {
        this.destroy();
        this.textureData = CloudRenderer.loadTextureData(resourceProvider);
    }

    public void destroy() {
        if (this.builtGeometry != null) {
            VertexBuffer vertexBuffer = this.builtGeometry.vertexBuffer();
            if (vertexBuffer != null) {
                vertexBuffer.close();
            }
            this.builtGeometry = null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static CloudTextureData loadTextureData(ResourceProvider resourceProvider) {
        Resource resource = (Resource)resourceProvider.getResource(CLOUDS_TEXTURE_ID).orElseThrow();
        try (InputStream inputStream = resource.open();){
            CloudTextureData cloudTextureData;
            block14: {
                NativeImage nativeImage = NativeImage.read((InputStream)inputStream);
                try {
                    cloudTextureData = CloudTextureData.load(nativeImage);
                    if (nativeImage == null) break block14;
                }
                catch (Throwable throwable) {
                    if (nativeImage != null) {
                        try {
                            nativeImage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                nativeImage.close();
            }
            return cloudTextureData;
        }
        catch (Throwable t) {
            LOGGER.error("Failed to load texture '{}'. The rendering of clouds in the skybox will be disabled. This may be caused by an incompatible resource pack.", (Object)CLOUDS_TEXTURE_ID, (Object)t);
            return null;
        }
    }

    private static boolean shouldUseWorldFog(ClientLevel level, Vec3 pos) {
        return level.effects().isFoggyAt(Mth.floor((double)pos.x()), Mth.floor((double)pos.z())) || Minecraft.getInstance().gui.getBossOverlay().shouldCreateWorldFog();
    }

    private static int getCloudRenderDistance() {
        return Math.max(32, Minecraft.getInstance().options.getEffectiveRenderDistance() * 2 + 9);
    }

    private static boolean isTransparent(int argb) {
        return ColorARGB.unpackAlpha(argb) < 10;
    }

    private static int taxicabDistance(int x, int z) {
        return Math.abs(x) + Math.abs(z);
    }

    private static FogParameters copyShaderFogParameters(FogParameters shaderFog) {
        return new FogParameters(shaderFog.start(), shaderFog.end(), shaderFog.shape(), shaderFog.red(), shaderFog.green(), shaderFog.blue(), shaderFog.alpha());
    }

    private static class CloudTextureData {
        private final byte[] faces;
        private final int[] colors;
        private final int width;
        private final int height;

        private CloudTextureData(int width, int height) {
            this.faces = new byte[width * height];
            this.colors = new int[width * height];
            this.width = width;
            this.height = height;
        }

        public Slice slice(int originX, int originY, int radius) {
            CloudTextureData src = this;
            Slice dst = new Slice(radius);
            for (int dstY = 0; dstY < dst.height; ++dstY) {
                int length;
                int srcX = Math.floorMod(originX - radius, this.width);
                int srcY = Math.floorMod(originY - radius + dstY, this.height);
                for (int dstX = 0; dstX < dst.width; dstX += length) {
                    length = Math.min(src.width - srcX, dst.width - dstX);
                    int srcPos = CloudTextureData.getCellIndex(srcX, srcY, src.width);
                    int dstPos = CloudTextureData.getCellIndex(dstX, dstY, dst.width);
                    System.arraycopy(this.faces, srcPos, dst.faces, dstPos, length);
                    System.arraycopy(this.colors, srcPos, dst.colors, dstPos, length);
                    srcX = 0;
                }
            }
            return dst;
        }

        @Nullable
        public static CloudTextureData load(NativeImage image) {
            int height;
            int width = image.getWidth();
            CloudTextureData data = new CloudTextureData(width, height = image.getHeight());
            if (!data.loadTextureData(image, width, height)) {
                return null;
            }
            return data;
        }

        private boolean loadTextureData(NativeImage texture, int width, int height) {
            Validate.isTrue((this.width == width ? 1 : 0) != 0);
            Validate.isTrue((this.height == height ? 1 : 0) != 0);
            boolean containsData = false;
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < height; ++z) {
                    int color = texture.getPixel(x, z);
                    if (CloudRenderer.isTransparent(color)) continue;
                    int index = CloudTextureData.getCellIndex(x, z, width);
                    this.colors[index] = color;
                    this.faces[index] = (byte)CloudTextureData.getOpenFaces(texture, color, x, z);
                    containsData = true;
                }
            }
            return containsData;
        }

        private static int getOpenFaces(NativeImage image, int color, int x, int z) {
            int faces = 3;
            int neighbor = CloudTextureData.getNeighborTexel(image, x - 1, z);
            if (color != neighbor) {
                faces |= 4;
            }
            if (color != (neighbor = CloudTextureData.getNeighborTexel(image, x + 1, z))) {
                faces |= 8;
            }
            if (color != (neighbor = CloudTextureData.getNeighborTexel(image, x, z - 1))) {
                faces |= 0x10;
            }
            if (color != (neighbor = CloudTextureData.getNeighborTexel(image, x, z + 1))) {
                faces |= 0x20;
            }
            return faces;
        }

        private static int getNeighborTexel(NativeImage image, int x, int z) {
            x = CloudTextureData.wrapTexelCoord(x, 0, image.getWidth() - 1);
            z = CloudTextureData.wrapTexelCoord(z, 0, image.getHeight() - 1);
            return image.getPixel(x, z);
        }

        private static int wrapTexelCoord(int coord, int min, int max) {
            if (coord < min) {
                coord = max;
            }
            if (coord > max) {
                coord = min;
            }
            return coord;
        }

        private static int getCellIndex(int x, int z, int pitch) {
            return z * pitch + x;
        }

        public static class Slice {
            private final int width;
            private final int height;
            private final int radius;
            private final byte[] faces;
            private final int[] colors;

            public Slice(int radius) {
                this.width = 1 + radius * 2;
                this.height = 1 + radius * 2;
                this.radius = radius;
                this.faces = new byte[this.width * this.height];
                this.colors = new int[this.width * this.height];
            }

            public int getCellIndex(int x, int z) {
                return CloudTextureData.getCellIndex(x + this.radius, z + this.radius, this.width);
            }

            public int getCellFaces(int index) {
                return Byte.toUnsignedInt(this.faces[index]);
            }

            public int getCellColor(int index) {
                return this.colors[index];
            }
        }
    }

    private static enum ViewOrientation {
        BELOW_CLOUDS,
        INSIDE_CLOUDS,
        ABOVE_CLOUDS;


        @NotNull
        public static ViewOrientation getOrientation(Vec3 camera, float minY, float maxY) {
            if (camera.y() <= (double)(minY + 0.125f)) {
                return BELOW_CLOUDS;
            }
            if (camera.y() >= (double)(maxY - 0.125f)) {
                return ABOVE_CLOUDS;
            }
            return INSIDE_CLOUDS;
        }
    }

    public record CloudGeometryParameters(int originX, int originZ, int radius, @Nullable ViewOrientation orientation, CloudStatus renderMode) {
    }

    public record CloudGeometry(@Nullable VertexBuffer vertexBuffer, CloudGeometryParameters params) {
    }
}

