/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.model;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import net.caffeinemc.mods.sodium.mixin.platform.neoforge.ChunkRenderTypeSetAccessor;
import net.caffeinemc.mods.sodium.mixin.platform.neoforge.SimpleBakedModelAccessor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.MultipartModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MultiPartBakedModel.class})
public class MultiPartBakedModelMixin {
    @Unique
    private final Map<BlockState, BakedModel[]> stateCacheFast = new Reference2ReferenceOpenHashMap();
    @Unique
    private final StampedLock lock = new StampedLock();
    @Shadow
    @Final
    private List<MultiPartBakedModel.Selector> selectors;
    @Unique
    private boolean canSkipRenderTypeCheck;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void storeClassInfo(List<MultiPartBakedModel.Selector> selectors, CallbackInfo ci) {
        this.canSkipRenderTypeCheck = this.selectors.stream().allMatch(model -> {
            SimpleBakedModel simpleModel;
            BakedModel patt0$temp = model.model();
            return patt0$temp instanceof SimpleBakedModel && ((SimpleBakedModelAccessor)(simpleModel = (SimpleBakedModel)patt0$temp)).getBlockRenderTypes() == null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public List<BakedQuad> getQuads(@javax.annotation.Nullable BlockState state, @javax.annotation.Nullable Direction direction, RandomSource random, ModelData modelData, @Nullable RenderType renderType) {
        BakedModel[] models;
        if (state == null) {
            return Collections.emptyList();
        }
        long readStamp = this.lock.readLock();
        try {
            models = this.stateCacheFast.get(state);
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
        if (models == null) {
            long writeStamp = this.lock.writeLock();
            try {
                ArrayList<BakedModel> modelList = new ArrayList<BakedModel>(this.selectors.size());
                for (MultiPartBakedModel.Selector selector : this.selectors) {
                    if (!selector.condition().test(state)) continue;
                    modelList.add(selector.model());
                }
                models = (BakedModel[])modelList.toArray(BakedModel[]::new);
                this.stateCacheFast.put(state, models);
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        long seed = random.nextLong();
        for (BakedModel model : models) {
            random.setSeed(seed);
            if (!this.canSkipRenderTypeCheck && renderType != null && !model.getRenderTypes(state, random, modelData).contains(renderType)) continue;
            quads.addAll(model.getQuads(state, direction, random, MultipartModelData.resolve((ModelData)modelData, (BakedModel)model), renderType));
        }
        return quads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource random, @NotNull ModelData data) {
        BakedModel[] models;
        long seed = random.nextLong();
        if (this.canSkipRenderTypeCheck) {
            return ItemBlockRenderTypes.getRenderLayers((BlockState)state);
        }
        long readStamp = this.lock.readLock();
        try {
            models = this.stateCacheFast.get(state);
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
        if (models == null) {
            long writeStamp = this.lock.writeLock();
            try {
                ArrayList<BakedModel> modelList = new ArrayList<BakedModel>(this.selectors.size());
                for (MultiPartBakedModel.Selector selector : this.selectors) {
                    if (!selector.condition().test(state)) continue;
                    modelList.add(selector.model());
                }
                models = (BakedModel[])modelList.toArray(BakedModel[]::new);
                this.stateCacheFast.put(state, models);
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }
        BitSet bits = new BitSet();
        for (BakedModel model : models) {
            random.setSeed(seed);
            bits.or(((ChunkRenderTypeSetAccessor)model.getRenderTypes(state, random, data)).getBits());
        }
        return ChunkRenderTypeSetAccessor.create(bits);
    }
}

