/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.block.gel;

import com.legacy.structure_gel.api.block.gel.GelSpreadBehaviorType;
import com.legacy.structure_gel.api.block.gel.StructureGelBlock;
import com.legacy.structure_gel.api.registry.StructureGelRegistries;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;

public interface GelSpreadBehavior {
    public static final Codec<GelSpreadBehavior> CODEC = StructureGelRegistries.GEL_SPREAD_BEHAVIOR.byNameCodec().dispatch(GelSpreadBehavior::getType, GelSpreadBehaviorType::codec);

    public GelSpreadBehaviorType getType();

    public List<Vec3i> getSpreadOffsets(Context var1);

    public MutableComponent getTooltip();

    public static class InitialAxisSpread
    implements GelSpreadBehavior {
        public static final InitialAxisSpread INSTANCE = new InitialAxisSpread();
        public static final MapCodec<InitialAxisSpread> CODEC = MapCodec.unit((Object)INSTANCE);

        @Override
        public GelSpreadBehaviorType getType() {
            return SGRegistry.GelSpreadBehaviors.INITIAL_AXIS.get();
        }

        @Override
        public List<Vec3i> getSpreadOffsets(Context context) {
            ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
            for (Direction d : Direction.values()) {
                if (!context.initialAxis.map(a -> a != d.getAxis()).orElse(true).booleanValue()) continue;
                offsets.add(d.getUnitVec3i());
            }
            return offsets;
        }

        @Override
        public MutableComponent getTooltip() {
            return StructureGelBlock.legacyTranslation("axis_spread", new Object[0]);
        }
    }

    public static class FaceAndEdgeSpread
    implements GelSpreadBehavior {
        public static final FaceAndEdgeSpread INSTANCE = new FaceAndEdgeSpread();
        public static final MapCodec<FaceAndEdgeSpread> CODEC = MapCodec.unit((Object)INSTANCE);

        @Override
        public GelSpreadBehaviorType getType() {
            return SGRegistry.GelSpreadBehaviors.FACE_AND_EDGE.get();
        }

        @Override
        public List<Vec3i> getSpreadOffsets(Context context) {
            List<Vec3i> offsets = new FaceSpread().getSpreadOffsets(context);
            offsets.addAll(new EdgeSpread().getSpreadOffsets(context));
            return offsets;
        }

        @Override
        public MutableComponent getTooltip() {
            return StructureGelBlock.legacyTranslation("diagonal_spread", new Object[0]);
        }
    }

    public static class EdgeSpread
    implements GelSpreadBehavior {
        public static final EdgeSpread INSTANCE = new EdgeSpread();
        public static final MapCodec<EdgeSpread> CODEC = MapCodec.unit((Object)INSTANCE);

        @Override
        public GelSpreadBehaviorType getType() {
            return SGRegistry.GelSpreadBehaviors.EDGE.get();
        }

        @Override
        public List<Vec3i> getSpreadOffsets(Context context) {
            ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
            for (Direction v : Direction.Plane.VERTICAL) {
                for (Direction h : Direction.Plane.HORIZONTAL) {
                    offsets.add(h.getUnitVec3i().offset(v.getUnitVec3i()));
                }
            }
            for (Direction h : Direction.Plane.HORIZONTAL) {
                offsets.add(h.getUnitVec3i().offset(h.getClockWise().getUnitVec3i()));
            }
            return offsets;
        }

        @Override
        public MutableComponent getTooltip() {
            return StructureGelBlock.legacyTranslation("edge_spread", new Object[0]);
        }
    }

    public static class FaceSpread
    implements GelSpreadBehavior {
        public static final FaceSpread INSTANCE = new FaceSpread();
        public static final MapCodec<FaceSpread> CODEC = MapCodec.unit((Object)INSTANCE);

        @Override
        public GelSpreadBehaviorType getType() {
            return SGRegistry.GelSpreadBehaviors.FACE.get();
        }

        @Override
        public List<Vec3i> getSpreadOffsets(Context context) {
            ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
            for (Direction dir : Direction.values()) {
                offsets.add(dir.getUnitVec3i());
            }
            return offsets;
        }

        @Override
        public MutableComponent getTooltip() {
            return StructureGelBlock.legacyTranslation("default", new Object[0]);
        }
    }

    public record Context(BlockPos spreadFrom, Optional<Direction.Axis> initialAxis) {
    }
}

