/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.block.gel;

import com.legacy.structure_gel.api.block.gel.GelSpreadRestrictionType;
import com.legacy.structure_gel.api.block.gel.StructureGelBlock;
import com.legacy.structure_gel.api.registry.StructureGelRegistries;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;

public interface GelSpreadRestriction {
    public static final Codec<GelSpreadRestriction> CODEC = StructureGelRegistries.GEL_SPREAD_RESTRICTION.byNameCodec().dispatch(GelSpreadRestriction::getType, GelSpreadRestrictionType::codec);

    public GelSpreadRestrictionType getType();

    public boolean isPermitted(Context var1);

    public MutableComponent getTooltip();

    public static class ItemStackDistance
    implements GelSpreadRestriction {
        public static final ItemStackDistance INSTANCE = new ItemStackDistance();
        public static final MapCodec<ItemStackDistance> CODEC = MapCodec.unit((Object)INSTANCE);

        @Override
        public GelSpreadRestrictionType getType() {
            return SGRegistry.GelSpreadRestrictions.ITEM_STACK_COUNT_DISTANCE.get();
        }

        @Override
        public boolean isPermitted(Context context) {
            return new DistanceRestriction(context.placer.getCount()).isPermitted(context);
        }

        @Override
        public MutableComponent getTooltip() {
            return StructureGelBlock.legacyTranslation("dynamic_spread_dist", new Object[0]);
        }
    }

    public record DistanceRestriction(int maxDistance) implements GelSpreadRestriction
    {
        public static final MapCodec<DistanceRestriction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("max_distance").forGetter(DistanceRestriction::maxDistance)).apply((Applicative)instance, DistanceRestriction::new));
        public static final DistanceRestriction FIFTY = new DistanceRestriction(50);

        @Override
        public GelSpreadRestrictionType getType() {
            return SGRegistry.GelSpreadRestrictions.DISTANCE.get();
        }

        @Override
        public boolean isPermitted(Context context) {
            return context.sourcePos.closerToCenterThan((Position)context.placePos.getCenter(), (double)this.maxDistance);
        }

        @Override
        public MutableComponent getTooltip() {
            return StructureGelBlock.legacyTranslation("max_distance", this.maxDistance);
        }
    }

    public static class NoSkyRestriction
    implements GelSpreadRestriction {
        public static final NoSkyRestriction INSTANCE = new NoSkyRestriction();
        public static final MapCodec<NoSkyRestriction> CODEC = MapCodec.unit((Object)INSTANCE);

        @Override
        public GelSpreadRestrictionType getType() {
            return SGRegistry.GelSpreadRestrictions.NO_SKY_VISIBILITY.get();
        }

        @Override
        public boolean isPermitted(Context context) {
            LevelReader level = context.level;
            BlockPos pos = context.placePos;
            if (level.canSeeSky(pos)) {
                return false;
            }
            int dy = 1;
            while (pos.above(dy).getY() < level.getMaxY()) {
                if (!level.isEmptyBlock(pos.above(dy))) {
                    return true;
                }
                ++dy;
            }
            return false;
        }

        @Override
        public MutableComponent getTooltip() {
            return StructureGelBlock.legacyTranslation("photosensitive", new Object[0]);
        }
    }

    public record Context(LevelReader level, BlockPos sourcePos, ItemStack placer, BlockPos placePos) {
    }
}

