/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.block.gel;

import com.legacy.structure_gel.api.block.gel.GelSpreadBehavior;
import com.legacy.structure_gel.api.block.gel.GelSpreadRestriction;
import com.legacy.structure_gel.api.data.tags.SGTags;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.SGText;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StructureGelBlock
extends Block {
    public static final MapCodec<StructureGelBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StructureGelBlock.propertiesCodec(), (App)GelSpreadBehavior.CODEC.fieldOf("spread_behavior").forGetter(g -> g.spreadBehavior), (App)GelSpreadRestriction.CODEC.listOf().fieldOf("spread_restrictions").forGetter(g -> g.spreadRestrictions), (App)BlockState.CODEC.optionalFieldOf("replacement_state").forGetter(g -> g.replacementState)).apply((Applicative)instance, StructureGelBlock::new));
    public static final EnumMap<Direction, EnumProperty<Neighbor>> NEIGHBORS = (EnumMap)Util.make(new EnumMap(Direction.class), map -> {
        for (Direction dir : Direction.values()) {
            map.put(dir, EnumProperty.create((String)dir.getSerializedName(), Neighbor.class));
        }
    });
    public static final BooleanProperty DECAY = BooleanProperty.create((String)"decay");
    protected final GelSpreadBehavior spreadBehavior;
    protected final List<GelSpreadRestriction> spreadRestrictions;
    protected final Optional<BlockState> replacementState;

    public StructureGelBlock(BlockBehaviour.Properties properties, GelSpreadBehavior spreadSides, List<GelSpreadRestriction> spreadRestrictions, Optional<BlockState> replacementState) {
        super(properties);
        this.spreadBehavior = spreadSides;
        this.spreadRestrictions = spreadRestrictions;
        this.replacementState = replacementState;
        BlockState defaultState = (BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DECAY, (Comparable)Boolean.valueOf(false));
        for (Direction dir : Direction.values()) {
            defaultState = (BlockState)defaultState.setValue((Property)NEIGHBORS.get(dir), (Comparable)((Object)Neighbor.EMPTY));
        }
        this.registerDefaultState(defaultState);
    }

    public StructureGelBlock(BlockBehaviour.Properties properties, GelSpreadBehavior spreadSides, List<GelSpreadRestriction> spreadRestrictions) {
        this(properties, spreadSides, spreadRestrictions, Optional.empty());
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        for (EnumProperty<Neighbor> val : NEIGHBORS.values()) {
            builder.add(new Property[]{val});
        }
        builder.add(new Property[]{DECAY});
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction updateDir, BlockPos updatePos, BlockState updateState, RandomSource rand) {
        EnumProperty<Neighbor> prop = NEIGHBORS.get(updateDir);
        Neighbor oldNeighbor = (Neighbor)((Object)state.getValue(prop));
        Neighbor newNeighbor = Neighbor.from(updateState);
        if (oldNeighbor == Neighbor.BLOCK && newNeighbor == Neighbor.EMPTY) {
            newNeighbor = Neighbor.SPREAD;
            tickAccess.scheduleTick(pos, (Block)this, 0);
        }
        return (BlockState)state.setValue(prop, (Comparable)((Object)newNeighbor));
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)DECAY)).booleanValue()) {
            this.setNeighborDecay((Level)level, pos, state);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        } else {
            for (Direction dir : Direction.values()) {
                BlockPos offset;
                EnumProperty<Neighbor> prop = NEIGHBORS.get(dir);
                Neighbor neighbor = (Neighbor)((Object)state.getValue(prop));
                if (neighbor != Neighbor.SPREAD || !level.getBlockState(offset = pos.relative(dir)).isAir()) continue;
                StructureGelBlock.placeGel(level, this, offset);
            }
        }
    }

    public static boolean placeGel(ServerLevel level, Block gel, BlockPos pos) {
        return level.setBlock(pos, StructureGelBlock.getStateForPosition((LevelReader)level, gel, pos), 3);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getPlayer().isShiftKeyDown()) {
            return ((Block)SGRegistry.Blocks.GEL_SPREADER.get()).getStateForPlacement(context);
        }
        return StructureGelBlock.getStateForPosition((LevelReader)context.getLevel(), this, context.getClickedPos());
    }

    public static BlockState getStateForPosition(LevelReader level, Block gel, BlockPos pos) {
        BlockState state = gel.defaultBlockState();
        for (Direction dir : Direction.values()) {
            state = (BlockState)state.setValue((Property)NEIGHBORS.get(dir), (Comparable)((Object)Neighbor.from(level.getBlockState(pos.relative(dir)))));
        }
        return state;
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.isCreative() && stack.is(Items.GUNPOWDER)) {
            StructureGelBlock.scheduleRemoval(level, pos, state);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.isCreative()) {
            this.setNeighborDecay(level, pos, state);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void setNeighborDecay(Level level, BlockPos pos, BlockState state) {
        for (Vec3i offset : this.spreadBehavior.getSpreadOffsets(new GelSpreadBehavior.Context(pos, Optional.empty()))) {
            BlockPos offsetPos = pos.offset(offset);
            BlockState neighbor = level.getBlockState(offsetPos);
            if (!neighbor.hasProperty((Property)DECAY) || !neighbor.is((Block)this) && !neighbor.is((Block)SGRegistry.Blocks.GEL_SPREADER.get())) continue;
            StructureGelBlock.scheduleRemoval(level, offsetPos, neighbor);
        }
    }

    public static void scheduleRemoval(Level level, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)DECAY, (Comparable)Boolean.valueOf(true)), 4);
        level.scheduleTick(pos, state.getBlock(), 1);
    }

    public GelSpreadBehavior getSpreadBehavior() {
        return this.spreadBehavior;
    }

    public List<GelSpreadRestriction> getSpreadRestrictions() {
        return this.spreadRestrictions;
    }

    public BlockState getReplacementState() {
        return this.replacementState.orElse(Blocks.AIR.defaultBlockState());
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (SGConfig.COMMON.advancedGelBehavior()) {
            Player player;
            EntityCollisionContext eContext;
            Entity entity;
            if (context == CollisionContext.empty() || context instanceof EntityCollisionContext && (entity = (eContext = (EntityCollisionContext)context).getEntity()) instanceof Player && ((player = (Player)entity).isShiftKeyDown() || player.isHolding(stack -> stack.is(SGTags.ItemTags.GEL_INTERACTABLE)) || !player.isCreative())) {
                return Shapes.block();
            }
            return Shapes.empty();
        }
        return Shapes.block();
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        if (SGConfig.COMMON.advancedGelBehavior()) {
            Player player = context.getPlayer();
            return player == null || !player.isShiftKeyDown() && !context.getItemInHand().is(SGTags.ItemTags.GEL);
        }
        return false;
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction side) {
        return adjacentState.is((Block)this) || adjacentState.is((Block)SGRegistry.Blocks.GEL_SPREADER.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag advancedTooltips) {
        if (!Screen.hasShiftDown()) {
            tooltip.add(SGText.applyKeybindFilter((Component)StructureGelBlock.legacyTranslation("hold_shift", new Object[0])));
        } else {
            tooltip.add((Component)StructureGelBlock.legacyTranslation("place", new Object[0]));
            tooltip.add((Component)StructureGelBlock.legacyTranslation("gunpowder", new Object[0]));
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)StructureGelBlock.legacyTranslation("spread_behavior", new Object[0]).withStyle(ChatFormatting.LIGHT_PURPLE).withStyle(ChatFormatting.UNDERLINE));
            tooltip.add((Component)this.spreadBehavior.getTooltip());
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)StructureGelBlock.legacyTranslation("spread_restrictions", new Object[0]).withStyle(ChatFormatting.LIGHT_PURPLE).withStyle(ChatFormatting.UNDERLINE));
            for (GelSpreadRestriction r : this.spreadRestrictions) {
                tooltip.add((Component)r.getTooltip());
            }
        }
    }

    public static MutableComponent legacyTranslation(String key, Object ... args) {
        return Component.translatable((String)("info.structure_gel." + key), (Object[])args).withStyle(ChatFormatting.GRAY);
    }

    public static enum Neighbor implements StringRepresentable
    {
        EMPTY("empty", s -> s.isAir() || s.is(SGTags.BlockTags.GEL)),
        BLOCK("block", s -> true),
        SPREAD("spread", s -> false);

        public static final Codec<Neighbor> CODEC;
        final String name;
        final Predicate<BlockState> blockPredicate;

        private Neighbor(String name, Predicate<BlockState> blockPredicate) {
            this.name = name;
            this.blockPredicate = blockPredicate;
        }

        public String getSerializedName() {
            return this.name;
        }

        public boolean test(BlockState state) {
            return this.blockPredicate.test(state);
        }

        public static Neighbor from(BlockState state) {
            for (Neighbor n : Neighbor.values()) {
                if (!n.test(state)) continue;
                return n;
            }
            return BLOCK;
        }

        static {
            CODEC = StringRepresentable.fromValues(Neighbor::values);
        }
    }
}

