/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.block_entity;

import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.SpawnData;

public class SpawnerAccessHelper {
    public static void setMinSpawnDelay(BaseSpawner spawner, int minSpawnDelay) {
        spawner.minSpawnDelay = minSpawnDelay;
    }

    public static void setMaxSpawnDelay(BaseSpawner spawner, int maxSpawnDelay) {
        spawner.maxSpawnDelay = maxSpawnDelay;
    }

    public static void setSpawnCount(BaseSpawner spawner, int spawnCount) {
        spawner.spawnCount = spawnCount;
    }

    public static void setMaxNearbyEntities(BaseSpawner spawner, int maxNearbyEntities) {
        spawner.maxNearbyEntities = maxNearbyEntities;
    }

    public static void setRequiredPlayerRange(BaseSpawner spawner, int requiredPlayerRange) {
        spawner.requiredPlayerRange = requiredPlayerRange;
    }

    public static void setSpawnRange(BaseSpawner spawner, int spawnRange) {
        spawner.spawnRange = spawnRange;
    }

    public static void setSpawnPotentials(BaseSpawner spawner, EntityType<?> entityType) {
        SpawnerAccessHelper.setSpawnPotentials(spawner, SpawnerAccessHelper.createSpawnerEntity(entityType));
    }

    public static void setSpawnPotentials(BaseSpawner spawner, SpawnData ... spawnData) {
        SimpleWeightedRandomList list = ((SimpleWeightedRandomList.Builder)Util.make((Object)new SimpleWeightedRandomList.Builder(), builder -> {
            for (SpawnData data : spawnData) {
                builder.add((Object)data, 1);
            }
        })).build();
        SpawnerAccessHelper.setSpawnPotentials(spawner, (SimpleWeightedRandomList<SpawnData>)list);
    }

    public static void setSpawnPotentials(BaseSpawner spawner, SimpleWeightedRandomList<SpawnData> spawnData) {
        spawner.spawnPotentials = spawnData;
    }

    public static SpawnData createSpawnerEntity(EntityType<?> entity) {
        return SpawnerAccessHelper.createSpawnerEntity(entity, new CompoundTag(), Optional.empty(), Optional.empty());
    }

    public static SpawnData createSpawnerEntity(EntityType<?> entity, CompoundTag entityTag, Optional<SpawnData.CustomSpawnRules> customSpawnRules, Optional<EquipmentTable> equipment) {
        CompoundTag nbt = entityTag.copy();
        ResourceLocation name = BuiltInRegistries.ENTITY_TYPE.getKey(entity);
        nbt.putString("id", name != null ? BuiltInRegistries.ENTITY_TYPE.getKey(entity).toString() : "pig");
        return new SpawnData(nbt, customSpawnRules, equipment);
    }
}

