/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigValueWrapper<O, P>
implements Supplier<P> {
    private static final Multimap<String, ConfigValueWrapper<?, ?>> LISTENERS = HashMultimap.create();
    private final ModConfigSpec.ConfigValue<O> configValue;
    private final Function<O, P> parseFunction;
    private P cached = null;
    private boolean resolved = false;

    public static <O, P> ConfigValueWrapper<O, P> create(ModConfigSpec.ConfigValue<O> configValue, Function<O, P> parseFunction, IEventBus modEventBus, String modID) {
        return new ConfigValueWrapper<O, P>(configValue, parseFunction, modEventBus, modID);
    }

    public static <O> ConfigValueWrapper<O, O> create(ModConfigSpec.ConfigValue<O> configValue, IEventBus modEventBus, String modID) {
        return ConfigValueWrapper.create(configValue, Function.identity(), modEventBus, modID);
    }

    private ConfigValueWrapper(ModConfigSpec.ConfigValue<O> configValue, Function<O, P> parseFunction, IEventBus modEventBus, String modID) {
        this.configValue = configValue;
        this.parseFunction = parseFunction;
        LISTENERS.put((Object)modID, (Object)this);
        if (!LISTENERS.containsKey((Object)modID)) {
            modEventBus.register(ConfigValueWrapper.class);
        }
    }

    @Override
    public P get() {
        if (!this.resolved) {
            this.cached = this.parseFunction.apply(this.configValue.get());
            this.resolved = true;
        }
        return this.cached;
    }

    public P getDefault() {
        return this.parseFunction.apply(this.configValue.getDefault());
    }

    public ModConfigSpec.ConfigValue<O> getConfigValue() {
        return this.configValue;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    protected void clearCache() {
        this.cached = null;
        this.resolved = false;
    }

    @SubscribeEvent
    protected static void onConfigLoad(ModConfigEvent.Loading event) {
        LISTENERS.get((Object)event.getConfig().getModId()).forEach(ConfigValueWrapper::clearCache);
    }

    @SubscribeEvent
    protected static void onConfigReload(ModConfigEvent.Reloading event) {
        LISTENERS.get((Object)event.getConfig().getModId()).forEach(ConfigValueWrapper::clearCache);
    }
}

