/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.data_handler.parsing;

import com.google.common.collect.ImmutableList;
import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.parsing.DataMap;
import com.legacy.structure_gel.api.registry.StructureGelRegistries;
import com.legacy.structure_gel.core.client.ClientUtil;
import com.legacy.structure_gel.core.network.SGPacketHandler;
import com.legacy.structure_gel.core.network.c_to_s.RequestRegistryKeysPacket;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class DataParser {
    private final List<Parser<?>> parsers;
    public final ResourceLocation dataHandlerType;

    private DataParser(ResourceLocation dataHandlerType, List<Parser<?>> parsers) {
        this.parsers = ImmutableList.copyOf(parsers);
        this.dataHandlerType = dataHandlerType;
    }

    public static Factory of(Consumer<Builder> buildFunc) {
        return (t, r) -> {
            Builder builder = new Builder(t, r);
            buildFunc.accept(builder);
            return builder.build();
        };
    }

    public DataMap parse(Map<String, String> input, LevelReader level) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Parser<?> parser : this.parsers) {
            String key = parser.key;
            String rawVal = input.get(key);
            if (rawVal != null) {
                Object parsedVal = parser.parse(rawVal, level);
                data.put(key, parsedVal);
                continue;
            }
            data.put(key, parser.defaultVal);
        }
        return new DataMap(data);
    }

    public List<Parser<?>> getParsers() {
        return Collections.unmodifiableList(this.parsers);
    }

    @Nullable
    private static ResourceLocation parseResourceLocation(String key) {
        return ResourceLocation.tryParse((String)key);
    }

    @Nullable
    private static BlockState parseBlockState(String key, LevelReader level) {
        try {
            BlockState state = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK, (StringReader)new StringReader(key), (boolean)false).blockState();
            return state.getBlock().isEnabled(level.enabledFeatures()) ? state : null;
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    @Nullable
    private static ItemStack parseItemStack(String key, LevelReader level) {
        try {
            ItemParser.ItemResult result;
            ItemInput item;
            ItemStack itemStack;
            String itemString;
            int count = 1;
            int firstSpace = key.indexOf(32);
            if (firstSpace > 0 && key.startsWith("x")) {
                String countText = key.substring(1, firstSpace).trim();
                try {
                    count = Integer.parseInt(countText);
                    itemString = key.substring(firstSpace).trim();
                }
                catch (NumberFormatException e) {
                    itemString = key.trim();
                }
            } else {
                itemString = key.trim();
            }
            return (itemStack = (item = new ItemInput((result = new ItemParser((HolderLookup.Provider)level.registryAccess()).parse(new StringReader(itemString))).item(), result.components())).createItemStack(count, false)).isItemEnabled(level.enabledFeatures()) ? itemStack : null;
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    @Nullable
    private static CompoundTag parseTag(String key) {
        try {
            return new TagParser(new StringReader(key)).readStruct();
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    @Nullable
    public static <T> ResourceKey<T> parseResourceKey(ResourceKey<Registry<T>> registry, String key) {
        ResourceLocation location = ResourceLocation.tryParse((String)key);
        if (location != null) {
            return ResourceKey.create(registry, (ResourceLocation)location);
        }
        return null;
    }

    public static interface Factory {
        public DataParser build(DataHandlerType<?> var1, HolderLookup.Provider var2);
    }

    public static class Parser<T> {
        public final String name;
        public final String key;
        public final ParseFunc<T> parseFunc;
        @Nullable
        public final T defaultVal;
        public final Class<T> type;
        public final String typeName;
        public final ParseValidator validator;
        @Nullable
        private String example;
        @Nullable
        private DefaultValue defaultValName;
        private Supplier<Collection<T>> suggestions = () -> Collections.emptyList();
        private Function<T, String> toStringFunc = Object::toString;

        public Parser(ResourceLocation dataHandlerType, String key, ParseFunc<T> parseFunc, @Nullable T defaultVal, Class<T> type, String typeName, ParseValidator validator) {
            this.name = dataHandlerType.toString() + "." + key;
            this.key = key;
            this.parseFunc = parseFunc;
            this.defaultVal = defaultVal;
            this.type = type;
            this.typeName = typeName;
            this.validator = validator;
        }

        public <S> Parser<T> setSuggestions(Supplier<Collection<T>> suggestions, Function<T, String> toStringFunc) {
            this.suggestions = suggestions;
            this.toStringFunc = toStringFunc;
            return this;
        }

        public Collection<T> getSuggestions() {
            return this.suggestions.get();
        }

        public Function<T, String> getSuggestionToString() {
            return this.toStringFunc;
        }

        public Parser<T> setExample(@Nullable String example) {
            this.example = example;
            return this;
        }

        public Parser<T> setDefaultValName(@Nullable String defaultValName) throws IllegalArgumentException {
            return this.setDefaultValName(defaultValName, Objects::equals);
        }

        public Parser<T> setDefaultValName(@Nullable String defaultValName, BiPredicate<T, T> equalsFunc) throws IllegalArgumentException {
            this.defaultValName = defaultValName == null && this.defaultVal == null ? l -> "null" : l -> {
                if (!this.validator.test(defaultValName, l)) {
                    throw new IllegalArgumentException("The defaultValName for " + this.name + " was not valid: " + defaultValName);
                }
                T parsedVal = this.parseFunc.parse(defaultValName, l);
                if (this.defaultVal == null && this.defaultVal != parsedVal || !equalsFunc.test(this.defaultVal, parsedVal)) {
                    throw new IllegalArgumentException("The defaultValName for " + this.name + " did not equal the defaultVal. defaultVal: " + String.valueOf(this.defaultVal) + ", parsedVal: " + String.valueOf(parsedVal) + " from: " + defaultValName);
                }
                return defaultValName;
            };
            return this;
        }

        @Nullable
        public String getExample() {
            return this.example;
        }

        public String getDefaultValName(LevelReader level) {
            if (this.defaultValName == null) {
                this.defaultValName = l -> this.defaultVal == null ? "empty" : this.toStringFunc.apply(this.defaultVal);
            }
            return this.defaultValName.get(level);
        }

        @Nullable
        public T parse(String value, LevelReader level) {
            try {
                T ret = this.parseFunc.parse(value, level);
                return ret != null ? ret : this.defaultVal;
            }
            catch (Exception e) {
                return this.defaultVal;
            }
        }

        public String getTranlsationKey(String labelType) {
            return "gui.structure_gel.data_handler." + this.name + "." + labelType;
        }

        public String toString() {
            return "DataParser[key=" + this.key + ", type=" + this.typeName + "]";
        }
    }

    public static final class Builder {
        private final List<Parser<?>> parsers = new ArrayList();
        private final ResourceLocation dataHandlerType;
        private final HolderLookup.Provider registryAccess;

        public Builder(DataHandlerType<?> dataHandlerType, HolderLookup.Provider registryAccess) {
            ResourceLocation key = StructureGelRegistries.DATA_HANDLER_TYPE.getKey(dataHandlerType);
            if (key == null) {
                throw new IllegalStateException("The data handler type passed was not registered " + String.valueOf(dataHandlerType));
            }
            this.dataHandlerType = key;
            this.registryAccess = registryAccess;
        }

        public DataParser build() {
            return new DataParser(this.dataHandlerType, this.parsers);
        }

        public NumberParser<Byte> addByte(String key, byte defaultVal, byte min, byte max) {
            return this.addNumber(key, Byte::valueOf, defaultVal, Byte.class, "byte", min, max, (val, range) -> val >= (Byte)range.getLeft() && val <= (Byte)range.getRight());
        }

        public NumberParser<Short> addShort(String key, short defaultVal, short min, short max) {
            return this.addNumber(key, Short::valueOf, defaultVal, Short.class, "short", min, max, (val, range) -> val >= (Short)range.getLeft() && val <= (Short)range.getRight());
        }

        public NumberParser<Integer> add(String key, int defaultVal, int min, int max) {
            return this.addNumber(key, Integer::valueOf, defaultVal, Integer.class, "int", min, max, (val, range) -> val >= (Integer)range.getLeft() && val <= (Integer)range.getRight());
        }

        public NumberParser<Float> add(String key, float defaultVal, float min, float max) {
            return this.addNumber(key, Float::valueOf, Float.valueOf(defaultVal), Float.class, "float", Float.valueOf(min), Float.valueOf(max), (val, range) -> val.floatValue() >= ((Float)range.getLeft()).floatValue() && val.floatValue() <= ((Float)range.getRight()).floatValue());
        }

        public NumberParser<Double> add(String key, double defaultVal, double min, double max) {
            return this.addNumber(key, Double::valueOf, defaultVal, Double.class, "double", min, max, (val, range) -> val >= (Double)range.getLeft() && val <= (Double)range.getRight());
        }

        public Parser<Boolean> add(String key, boolean defaultVal) {
            return this.add(key, (s, l) -> Boolean.valueOf(s), defaultVal, Boolean.class, "boolean");
        }

        public Parser<String> add(String key, @Nullable String defaultVal) {
            return this.add(key, (s, l) -> s, defaultVal, String.class, "String");
        }

        public Parser<ResourceLocation> add(String key, @Nullable ResourceLocation defaultVal) {
            return this.add(key, (s, l) -> DataParser.parseResourceLocation(s), defaultVal, ResourceLocation.class, "ResourceLocation");
        }

        public Parser<Direction> add(String key, @Nullable Direction defaultVal) {
            return this.addEnum(key, Direction.class, defaultVal);
        }

        public Parser<Direction.Axis> add(String key, @Nullable Direction.Axis defaultVal) {
            return this.addEnum(key, Direction.Axis.class, defaultVal);
        }

        public <T extends Enum<T>> Parser<T> addEnum(String key, Class<T> clazz, @Nullable T defaultVal) {
            return this.add(key, (s, l) -> {
                for (Enum v : (Enum[])clazz.getEnumConstants()) {
                    if (!s.equals(((StringRepresentable)v).getSerializedName())) continue;
                    return v;
                }
                return null;
            }, defaultVal, clazz, clazz.getSimpleName()).setDefaultValName(defaultVal != null ? ((StringRepresentable)defaultVal).getSerializedName() : null);
        }

        public Parser<BlockState> add(String key, @Nullable BlockState defaultVal) {
            String defaultValName = null;
            if (defaultVal != null) {
                defaultValName = BlockStateParser.serialize((BlockState)defaultVal);
            }
            return this.add(key, DataParser::parseBlockState, defaultVal, BlockState.class, "BlockState").setDefaultValName(defaultValName).setExample("minecraft:chest[facing=east]");
        }

        public Parser<ItemStack> add(String key, @Nullable ItemStack defaultVal) {
            ResourceLocation id;
            ItemStack defaultClone = null;
            Object defaultValName = null;
            if (defaultVal != null && (id = (ResourceLocation)(defaultClone = defaultVal.copy()).getItemHolder().unwrapKey().map(ResourceKey::location).orElse(null)) != null) {
                defaultValName = id.toString();
                int count = defaultClone.getCount();
                count = 2;
                if (count > 1) {
                    defaultValName = "x" + count + " " + (String)defaultValName;
                }
            }
            return this.add(key, DataParser::parseItemStack, defaultClone, ItemStack.class, "ItemStack").setDefaultValName((String)defaultValName, (a, b) -> a == b || a.getCount() == b.getCount() && ItemStack.isSameItem((ItemStack)a, (ItemStack)b)).setExample("x64 minecraft:diamond[components]");
        }

        public Parser<CompoundTag> add(String key, @Nullable CompoundTag defaultVal) {
            return this.add(key, (s, l) -> DataParser.parseTag(s), defaultVal, CompoundTag.class, "CompoundTag").setDefaultValName(defaultVal != null ? defaultVal.getAsString() : null).setExample("{key:\"value\", id:0, list:[0, 1, 2]}");
        }

        public <T> ResourceKeyParser<ResourceKey<T>> add(String key, @Nonnull ResourceKey<T> defaultVal) throws NullPointerException {
            if (defaultVal == null) {
                throw new NullPointerException("defaultVal cannot be null for " + String.valueOf(this.dataHandlerType) + "." + key + " use add(String, ResourceKey<T>, ResourceKey<Registry<T>>)");
            }
            ResourceKey registry = ResourceKey.createRegistryKey((ResourceLocation)defaultVal.registry());
            ResourceKeyParser<ResourceKey<T>> parser = new ResourceKeyParser<ResourceKey<T>>(this.dataHandlerType, key, (s, l) -> DataParser.parseResourceKey(registry, s), defaultVal, registry);
            parser.setDefaultValName(defaultVal != null ? defaultVal.location().toString() : null);
            this.add(parser);
            return parser;
        }

        public <T> ResourceKeyParser<ResourceKey<T>> add(String key, @Nonnull ResourceKey<Registry<T>> registryKey, @Nullable T defaultVal) throws NullPointerException {
            Registry registry = (Registry)BuiltInRegistries.REGISTRY.getValue(registryKey);
            if (registry != null) {
                Optional resourceKey = registry.getResourceKey(defaultVal);
                if (resourceKey.isPresent()) {
                    return this.add(key, (ResourceKey)resourceKey.get());
                }
                throw new NullPointerException("Could not find the defaultVal in the registry: Registry = " + String.valueOf(registryKey.location()));
            }
            throw new NullPointerException("Could not find the registry from the registryKey passed: registryKey = " + String.valueOf(registryKey));
        }

        public <T> Parser<T> add(String key, ParseFunc<T> parser, @Nullable T defaultVal, Class<T> type, String typeName, ParseValidator validator) {
            Parser<T> dataParser = new Parser<T>(this.dataHandlerType, key, parser, defaultVal, type, typeName, validator);
            this.add(dataParser);
            return dataParser;
        }

        public <T> Parser<T> add(String key, ParseFunc<T> parser, @Nullable T defaultVal, Class<T> type, String typeName) {
            return this.add(key, parser, defaultVal, type, typeName, (s, l) -> Objects.nonNull(parser.parse(s, l)));
        }

        public <T extends Number> NumberParser<T> addNumber(String key, Function<String, T> parser, @Nullable T defaultVal, Class<T> type, String typeName, T minVal, T maxVal, BiPredicate<T, Pair<T, T>> rangeTest) {
            NumberParser<T> numParser = new NumberParser<T>(this.dataHandlerType, key, parser, defaultVal, type, typeName, minVal, maxVal, rangeTest);
            this.add(numParser);
            return numParser;
        }

        public void add(Parser<?> parser) throws IllegalStateException, IllegalArgumentException {
            for (Parser<?> p : this.parsers) {
                if (!p.name.equals(parser.name)) continue;
                throw new IllegalArgumentException("Attempted to add a parser under an existing name for " + String.valueOf(this.dataHandlerType) + ". " + String.valueOf(parser));
            }
            this.parsers.add(parser);
        }
    }

    public static interface DefaultValue {
        public String get(LevelReader var1);
    }

    public static interface ParseValidator {
        public boolean test(String var1, LevelReader var2);
    }

    public static interface ParseFunc<T> {
        @Nullable
        public T parse(String var1, LevelReader var2);
    }

    public static class ResourceKeyParser<T>
    extends Parser<ResourceKey<T>> {
        private ResourceKey<Registry<T>> registry;

        public ResourceKeyParser(ResourceLocation dataHandlerType, String key, ParseFunc<ResourceKey<T>> parseFunc, @Nullable ResourceKey<T> defaultVal, ResourceKey<Registry<T>> registry) {
            super(dataHandlerType, key, parseFunc, defaultVal, ResourceKey.class, "Registry: " + String.valueOf(registry.location()), (s, l) -> Objects.nonNull(parseFunc.parse(s, l)));
            this.registry = registry;
        }

        public ResourceKey<Registry<T>> getRegistry() {
            return this.registry;
        }

        @Override
        public Collection<ResourceKey<T>> getSuggestions() {
            List<ResourceKey<?>> suggestions = ClientUtil.REGISTRY_KEYS.get(this.registry);
            if (suggestions == null) {
                SGPacketHandler.sendToServer(new RequestRegistryKeysPacket(this.registry));
            }
            return suggestions == null ? super.getSuggestions() : suggestions;
        }
    }

    public static class NumberParser<T extends Number>
    extends Parser<T> {
        private T minVal;
        private T maxVal;

        public NumberParser(ResourceLocation dataHandlerType, String key, Function<String, T> parseFunc, T defaultVal, Class<T> type, String typeName, T minVal, T maxVal, BiPredicate<T, Pair<T, T>> rangeTest) {
            super(dataHandlerType, key, (s, l) -> (Number)parseFunc.apply(s), defaultVal, type, typeName, NumberParser.validator((s, l) -> (Number)parseFunc.apply(s), minVal, maxVal, rangeTest));
            this.minVal = minVal;
            this.maxVal = maxVal;
        }

        public T getMin() {
            return this.minVal;
        }

        public T getMax() {
            return this.maxVal;
        }

        private static <T extends Number> ParseValidator validator(ParseFunc<T> func, T minVal, T maxVal, BiPredicate<T, Pair<T, T>> rangeTest) {
            return (s, l) -> {
                try {
                    Number val = (Number)func.parse(s, l);
                    return rangeTest.test(val, Pair.of((Object)minVal, (Object)maxVal));
                }
                catch (Exception e) {
                    return false;
                }
            };
        }
    }
}

