/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.item;

import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public interface StructureFinderItem {
    default public int searchRange() {
        return 100;
    }

    @Nullable
    default public BlockPos findAndStoreStructure(ItemStack stack, ServerLevel level, BlockPos searchPos) {
        Pair nearest;
        Optional holder;
        ResourceKey<Structure> structure = this.getStructure(stack);
        if (structure != null && (holder = level.registryAccess().lookupOrThrow(Registries.STRUCTURE).get(structure)).isPresent() && (nearest = level.getChunkSource().getGenerator().findNearestMapStructure(level, (HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)holder.get()}), searchPos, this.searchRange(), false)) != null) {
            BlockPos pos = (BlockPos)nearest.getFirst();
            this.setStructurePos(stack, pos);
            this.setStructureDimension(stack, (ResourceKey<Level>)level.dimension());
            return pos;
        }
        return null;
    }

    @Nullable
    default public ResourceKey<Structure> getStructure(ItemStack stack) {
        return (ResourceKey)stack.get(SGRegistry.DataComponents.STRUCTURE);
    }

    default public void setStructure(ItemStack stack, @Nullable ResourceKey<Structure> structure) {
        if (structure == null) {
            stack.remove(SGRegistry.DataComponents.STRUCTURE);
        } else {
            stack.set(SGRegistry.DataComponents.STRUCTURE, structure);
        }
    }

    @Nullable
    default public Optional<GlobalPos> getStructureLocation(ItemStack stack) {
        return Optional.ofNullable((GlobalPos)stack.get(SGRegistry.DataComponents.STRUCTURE_LOCATION));
    }

    default public void setStructureLocation(ItemStack stack, Optional<GlobalPos> location) {
        if (location.isPresent()) {
            stack.set(SGRegistry.DataComponents.STRUCTURE_LOCATION, (Object)location.get());
        } else {
            stack.remove(SGRegistry.DataComponents.STRUCTURE_LOCATION);
        }
    }

    @Nullable
    default public BlockPos getStructurePos(ItemStack stack) {
        return this.getStructureLocation(stack).map(GlobalPos::pos).orElse(null);
    }

    default public void setStructurePos(ItemStack stack, @Nullable BlockPos structurePos) {
        if (structurePos == null) {
            this.setStructureLocation(stack, null);
        } else {
            this.setStructureLocation(stack, this.getStructureLocation(stack).map(g -> new GlobalPos(g.dimension(), structurePos)));
        }
    }

    @Nullable
    default public ResourceKey<Level> getStructureDimension(ItemStack stack) {
        return this.getStructureLocation(stack).map(GlobalPos::dimension).orElse(null);
    }

    default public void setStructureDimension(ItemStack stack, @Nullable ResourceKey<Level> dimension) {
        if (dimension == null) {
            this.setStructureLocation(stack, null);
        } else {
            this.setStructureLocation(stack, this.getStructureLocation(stack).map(g -> new GlobalPos(dimension, g.pos())));
        }
    }
}

