/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class RegistryHelper {
    public static <T> Optional<T> get(LevelAccessor level, ResourceKey<T> key) {
        return RegistryHelper.get(level.registryAccess(), key);
    }

    public static <T> Optional<T> get(RegistryAccess registries, ResourceKey<T> key) {
        return RegistryHelper.get(registries, key.registryKey(), key);
    }

    public static <T> Optional<T> get(RegistryAccess registries, ResourceKey<Registry<T>> registryKey, ResourceKey<T> key) {
        return registries.lookup(registryKey).map(r -> r.get(key).map(Holder::value).orElse(null));
    }

    public static <T> boolean isInTag(Registry<T> registry, TagKey<T> tagKey, T object) {
        Optional holder;
        Optional key = registry.getResourceKey(object);
        if (key.isPresent() && (holder = registry.get((ResourceKey)key.get())).isPresent()) {
            Optional tag = registry.get(tagKey);
            return tag.isPresent() ? ((HolderSet.Named)tag.get()).contains((Holder)holder.get()) : false;
        }
        return false;
    }

    public static <T> boolean isInTag(RegistryAccess registryAccess, ResourceKey<Registry<T>> registryKey, TagKey<T> tagKey, T object) {
        Optional registry = registryAccess.get(registryKey);
        return registry.isPresent() ? RegistryHelper.isInTag((Registry)((Holder.Reference)registry.get()).value(), tagKey, object) : false;
    }

    @SafeVarargs
    public static StructureProcessorList combineProcessors(StructureProcessorList ... structureProcessors) {
        ArrayList processors = new ArrayList();
        for (StructureProcessorList spl : structureProcessors) {
            processors.addAll(spl.list());
        }
        return new StructureProcessorList(processors);
    }

    public static StructureProcessorList combineProcessors(StructureProcessorList structureProcessorList, StructureProcessor ... structureProcessors) {
        ArrayList<StructureProcessor> processors = new ArrayList<StructureProcessor>(structureProcessorList.list());
        processors.addAll(Arrays.asList(structureProcessors));
        return new StructureProcessorList(processors);
    }
}

